/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import management.CertificateManager;
import th.co.oga.security.pki.Certification.CertFileFilter;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Operation.SecureStoreException;
import ui.TCDSecureSuite;
import ui.ca.CertificateStoreManager;

public class CertFileExport
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JLabel lblSubject = null;
    private JLabel lblIssuer = null;
    private JLabel lblSerial = null;
    private JLabel lblSubjectData = null;
    private JLabel lblIssuerData = null;
    private JLabel lblSerialData = null;
    private JPanel pnlSpecification = null;
    private ButtonGroup bgpSpecification = null;
    private JRadioButton radSingleCertFile = null;
    private JRadioButton radCertChain = null;
    private JRadioButton radPersonalFileExchange = null;
    private JLabel lblPfxPin = null;
    private JPasswordField pwdPfxPin = null;
    private JLabel lblExportToFile = null;
    private JTextField txtExportToFile = null;
    private JButton btnBrowse = null;
    private JButton btnExport = null;
    private JButton btnCancel = null;
    private JButton btnHelp = null;
    private TCDSecureSuite theSuite = null;
    private CertFileExport thePanel = this;
    private CertProfile cert;
    private JDialog self = this;
    private File selectedFile = null;
    private int exportTab;
    int certIdToExport;

    public CertFileExport(TCDSecureSuite theSuite, int exportGroup, int certIdToExport) {
        this(theSuite, exportGroup, certIdToExport, null);
    }

    public CertFileExport(TCDSecureSuite theSuite, int exportGroup, int certIdToExport, CertProfile cert) {
        this.theSuite = theSuite;
        this.exportTab = exportGroup;
        this.certIdToExport = certIdToExport;
        this.cert = cert;
        this.setName("Certification File Export");
        this.initialise();
        this.setLocationRelativeTo(null);
    }

    private void initialise() {
        Container pane = this.getContentPane();
        pane.setLayout(null);
        this.setTitle("Certificate File Export");
        this.setFont(new Font("sansserif", 0, 10));
        this.setModal(true);
        this.setResizable(false);
        this.setSize(480, 440);
        pane.add((Component)this.getLblSubject(), this.getLblSubject().getName());
        pane.add((Component)this.getLblSubjectData(), this.getLblSubjectData().getName());
        pane.add((Component)this.getLblIssuer(), this.getLblIssuer().getName());
        pane.add((Component)this.getLblIssuerData(), this.getLblIssuerData().getName());
        pane.add((Component)this.getLblSerial(), this.getLblSerial().getName());
        pane.add((Component)this.getLblSerialData(), this.getLblSerialData().getName());
        pane.add((Component)this.getPnlSpecification(), this.getPnlSpecification().getName());
        pane.add((Component)this.getLblExportToFile(), this.getLblExportToFile().getName());
        pane.add((Component)this.getTxtExportToFile(), this.getTxtExportToFile().getName());
        pane.add((Component)this.getBtnBrowse(), this.getBtnBrowse().getName());
        pane.add((Component)this.getBtnExport(), this.getBtnExport().getName());
        pane.add((Component)this.getBtnCancel(), this.getBtnCancel().getName());
        pane.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
        if (this.exportTab == CertificateStoreManager.TAB_AGENT) {
            this.radSingleCertFile.setEnabled(true);
            this.radCertChain.setEnabled(true);
            this.radPersonalFileExchange.setEnabled(true);
            this.lblPfxPin.setEnabled(true);
            this.pwdPfxPin.setEnabled(true);
        } else if (this.exportTab == CertificateStoreManager.TAB_PEOPLE) {
            this.radSingleCertFile.setEnabled(true);
            this.radCertChain.setEnabled(true);
            this.radPersonalFileExchange.setEnabled(false);
            this.lblPfxPin.setEnabled(false);
            this.pwdPfxPin.setEnabled(false);
        } else if (this.exportTab == CertificateStoreManager.TAB_CA) {
            this.radSingleCertFile.setEnabled(true);
            this.radCertChain.setEnabled(false);
            this.radPersonalFileExchange.setEnabled(false);
            this.lblPfxPin.setEnabled(false);
            this.pwdPfxPin.setEnabled(false);
        }
    }

    private JLabel getLblSubject() {
        if (this.lblSubject == null) {
            this.lblSubject = new JLabel("Subject : ");
            this.lblSubject.setBounds(40, 30, 60, 20);
        }
        return this.lblSubject;
    }

    private JLabel getLblSubjectData() {
        if (this.lblSubjectData == null) {
            String certName = this.cert.getX509Cert().getSubjectX500Principal().toString();
            this.lblSubjectData = new JLabel(certName);
            this.lblSubjectData.setBounds(100, 30, 300, 20);
        }
        return this.lblSubjectData;
    }

    private JLabel getLblIssuer() {
        if (this.lblIssuer == null) {
            this.lblIssuer = new JLabel("Issuer : ");
            this.lblIssuer.setBounds(40, 50, 60, 20);
        }
        return this.lblIssuer;
    }

    private JLabel getLblIssuerData() {
        if (this.lblIssuerData == null) {
            String certIssuer = this.cert.getX509Cert().getIssuerX500Principal().toString();
            this.lblIssuerData = new JLabel(certIssuer);
            this.lblIssuerData.setBounds(100, 50, 300, 20);
        }
        return this.lblIssuerData;
    }

    private JLabel getLblSerial() {
        if (this.lblSerial == null) {
            this.lblSerial = new JLabel("Serial : ");
            this.lblSerial.setBounds(40, 70, 60, 20);
        }
        return this.lblSerial;
    }

    private JLabel getLblSerialData() {
        if (this.lblSerialData == null) {
            String certSerial = this.cert.getX509Cert().getSerialNumber().toString();
            this.lblSerialData = new JLabel(certSerial);
            this.lblSerialData.setBounds(100, 70, 300, 20);
        }
        return this.lblSerialData;
    }

    private JPanel getPnlSpecification() {
        if (this.pnlSpecification == null) {
            this.pnlSpecification = new JPanel();
            this.pnlSpecification.setName("pnlSpecification");
            this.pnlSpecification.setLayout(null);
            this.pnlSpecification.setBounds(30, 100, 400, 180);
            this.pnlSpecification.setBorder(new TitledBorder(new LineBorder(new Color(255, 255, 255)), " Specifications : "));
            this.pnlSpecification.add((Component)this.getRadSingleCertFile(), this.getRadSingleCertFile().getName());
            this.pnlSpecification.add((Component)this.getRadCertChain(), this.getRadCertChain().getName());
            this.pnlSpecification.add((Component)this.getRadPersonalFileExchange(), this.getRadPersonalFileExchange().getName());
            this.pnlSpecification.add((Component)this.getLblPfxPin(), this.getLblPfxPin().getName());
            this.pnlSpecification.add((Component)this.getPwdPfxPin(), this.getPwdPfxPin().getName());
        }
        return this.pnlSpecification;
    }

    private ButtonGroup getBgpSpecification() {
        if (this.bgpSpecification == null) {
            this.bgpSpecification = new ButtonGroup();
        }
        return this.bgpSpecification;
    }

    private JRadioButton getRadSingleCertFile() {
        if (this.radSingleCertFile == null) {
            this.radSingleCertFile = new JRadioButton("Single Certificate File (.cer, .der, .pem)");
            this.radSingleCertFile.setName("radSingleCertFile");
            this.radSingleCertFile.setBounds(30, 30, 240, 20);
            this.radSingleCertFile.setSelected(true);
            this.getBgpSpecification().add(this.radSingleCertFile);
        }
        return this.radSingleCertFile;
    }

    private JRadioButton getRadCertChain() {
        if (this.radCertChain == null) {
            this.radCertChain = new JRadioButton("Certificate Chain (.p7, .p7b, .p7c)");
            this.radCertChain.setName("radCertChain");
            this.radCertChain.setBounds(30, 60, 240, 20);
            this.getBgpSpecification().add(this.radCertChain);
        }
        return this.radCertChain;
    }

    private JRadioButton getRadPersonalFileExchange() {
        if (this.radPersonalFileExchange == null) {
            this.radPersonalFileExchange = new JRadioButton("Personal File Exchange (.pfx, .p12)");
            this.radPersonalFileExchange.setName("radPersonalFileExchange");
            this.radPersonalFileExchange.setBounds(30, 90, 240, 20);
            this.getBgpSpecification().add(this.radPersonalFileExchange);
        }
        return this.radPersonalFileExchange;
    }

    private JLabel getLblPfxPin() {
        if (this.lblPfxPin == null) {
            this.lblPfxPin = new JLabel("PFX PIN: ");
            this.lblPfxPin.setBounds(60, 120, 60, 20);
        }
        return this.lblPfxPin;
    }

    private JPasswordField getPwdPfxPin() {
        if (this.pwdPfxPin == null) {
            this.pwdPfxPin = new JPasswordField();
            this.pwdPfxPin.setBounds(130, 120, 60, 20);
        }
        return this.pwdPfxPin;
    }

    private JLabel getLblExportToFile() {
        if (this.lblExportToFile == null) {
            this.lblExportToFile = new JLabel("Export to File : ");
            this.lblExportToFile.setName("lblExportToFile");
            this.lblExportToFile.setBounds(40, 300, 100, 20);
        }
        return this.lblExportToFile;
    }

    private JTextField getTxtExportToFile() {
        if (this.txtExportToFile == null) {
            this.txtExportToFile = new JTextField();
            this.txtExportToFile.setName("txtExportToFile");
            this.txtExportToFile.setBounds(130, 300, 180, 20);
        }
        return this.txtExportToFile;
    }

    private JButton getBtnBrowse() {
        if (this.btnBrowse == null) {
            this.btnBrowse = new JButton("Browse");
            this.btnBrowse.setBounds(320, 300, 100, 20);
            this.btnBrowse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = CertFileExport.this.theSuite.getFileChosser();
                    CertFileFilter filter = new CertFileFilter();
                    fileChooser.resetChoosableFileFilters();
                    fileChooser.setFileFilter((FileFilter)filter);
                    int returnVal = fileChooser.showSaveDialog(CertFileExport.this.self);
                    if (returnVal == 0) {
                        CertFileExport.this.selectedFile = fileChooser.getSelectedFile();
                        CertFileExport.this.txtExportToFile.setText(CertFileExport.this.selectedFile.getPath());
                        CertFileExport.this.btnExport.setEnabled(true);
                    }
                }
            });
        }
        return this.btnBrowse;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton("Export");
            this.btnExport.setBounds(50, 340, 100, 25);
            this.btnExport.setEnabled(false);
            this.btnExport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    CertificateManager manager = CertFileExport.this.theSuite.getCertificateManager();
                    try {
                        if (CertFileExport.this.exportTab == CertificateStoreManager.TAB_AGENT) {
                            if (CertFileExport.this.radSingleCertFile.isSelected()) {
                                manager.exportSingleCertificateFile(CertFileExport.this.selectedFile.getPath(), "USER Certificate", CertFileExport.this.certIdToExport);
                                CertFileExport.this.theSuite.showInformationDialog(CertFileExport.this.thePanel, "The certificate has been exported.");
                                CertFileExport.this.setVisible(false);
                            } else if (CertFileExport.this.radCertChain.isSelected()) {
                                manager.exportChainCertificateFile(CertFileExport.this.selectedFile.getPath(), "USER Certificate", CertFileExport.this.certIdToExport);
                                CertFileExport.this.theSuite.showInformationDialog(CertFileExport.this.thePanel, "The certificate has been exported.");
                                CertFileExport.this.setVisible(false);
                            } else if (CertFileExport.this.radPersonalFileExchange.isSelected()) {
                                int returnValue;
                                String pwd = new String(CertFileExport.this.pwdPfxPin.getPassword());
                                if (pwd.length() == 0 && (returnValue = JOptionPane.showConfirmDialog(null, "Are you sure you want to leave the PIN empty?", "Empty PIN", 0)) == 1) {
                                    return;
                                }
                                manager.exportPfxFile(CertFileExport.this.selectedFile.getPath(), "USER Certificate", CertFileExport.this.certIdToExport, pwd);
                                CertFileExport.this.theSuite.showInformationDialog(CertFileExport.this.thePanel, "The certificate has been exported.");
                                CertFileExport.this.setVisible(false);
                            }
                        } else if (CertFileExport.this.exportTab == CertificateStoreManager.TAB_PEOPLE) {
                            if (CertFileExport.this.radSingleCertFile.isSelected()) {
                                manager.exportSingleCertificateFile(CertFileExport.this.selectedFile.getPath(), "TRUSTED Certificate", CertFileExport.this.certIdToExport);
                                CertFileExport.this.theSuite.showInformationDialog(CertFileExport.this.thePanel, "The certificate has been exported.");
                                CertFileExport.this.setVisible(false);
                            } else if (CertFileExport.this.radCertChain.isSelected()) {
                                manager.exportChainCertificateFile(CertFileExport.this.selectedFile.getPath(), "TRUSTED Certificate", CertFileExport.this.certIdToExport);
                                CertFileExport.this.theSuite.showInformationDialog(CertFileExport.this.thePanel, "The certificate has been exported.");
                                CertFileExport.this.setVisible(false);
                            }
                        } else if (CertFileExport.this.exportTab == CertificateStoreManager.TAB_CA) {
                            manager.exportSingleCertificateFile(CertFileExport.this.selectedFile.getPath(), "CA Certificate", CertFileExport.this.certIdToExport);
                            CertFileExport.this.theSuite.showInformationDialog(CertFileExport.this.thePanel, "The certificate has been exported.");
                            CertFileExport.this.setVisible(false);
                        }
                    }
                    catch (CertPackageException e) {
                        CertFileExport.this.theSuite.showErrorDialog(CertFileExport.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (SecureStoreException e) {
                        CertFileExport.this.theSuite.showErrorDialog(CertFileExport.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        CertFileExport.this.theSuite.showErrorDialog(CertFileExport.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btnExport;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton("Cancel");
            this.btnCancel.setBounds(160, 340, 100, 25);
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    CertFileExport.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton("Help");
            this.btnHelp.setBounds(270, 340, 100, 25);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: certfileexprot.html");
                    CertFileExport.this.theSuite.showHelp("Help", "certfileexport.html");
                }
            });
        }
        return this.btnHelp;
    }
}

