/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import management.CertificateManager;
import th.co.oga.security.pki.Certification.CertFileFilter;
import th.co.oga.security.pki.Certification.CertPackageEncodingFormatNotSupportException;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertPackageTypeNotSupportException;
import th.co.oga.security.pki.Operation.SecureStoreException;
import ui.TCDSecureSuite;

public class CertFileImport
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JLabel lblCertFile = null;
    private JTextField txtCertFile = null;
    private JButton btnBrowse = null;
    private JPanel pnlSpecification = null;
    private ButtonGroup bgpSpecification = null;
    private JRadioButton radSingleCertFile = null;
    private JRadioButton radCertChain = null;
    private JRadioButton radPersonalFileExchange = null;
    private JLabel lblPfxPin = null;
    private JPasswordField pwdPfxPin = null;
    private JLabel lblCertGroup = null;
    private JComboBox cbxCertGroup = null;
    private JButton btnImport = null;
    private JButton btnCancel = null;
    private JButton btnHelp = null;
    private TCDSecureSuite theSuite = null;
    private final CertFileImport theDialog = this;
    private File selectedFile = null;
    private int currentTab;

    public CertFileImport(TCDSecureSuite theSuite, int currentTab) {
        this.theSuite = theSuite;
        this.currentTab = currentTab;
        this.setName("Certificate File Import");
        this.initialise();
        this.setLocationRelativeTo(null);
        this.btnImport.setEnabled(false);
    }

    private void initialise() {
        Container pane = this.getContentPane();
        pane.setLayout(null);
        this.setTitle("Certificate File Import");
        this.setFont(new Font("sansserif", 0, 10));
        this.setModal(true);
        this.setResizable(false);
        this.setSize(480, 440);
        pane.add((Component)this.getLblCertFile(), this.getLblCertFile().getName());
        pane.add((Component)this.getTxtCertFile(), this.getTxtCertFile().getName());
        pane.add((Component)this.getBtnBrowse(), this.getBtnBrowse().getName());
        pane.add((Component)this.getPnlSpecification(), this.getPnlSpecification().getName());
        pane.add((Component)this.getLblCertGroup(), this.getLblCertGroup().getName());
        pane.add((Component)this.getCbxCertGroup(), this.getCbxCertGroup().getName());
        pane.add((Component)this.getBtnImport(), this.getBtnImport().getName());
        pane.add((Component)this.getBtnCancel(), this.getBtnCancel().getName());
        pane.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
    }

    private JLabel getLblCertFile() {
        if (this.lblCertFile == null) {
            this.lblCertFile = new JLabel("Cert File : ");
            this.lblCertFile.setName("lblCertFile");
            this.lblCertFile.setBounds(30, 30, 60, 20);
        }
        return this.lblCertFile;
    }

    private JTextField getTxtCertFile() {
        if (this.txtCertFile == null) {
            this.txtCertFile = new JTextField();
            this.txtCertFile.setName("txtCertFile");
            this.txtCertFile.setBounds(100, 30, 220, 20);
        }
        return this.txtCertFile;
    }

    private JButton getBtnBrowse() {
        if (this.btnBrowse == null) {
            this.btnBrowse = new JButton("Browse");
            this.btnBrowse.setBounds(330, 30, 100, 20);
            this.btnBrowse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = CertFileImport.this.theSuite.getFileChosser();
                    CertFileFilter filter = new CertFileFilter();
                    fileChooser.resetChoosableFileFilters();
                    fileChooser.setFileFilter((FileFilter)filter);
                    int returnVal = fileChooser.showOpenDialog(CertFileImport.this.theSuite);
                    if (returnVal == 0) {
                        CertFileImport.this.selectedFile = fileChooser.getSelectedFile();
                        String filename = CertFileImport.this.selectedFile.getName();
                        if (filename.toLowerCase().endsWith(".cer") || filename.toLowerCase().endsWith(".der") || filename.toLowerCase().endsWith(".pem")) {
                            CertFileImport.this.radSingleCertFile.setSelected(true);
                        } else if (filename.toLowerCase().endsWith(".p7") || filename.toLowerCase().endsWith(".p7b") || filename.toLowerCase().endsWith(".p7c")) {
                            CertFileImport.this.radCertChain.setSelected(true);
                        } else if (filename.toLowerCase().endsWith(".pfx") || filename.toLowerCase().endsWith(".p12")) {
                            CertFileImport.this.radPersonalFileExchange.setSelected(true);
                        }
                        CertFileImport.this.txtCertFile.setText(CertFileImport.this.selectedFile.getPath());
                        CertFileImport.this.btnImport.setEnabled(true);
                    }
                }
            });
        }
        return this.btnBrowse;
    }

    private JPanel getPnlSpecification() {
        if (this.pnlSpecification == null) {
            this.pnlSpecification = new JPanel();
            this.pnlSpecification.setName("pnlSpecification");
            this.pnlSpecification.setLayout(null);
            this.pnlSpecification.setBounds(30, 70, 400, 180);
            this.pnlSpecification.setBorder(new TitledBorder(new LineBorder(new Color(255, 255, 255)), " Specifications : "));
            this.pnlSpecification.add((Component)this.getRadSingleCertFile(), this.getRadSingleCertFile().getName());
            this.pnlSpecification.add((Component)this.getRadCertChain(), this.getRadCertChain().getName());
            this.pnlSpecification.add((Component)this.getRadPersonalFileExchange(), this.getRadPersonalFileExchange().getName());
            this.pnlSpecification.add((Component)this.getLblPfxPin(), this.getLblPfxPin().getName());
            this.pnlSpecification.add((Component)this.getPwdPfxPin(), this.getPwdPfxPin().getName());
        }
        return this.pnlSpecification;
    }

    private ButtonGroup getBgpSpecification() {
        if (this.bgpSpecification == null) {
            this.bgpSpecification = new ButtonGroup();
        }
        return this.bgpSpecification;
    }

    private JRadioButton getRadSingleCertFile() {
        if (this.radSingleCertFile == null) {
            this.radSingleCertFile = new JRadioButton("Single Certificate File (.cer, .der, .pem)");
            this.radSingleCertFile.setName("radSingleCertFile");
            this.radSingleCertFile.setBounds(30, 30, 240, 20);
            this.getBgpSpecification().add(this.radSingleCertFile);
        }
        return this.radSingleCertFile;
    }

    private JRadioButton getRadCertChain() {
        if (this.radCertChain == null) {
            this.radCertChain = new JRadioButton("Certificate Chain (.p7, .p7b, .p7c)");
            this.radCertChain.setName("radCertChain");
            this.radCertChain.setBounds(30, 60, 240, 20);
            this.getBgpSpecification().add(this.radCertChain);
        }
        return this.radCertChain;
    }

    private JRadioButton getRadPersonalFileExchange() {
        if (this.radPersonalFileExchange == null) {
            this.radPersonalFileExchange = new JRadioButton("Personal File Exchange (.pfx, .p12)");
            this.radPersonalFileExchange.setName("radPersonalFileExchange");
            this.radPersonalFileExchange.setBounds(30, 90, 240, 20);
            this.getBgpSpecification().add(this.radPersonalFileExchange);
        }
        return this.radPersonalFileExchange;
    }

    private JLabel getLblPfxPin() {
        if (this.lblPfxPin == null) {
            this.lblPfxPin = new JLabel("PFX PIN: ");
            this.lblPfxPin.setBounds(60, 120, 60, 20);
        }
        return this.lblPfxPin;
    }

    private JPasswordField getPwdPfxPin() {
        if (this.pwdPfxPin == null) {
            this.pwdPfxPin = new JPasswordField();
            this.pwdPfxPin.setBounds(130, 120, 60, 20);
        }
        return this.pwdPfxPin;
    }

    private JLabel getLblCertGroup() {
        if (this.lblCertGroup == null) {
            this.lblCertGroup = new JLabel("Cert Group : ");
            this.lblCertGroup.setBounds(50, 260, 80, 20);
            this.lblCertGroup.setVisible(false);
        }
        return this.lblCertGroup;
    }

    private JComboBox getCbxCertGroup() {
        if (this.cbxCertGroup == null) {
            this.cbxCertGroup = new JComboBox();
            this.cbxCertGroup.setBounds(140, 260, 270, 20);
            this.cbxCertGroup.setBackground(new Color(255, 255, 255));
            this.cbxCertGroup.addItem("TRUSTED Certificate");
            this.cbxCertGroup.addItem("USER Certificate");
            this.cbxCertGroup.addItem("CA Certificate");
            this.cbxCertGroup.setVisible(false);
        }
        return this.cbxCertGroup;
    }

    private JButton getBtnImport() {
        if (this.btnImport == null) {
            this.btnImport = new JButton("Import");
            this.btnImport.setBounds(70, 300, 100, 25);
        }
        this.btnImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!CertFileImport.this.theDialog.isVisible()) {
                    return;
                }
                if (!(CertFileImport.this.radSingleCertFile.isSelected() || CertFileImport.this.radCertChain.isSelected() || CertFileImport.this.radPersonalFileExchange.isSelected())) {
                    CertFileImport.this.theSuite.showErrorDialog(CertFileImport.this.theDialog, "Please choose a file specfication.");
                    return;
                }
                CertFileImport.this.doImportFile();
                CertFileImport.this.setVisible(false);
            }
        });
        return this.btnImport;
    }

    private void doImportFile() {
        String filename = this.selectedFile.getAbsolutePath();
        String fileExtension = filename.substring(filename.lastIndexOf(".") + 1).toUpperCase();
        CertificateManager manager = this.theSuite.getCertificateManager();
        if (this.radSingleCertFile.isSelected()) {
            try {
                System.out.println("Load single cert file ...");
                System.out.println("File Extension : " + fileExtension);
                manager.importSingleCertificateFile(filename, fileExtension, null);
                this.theSuite.showInformationDialog(this.theDialog, "The certificate has been imported");
                this.theSuite.showCertificateStoreManager(this.currentTab);
                this.setVisible(false);
            }
            catch (CertPackageException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (CertPackageTypeNotSupportException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (CertificateException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (SecureStoreException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (CertPackageEncodingFormatNotSupportException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
        } else if (this.radCertChain.isSelected()) {
            try {
                System.out.println("Load single cert file ...");
                System.out.println("File Extension : " + fileExtension);
                manager.importChainCertificateFile(filename, fileExtension, null);
                this.theSuite.showInformationDialog(this.theDialog, "The certificate has been imported");
                this.theSuite.showCertificateStoreManager(this.currentTab);
                this.setVisible(false);
            }
            catch (CertPackageException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (CertPackageTypeNotSupportException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (CertificateException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (SecureStoreException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (CertPackageEncodingFormatNotSupportException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
        } else if (this.radPersonalFileExchange.isSelected()) {
            try {
                System.out.println("Load der pfx file ... ");
                String password = new String(this.pwdPfxPin.getPassword());
                manager.importPfxFile(filename, password);
                this.theSuite.showInformationDialog(this.theDialog, "The certificate has been imported");
                this.theSuite.showCertificateStoreManager(this.currentTab);
                this.setVisible(false);
            }
            catch (CertPackageException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (CertPackageTypeNotSupportException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (CertificateException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (SecureStoreException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (CertPackageEncodingFormatNotSupportException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (NoSuchProviderException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (KeyStoreException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton("Cancel");
            this.btnCancel.setBounds(180, 300, 100, 25);
        }
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertFileImport.this.setVisible(false);
            }
        });
        return this.btnCancel;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton("Help");
            this.btnHelp.setBounds(290, 300, 100, 25);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: certfileimport.html");
                    CertFileImport.this.theSuite.showHelp("Help", "certfileimport.html");
                }
            });
        }
        return this.btnHelp;
    }
}

