/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import management.CertificateManager;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Certification.CertificationRequestException;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.HouseKeeping.AgentProfileNotInitializedException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.RoomOperationException;
import th.co.oga.security.pki.NameValueInvalidException;
import th.co.oga.security.pki.X500.DName;
import ui.TCDSecureSuite;
import ui.ca.CSROnlineSend;

public class CertificateRequest
extends JPanel {
    private final CertificateRequest thePanel = this;
    private static final long serialVersionUID = 1L;
    private JButton btnGenerate = null;
    private JButton btnSaveToFile = null;
    private JButton btnOnlineSend = null;
    private JButton btnHelp = null;
    private JLabel lblGenerationNo = null;
    private JLabel lblGenerationNoData = null;
    private JLabel lblCertificateRequest = null;
    private JLabel lblCommonName = null;
    private JLabel lblOrganization = null;
    private JLabel lblOrganizationUnit = null;
    private JLabel lblStreetAddress = null;
    private JLabel lblProvince = null;
    private JLabel lblLocality = null;
    private JLabel lblCountry = null;
    private JLabel lblEmailAddress = null;
    private JPanel pnlCsrSubjectName = null;
    private JTextField txtCommonName = null;
    private JTextField txtOrganization = null;
    private JTextField txtOrganizationUnit = null;
    private JTextField txtStreetAddress = null;
    private JTextField txtProvince = null;
    private JTextField txtLocality = null;
    private JTextField txtCountry = null;
    private JTextField txtEmailAddress = null;
    private TCDSecureSuite theSuite = null;
    private String csrSN = null;
    private CSRProfile csrProfile = null;
    private boolean isGenerated = false;

    public CertificateRequest(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.initialise();
    }

    private void initialise() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setName("Certificate Request");
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getBtnGenerate(), this.getBtnGenerate().getName());
        this.add((Component)this.getBtnSaveToFile(), this.getBtnSaveToFile().getName());
        this.add((Component)this.getBtnOnlineSend(), this.getBtnOnlineSend().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
        this.add((Component)this.getPnlCsrSubjectName(), this.getPnlCsrSubjectName().getName());
        this.add((Component)this.getLblGenerationNo(), this.getLblGenerationNo().getName());
        this.add((Component)this.getLblGenerationNoData(), this.getLblGenerationNoData().getName());
        this.add((Component)this.getLblCertificateRequest(), this.getLblCertificateRequest().getName());
        this.putData();
        this.txtCommonName.setEditable(true);
        this.txtOrganization.setEditable(true);
        this.txtOrganizationUnit.setEditable(true);
        this.txtStreetAddress.setEditable(true);
        this.txtProvince.setEditable(true);
        this.txtLocality.setEditable(true);
        this.txtCountry.setEditable(true);
        this.txtEmailAddress.setEditable(true);
        this.btnGenerate.setVisible(false);
        this.btnSaveToFile.setText("Generate");
    }

    private void putData() {
        Room room = this.theSuite.getRoom();
        AgentProfile profile = room.getOwner();
        DName dName = profile.getDName();
        String commonName = dName.getValue(DName.commonName);
        String org = dName.getValue(DName.organizationName);
        String orgUnit = dName.getValue(DName.organizationalUnitName);
        String street = dName.getValue(DName.streetAddressName);
        String province = dName.getValue(DName.stateOrProvinceName);
        String locality = dName.getValue(DName.localityName);
        String country = dName.getValue(DName.countryName);
        String email = dName.getValue(DName.emailAddressName);
        this.txtCommonName.setText(commonName);
        this.txtOrganization.setText(org);
        this.txtOrganizationUnit.setText(orgUnit);
        this.txtStreetAddress.setText(street);
        this.txtProvince.setText(province);
        this.txtLocality.setText(locality);
        this.txtCountry.setText(country);
        this.txtEmailAddress.setText(email);
    }

    private JButton getBtnGenerate() {
        if (this.btnGenerate == null) {
            this.btnGenerate = new JButton();
            this.btnGenerate.setName("btnGenerate");
            this.btnGenerate.setText("Generate");
            this.btnGenerate.setBounds(80, 350, 120, 30);
            this.btnGenerate.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    System.out.println("Generate....");
                    try {
                        CertificateRequest.this.generateCSR();
                    }
                    catch (NameValueInvalidException e1) {
                        CertificateRequest.this.theSuite.showErrorDialog(CertificateRequest.this.thePanel, e1.getMessage());
                    }
                    catch (RoomOperationException e1) {
                        CertificateRequest.this.theSuite.showErrorDialog(CertificateRequest.this.thePanel, e1.getMessage());
                    }
                    catch (CertificationRequestException e1) {
                        CertificateRequest.this.theSuite.showErrorDialog(CertificateRequest.this.thePanel, e1.getMessage());
                    }
                    catch (AgentProfileNotInitializedException e1) {
                        CertificateRequest.this.theSuite.showErrorDialog(CertificateRequest.this.thePanel, e1.getMessage());
                    }
                }
            });
        }
        return this.btnGenerate;
    }

    public CSRProfile generateCSR() throws NameValueInvalidException, RoomOperationException, CertificationRequestException, AgentProfileNotInitializedException {
        DName subj = new DName(this.txtCommonName.getText(), this.txtCountry.getText(), this.txtLocality.getText(), this.txtOrganizationUnit.getText(), this.txtOrganization.getText(), this.txtProvince.getText(), this.txtStreetAddress.getText(), this.txtEmailAddress.getText());
        CertificateManager manager = this.theSuite.getCertificateManager();
        this.csrProfile = manager.requestOfflineGenerate(subj);
        this.csrSN = this.csrProfile.getSN();
        this.lblGenerationNoData.setText(this.csrSN);
        this.isGenerated = true;
        return this.csrProfile;
    }

    private JButton getBtnSaveToFile() {
        if (this.btnSaveToFile == null) {
            this.btnSaveToFile = new JButton();
            this.btnSaveToFile.setName("btnSaveToFile");
            this.btnSaveToFile.setText("Save to File");
            this.btnSaveToFile.setBounds(220, 350, 120, 30);
            this.btnSaveToFile.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    try {
                        if (CertificateRequest.this.csrProfile == null) {
                            CertificateRequest.this.csrProfile = CertificateRequest.this.generateCSR();
                        }
                        CertificateRequest.this.theSuite.showCSRExport(CertificateRequest.this.csrProfile);
                    }
                    catch (NameValueInvalidException e1) {
                        CertificateRequest.this.theSuite.showErrorDialog(CertificateRequest.this.thePanel, e1.getMessage());
                    }
                    catch (RoomOperationException e1) {
                        CertificateRequest.this.theSuite.showErrorDialog(CertificateRequest.this.thePanel, e1.getMessage());
                    }
                    catch (CertificationRequestException e1) {
                        CertificateRequest.this.theSuite.showErrorDialog(CertificateRequest.this.thePanel, e1.getMessage());
                    }
                    catch (AgentProfileNotInitializedException e1) {
                        CertificateRequest.this.theSuite.showErrorDialog(CertificateRequest.this.thePanel, e1.getMessage());
                    }
                }
            });
        }
        return this.btnSaveToFile;
    }

    private JButton getBtnOnlineSend() {
        if (this.btnOnlineSend == null) {
            this.btnOnlineSend = new JButton();
            this.btnOnlineSend.setName("btnOnlineSend");
            this.btnOnlineSend.setText("Online Send");
            this.btnOnlineSend.setBounds(360, 350, 120, 30);
            this.btnOnlineSend.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (CertificateRequest.this.csrProfile == null) {
                        CertificateRequest.this.theSuite.showWarningDialog(CertificateRequest.this.thePanel, "CSR Profile is empty.\nPlease generate CSR profile.");
                        return;
                    }
                    CSROnlineSend dialog = CertificateRequest.this.theSuite.showCSROnlineSend(CertificateRequest.this.csrProfile);
                }
            });
        }
        return this.btnOnlineSend;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton();
            this.btnHelp.setName("btnHelp");
            this.btnHelp.setText("Help");
            this.btnHelp.setBounds(500, 350, 120, 30);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: certificaterequest.html");
                    CertificateRequest.this.theSuite.showHelp("Help", "certificaterequest.html");
                }
            });
        }
        return this.btnHelp;
    }

    private JLabel getLblCertificateRequest() {
        if (this.lblCertificateRequest == null) {
            this.lblCertificateRequest = new JLabel();
            this.lblCertificateRequest.setName("lblCertificateRequest");
            this.lblCertificateRequest.setText("  Certificate Signing Request (CSR Generate)");
            this.lblCertificateRequest.setHorizontalTextPosition(2);
            this.lblCertificateRequest.setVerticalTextPosition(0);
            this.lblCertificateRequest.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblCertificateRequest.setBounds(10, 10, 760, 30);
        }
        return this.lblCertificateRequest;
    }

    private JLabel getLblCommonName() {
        if (this.lblCommonName == null) {
            this.lblCommonName = new JLabel();
            this.lblCommonName.setName("lblCommonName");
            this.lblCommonName.setText("* Common Name :");
            this.lblCommonName.setBounds(50, 25, 150, 25);
        }
        return this.lblCommonName;
    }

    private JLabel getLblOrganization() {
        if (this.lblOrganization == null) {
            this.lblOrganization = new JLabel();
            this.lblOrganization.setName("lblOrganization");
            this.lblOrganization.setText("Organization :");
            this.lblOrganization.setBounds(50, 50, 150, 25);
        }
        return this.lblOrganization;
    }

    private JLabel getLblOrganizationUnit() {
        if (this.lblOrganizationUnit == null) {
            this.lblOrganizationUnit = new JLabel();
            this.lblOrganizationUnit.setName("lblOrganizationUnit");
            this.lblOrganizationUnit.setText("Organization Unit :");
            this.lblOrganizationUnit.setBounds(50, 75, 150, 25);
        }
        return this.lblOrganizationUnit;
    }

    private JLabel getLblStreetAddress() {
        if (this.lblStreetAddress == null) {
            this.lblStreetAddress = new JLabel();
            this.lblStreetAddress.setName("lblStreetAddress");
            this.lblStreetAddress.setText("Street Address :");
            this.lblStreetAddress.setBounds(50, 100, 150, 25);
        }
        return this.lblStreetAddress;
    }

    private JLabel getLblProvince() {
        if (this.lblProvince == null) {
            this.lblProvince = new JLabel();
            this.lblProvince.setName("lblProvince");
            this.lblProvince.setText("Province :");
            this.lblProvince.setBounds(50, 125, 150, 25);
        }
        return this.lblProvince;
    }

    private JLabel getLblLocality() {
        if (this.lblLocality == null) {
            this.lblLocality = new JLabel();
            this.lblLocality.setName("lblLocality");
            this.lblLocality.setText("Locality/Province Code :");
            this.lblLocality.setBounds(50, 150, 150, 25);
        }
        return this.lblLocality;
    }

    private JLabel getLblCountry() {
        if (this.lblCountry == null) {
            this.lblCountry = new JLabel();
            this.lblCountry.setName("lblCountry");
            this.lblCountry.setText("Country :");
            this.lblCountry.setBounds(50, 175, 150, 25);
        }
        return this.lblCountry;
    }

    private JLabel getLblEmailAddress() {
        if (this.lblEmailAddress == null) {
            this.lblEmailAddress = new JLabel();
            this.lblEmailAddress.setName("lblEmailAddress");
            this.lblEmailAddress.setText("eMail Address :");
            this.lblEmailAddress.setBounds(50, 200, 150, 25);
        }
        return this.lblEmailAddress;
    }

    private JPanel getPnlCsrSubjectName() {
        if (this.pnlCsrSubjectName == null) {
            this.pnlCsrSubjectName = new JPanel();
            this.pnlCsrSubjectName.setName("pnlCsrSubjectName");
            this.pnlCsrSubjectName.setBorder(new TitledBorder(new LineBorder(new Color(255, 255, 255)), "  CSR Subject Name : "));
            this.pnlCsrSubjectName.setLayout(null);
            this.pnlCsrSubjectName.setBounds(25, 75, 640, 240);
            this.pnlCsrSubjectName.add((Component)this.getLblCommonName(), this.getLblCommonName().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblOrganization(), this.getLblOrganization().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblOrganizationUnit(), this.getLblOrganizationUnit().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblStreetAddress(), this.getLblStreetAddress().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblProvince(), this.getLblProvince().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblLocality(), this.getLblLocality().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblCountry(), this.getLblCountry().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblEmailAddress(), this.getLblEmailAddress().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtCommonName(), this.getTxtCommonName().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtOrganization(), this.getTxtOrganization().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtOrganizationUnit(), this.getTxtOrganizationUnit().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtStreetAddress(), this.getTxtStreetAddress().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtProvince(), this.getTxtProvince().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtLocality(), this.getTxtLocality().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtCountry(), this.getTxtCountry().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtEmailAddress(), this.getTxtEmailAddress().getName());
        }
        return this.pnlCsrSubjectName;
    }

    private JTextField getTxtCommonName() {
        if (this.txtCommonName == null) {
            this.txtCommonName = new JTextField();
            this.txtCommonName.setName("txtCommonName");
            this.txtCommonName.setBounds(200, 25, 300, 25);
        }
        return this.txtCommonName;
    }

    private JTextField getTxtOrganization() {
        if (this.txtOrganization == null) {
            this.txtOrganization = new JTextField();
            this.txtOrganization.setName("txtOrganization");
            this.txtOrganization.setBounds(200, 50, 300, 25);
        }
        return this.txtOrganization;
    }

    private JTextField getTxtOrganizationUnit() {
        if (this.txtOrganizationUnit == null) {
            this.txtOrganizationUnit = new JTextField();
            this.txtOrganizationUnit.setName("txtOrganizationUnit");
            this.txtOrganizationUnit.setBounds(200, 75, 300, 25);
        }
        return this.txtOrganizationUnit;
    }

    private JTextField getTxtStreetAddress() {
        if (this.txtStreetAddress == null) {
            this.txtStreetAddress = new JTextField();
            this.txtStreetAddress.setName("txtStreetAddress");
            this.txtStreetAddress.setBounds(200, 100, 300, 25);
        }
        return this.txtStreetAddress;
    }

    private JTextField getTxtProvince() {
        if (this.txtProvince == null) {
            this.txtProvince = new JTextField();
            this.txtProvince.setName("txtProvince");
            this.txtProvince.setBounds(200, 125, 300, 25);
        }
        return this.txtProvince;
    }

    private JTextField getTxtLocality() {
        if (this.txtLocality == null) {
            this.txtLocality = new JTextField();
            this.txtLocality.setName("txtLocality");
            this.txtLocality.setBounds(200, 150, 300, 25);
        }
        return this.txtLocality;
    }

    private JTextField getTxtCountry() {
        if (this.txtCountry == null) {
            this.txtCountry = new JTextField();
            this.txtCountry.setName("txtCountry");
            this.txtCountry.setBounds(200, 175, 300, 25);
        }
        return this.txtCountry;
    }

    private JTextField getTxtEmailAddress() {
        if (this.txtEmailAddress == null) {
            this.txtEmailAddress = new JTextField();
            this.txtEmailAddress.setName("txtEmailAddress");
            this.txtEmailAddress.setBounds(200, 200, 300, 25);
        }
        return this.txtEmailAddress;
    }

    private JLabel getLblGenerationNo() {
        if (this.lblGenerationNo == null) {
            this.lblGenerationNo = new JLabel("CSR Generation No: ");
            this.lblGenerationNo.setBounds(320, 50, 150, 25);
        }
        return this.lblGenerationNo;
    }

    private JLabel getLblGenerationNoData() {
        if (this.lblGenerationNoData == null) {
            this.lblGenerationNoData = new JLabel("Not generated yet");
            this.lblGenerationNoData.setBounds(480, 50, 150, 25);
        }
        return this.lblGenerationNoData;
    }
}

