/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import management.CertificateManager;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.HouseKeeping.KeeperSoftException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.X500.DName;
import ui.TCDSecureSuite;
import ui.ca.CSRView;
import ui.ca.CertFileExport;
import ui.ca.CertFileImport;
import ui.ca.data.AgentCertificateData;
import ui.ca.data.AgentCertificateDataModel;
import ui.ca.data.AuthorityData;
import ui.ca.data.AuthorityDataModel;
import ui.ca.data.OtherPeopleData;
import ui.ca.data.OtherPeopleDataModel;

public class CertificateStoreManager
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblTitle = null;
    public static int TAB_PEOPLE = 0;
    public static int TAB_AGENT = 1;
    public static int TAB_CA = 2;
    private JTabbedPane tabTable = null;
    private JScrollPane splOtherPeople = null;
    private JScrollPane splAgentCertificate = null;
    private JScrollPane splAuthority = null;
    private JTable tblOtherPeople = null;
    private JTable tblAgentCertificate = null;
    private JTable tblAuthority = null;
    private AuthorityDataModel authorityDataModel = null;
    private OtherPeopleDataModel otherPeopleDataModel = null;
    private AgentCertificateDataModel agentCertificateDataModel = null;
    private JButton btnImport = null;
    private JButton btnExport = null;
    private JButton btnView = null;
    private JButton btnRemove = null;
    private JButton btnHelp = null;
    private TCDSecureSuite theSuite = null;
    private CertificateStoreManager thePanel = this;
    private int counter = 0;

    public CertificateStoreManager(TCDSecureSuite theSuite, int tabIndex) {
        this.theSuite = theSuite;
        this.initialise();
        this.setName("Certificate Store Management");
        this.tabTable.setSelectedIndex(tabIndex);
    }

    private JScrollPane getSplOtherPeople() {
        if (this.splOtherPeople == null) {
            this.splOtherPeople = new JScrollPane(this.getTblOtherPeople());
            this.splOtherPeople.setName("splOtherPeople");
            this.splOtherPeople.setBorder(new LineBorder(new Color(255, 255, 255)));
        }
        return this.splOtherPeople;
    }

    private JTable getTblOtherPeople() {
        if (this.tblOtherPeople == null) {
            this.otherPeopleDataModel = new OtherPeopleDataModel();
            this.tblOtherPeople = new JTable(this.otherPeopleDataModel);
            this.tblOtherPeople.setName("tblOtherPeople");
            try {
                Room room = this.theSuite.getRoom();
                SecureStoreOperator operator = room.getSecureStoreOperator();
                List list = operator.getCertificates("TRUSTED Certificate");
                for (CertProfile certProfile : list) {
                    String commonName = certProfile.getSubjectDN().getCommonName();
                    String serial = certProfile.getSerialNumber().toString();
                    String validDate = String.valueOf(TCDSecureSuite.formatDate(certProfile.getIssueDate())) + " - " + TCDSecureSuite.formatDate(certProfile.getExpireDate());
                    String issuer = certProfile.getIssuerDN().getCommonName();
                    String purpose = "";
                    try {
                        purpose = certProfile.getUsages();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    OtherPeopleData data = new OtherPeopleData(commonName, serial, validDate, issuer, purpose);
                    this.otherPeopleDataModel.addData(data);
                }
            }
            catch (KeeperSoftException e) {
                this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
                e.printStackTrace();
            }
            catch (ASN1Exception e) {
                this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
                e.printStackTrace();
            }
        }
        return this.tblOtherPeople;
    }

    private JScrollPane getSplAgentCertificate() {
        if (this.splAgentCertificate == null) {
            this.splAgentCertificate = new JScrollPane(this.getTblAgentCertificate());
            this.splAgentCertificate.setName("splAgentCertificate");
            this.splAgentCertificate.setBorder(new LineBorder(new Color(255, 255, 255)));
        }
        return this.splAgentCertificate;
    }

    private JTable getTblAgentCertificate() {
        if (this.tblAgentCertificate == null) {
            this.agentCertificateDataModel = new AgentCertificateDataModel();
            this.tblAgentCertificate = new JTable(this.agentCertificateDataModel);
            this.tblAgentCertificate.setName("tblAgentCertificate");
            try {
                Room room = this.theSuite.getRoom();
                SecureStoreOperator operator = room.getSecureStoreOperator();
                List list = operator.getCertificates("USER Certificate");
                for (CertProfile certProfile : list) {
                    String commonName = certProfile.getSubjectDN().getCommonName();
                    String serial = certProfile.getSerialNumber().toString();
                    String validDate = String.valueOf(TCDSecureSuite.formatDate(certProfile.getIssueDate())) + " - " + TCDSecureSuite.formatDate(certProfile.getExpireDate());
                    String issuer = certProfile.getIssuerDN().getCommonName();
                    String purpose = certProfile.getUsages();
                    AgentCertificateData data = new AgentCertificateData(commonName, serial, validDate, issuer, purpose);
                    this.agentCertificateDataModel.addData(data);
                }
            }
            catch (KeeperSoftException e) {
                this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
                e.printStackTrace();
            }
            catch (ASN1Exception e) {
                this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
                e.printStackTrace();
            }
        }
        return this.tblAgentCertificate;
    }

    private JScrollPane getSplAuthority() {
        if (this.splAuthority == null) {
            this.splAuthority = new JScrollPane(this.getTblAuthority());
            this.splAuthority.setName("splAuthority");
            this.splAuthority.setBorder(new LineBorder(new Color(255, 255, 255)));
        }
        return this.splAuthority;
    }

    private JTable getTblAuthority() {
        if (this.tblAuthority == null) {
            this.authorityDataModel = new AuthorityDataModel();
            this.tblAuthority = new JTable(this.authorityDataModel);
            this.tblAuthority.setName("tblAuthority");
            try {
                Room room = this.theSuite.getRoom();
                SecureStoreOperator operator = room.getSecureStoreOperator();
                List list = operator.getCertificates("CA Certificate");
                for (CertProfile certProfile : list) {
                    DName dName = certProfile.getSubjectDN();
                    String commonName = dName.getCommonName();
                    String validDate = String.valueOf(TCDSecureSuite.formatDate(certProfile.getIssueDate())) + " - " + TCDSecureSuite.formatDate(certProfile.getExpireDate());
                    String signer = certProfile.getIssuerDN().getCommonName();
                    String purpose = certProfile.getUsages();
                    AuthorityData data = new AuthorityData(commonName, validDate, signer, purpose);
                    this.authorityDataModel.addData(data);
                }
            }
            catch (KeeperSoftException e) {
                this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
                e.printStackTrace();
            }
            catch (ASN1Exception e) {
                this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
                e.printStackTrace();
            }
        }
        return this.tblAuthority;
    }

    private JButton getBtnImport() {
        if (this.btnImport == null) {
            this.btnImport = new JButton("Import");
            this.btnImport.setName("btnImport");
            this.btnImport.setBounds(80, 480, 100, 25);
            this.btnImport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("Certificate File Import");
                    int currentTab = CertificateStoreManager.this.tabTable.getSelectedIndex();
                    CertFileImport certFileImport = CertificateStoreManager.this.theSuite.showCertFileImport(currentTab);
                }
            });
        }
        return this.btnImport;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton("Export");
            this.btnExport.setName("btnExport");
            this.btnExport.setBounds(200, 480, 100, 25);
            this.btnExport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("Certificate File Export");
                    CertProfile certProfile = CertificateStoreManager.this.getSelectedCertProfile();
                    if (CertificateStoreManager.this.tabTable.getSelectedIndex() == TAB_PEOPLE) {
                        int row = CertificateStoreManager.this.tblOtherPeople.getSelectedRow();
                        if (row < 0) {
                            CertificateStoreManager.this.theSuite.showWarningDialog(CertificateStoreManager.this.thePanel, "Please click on a certificate to export.");
                            return;
                        }
                        CertFileExport dialog = new CertFileExport(CertificateStoreManager.this.theSuite, CertificateStoreManager.this.tabTable.getSelectedIndex(), row, certProfile);
                        dialog.setVisible(true);
                    } else if (CertificateStoreManager.this.tabTable.getSelectedIndex() == TAB_AGENT) {
                        int row = CertificateStoreManager.this.tblAgentCertificate.getSelectedRow();
                        if (row < 0) {
                            CertificateStoreManager.this.theSuite.showWarningDialog(CertificateStoreManager.this.thePanel, "Please click on a certificate to export.");
                            return;
                        }
                        CertFileExport dialog = new CertFileExport(CertificateStoreManager.this.theSuite, CertificateStoreManager.this.tabTable.getSelectedIndex(), row, certProfile);
                        dialog.setVisible(true);
                    } else if (CertificateStoreManager.this.tabTable.getSelectedIndex() == TAB_CA) {
                        int row = CertificateStoreManager.this.tblAuthority.getSelectedRow();
                        if (row < 0) {
                            CertificateStoreManager.this.theSuite.showWarningDialog(CertificateStoreManager.this.thePanel, "Please click on a certificate to export.");
                            return;
                        }
                        CertFileExport dialog = new CertFileExport(CertificateStoreManager.this.theSuite, CertificateStoreManager.this.tabTable.getSelectedIndex(), row, certProfile);
                        dialog.setVisible(true);
                    }
                }
            });
        }
        return this.btnExport;
    }

    private JButton getBtnView() {
        if (this.btnView == null) {
            this.btnView = new JButton("View");
            this.btnView.setName("btnView");
            this.btnView.setBounds(320, 480, 100, 25);
            this.btnView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("Certificate View");
                    CertProfile certProfile = CertificateStoreManager.this.getSelectedCertProfile();
                    if (certProfile != null) {
                        System.out.println("CSRView for " + certProfile);
                        CSRView dialog = new CSRView(CertificateStoreManager.this.theSuite, certProfile);
                        dialog.setVisible(true);
                    }
                }
            });
        }
        return this.btnView;
    }

    private JButton getBtnRemove() {
        if (this.btnRemove == null) {
            this.btnRemove = new JButton("Remove");
            this.btnRemove.setName("btnRemove");
            this.btnRemove.setBounds(440, 480, 100, 25);
            this.btnRemove.addActionListener(new ActionListener(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void actionPerformed(ActionEvent evt) {
                    int currentTab = CertificateStoreManager.this.tabTable.getSelectedIndex();
                    CertificateManager manager = CertificateStoreManager.this.theSuite.getCertificateManager();
                    try {
                        if (currentTab == TAB_PEOPLE) {
                            int row = CertificateStoreManager.this.tblOtherPeople.getSelectedRow();
                            if (row < 0) {
                                CertificateStoreManager.this.theSuite.showWarningDialog(CertificateStoreManager.this.thePanel, "Please click on a certificate to remove.");
                                return;
                            }
                            manager.deleteCertificate("TRUSTED Certificate", row);
                        } else if (currentTab == TAB_AGENT) {
                            int row = CertificateStoreManager.this.tblAgentCertificate.getSelectedRow();
                            if (row < 0) {
                                CertificateStoreManager.this.theSuite.showWarningDialog(CertificateStoreManager.this.thePanel, "Please click on a certificate to remove.");
                                return;
                            }
                            manager.deleteCertificate("USER Certificate", row);
                        } else if (currentTab == TAB_CA) {
                            int row = CertificateStoreManager.this.tblAuthority.getSelectedRow();
                            if (row < 0) {
                                CertificateStoreManager.this.theSuite.showWarningDialog(CertificateStoreManager.this.thePanel, "Please click on a certificate to remove.");
                                return;
                            }
                            manager.deleteCertificate("CA Certificate", row);
                        }
                        CertificateStoreManager.this.theSuite.showInformationDialog(CertificateStoreManager.this.thePanel, "The certificate has been removed.");
                    }
                    catch (SecureStoreException e) {
                        CertificateStoreManager.this.theSuite.showErrorDialog(CertificateStoreManager.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        CertificateStoreManager.this.theSuite.showErrorDialog(CertificateStoreManager.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    CertificateStoreManager.this.theSuite.showCertificateStoreManager(currentTab);
                }
            });
        }
        return this.btnRemove;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton("Help");
            this.btnHelp.setName("btnHelp");
            this.btnHelp.setBounds(560, 480, 100, 25);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("Show help : certificatestoremanager.html");
                    CertificateStoreManager.this.theSuite.showHelp("Help", "certificatestoremanager.html");
                }
            });
        }
        return this.btnHelp;
    }

    private JTabbedPane getTabTable() {
        if (this.tabTable == null) {
            this.tabTable = new JTabbedPane(1);
            this.tabTable.setName("tabTable");
            this.tabTable.setBounds(20, 50, 740, 420);
            this.tabTable.addTab("Other People's", this.getSplOtherPeople());
            this.tabTable.addTab("Agent Certificates", this.getSplAgentCertificate());
            this.tabTable.addTab("Authorities (CA)", this.getSplAuthority());
        }
        this.tabTable.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CertificateStoreManager certificateStoreManager = CertificateStoreManager.this;
                certificateStoreManager.counter = certificateStoreManager.counter + 1;
                if (CertificateStoreManager.this.counter % 2 == 0) {
                    JTabbedPane tab = (JTabbedPane)e.getSource();
                    if (tab.getSelectedIndex() == TAB_PEOPLE) {
                        CertificateStoreManager.this.repaintTable();
                    } else if (tab.getSelectedIndex() == TAB_AGENT) {
                        CertificateStoreManager.this.repaintTable();
                    } else {
                        tab.getSelectedIndex();
                    }
                }
            }
        });
        return this.tabTable;
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel(" Certificate Store Manager ");
            this.lblTitle.setName("lblTitle");
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 760, 30);
        }
        return this.lblTitle;
    }

    private void initialise() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getTabTable(), this.getTabTable().getName());
        this.add((Component)this.getBtnImport(), this.getBtnImport().getName());
        this.add((Component)this.getBtnExport(), this.getBtnExport().getName());
        this.add((Component)this.getBtnView(), this.getBtnView().getName());
        this.add((Component)this.getBtnRemove(), this.getBtnRemove().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
    }

    public void setSelectedCertProfile(int row) {
        int currentTab = this.tabTable.getSelectedIndex();
        if (currentTab == TAB_PEOPLE) {
            this.tblOtherPeople.setRowSelectionInterval(row, row);
        } else if (currentTab == TAB_AGENT) {
            this.tblAgentCertificate.setRowSelectionInterval(row, row);
        } else if (currentTab == TAB_CA) {
            this.tblAuthority.setRowSelectionInterval(row, row);
        }
    }

    public CertProfile getSelectedCertProfile() {
        CertProfile certProfile = null;
        try {
            Room room = this.theSuite.getRoom();
            SecureStoreOperator secureStoreOperator = room.getSecureStoreOperator();
            int currentTab = this.tabTable.getSelectedIndex();
            System.out.println("Current tab " + currentTab);
            if (currentTab == TAB_PEOPLE) {
                int row = this.tblOtherPeople.getSelectedRow();
                if (row != -1) {
                    List certList = secureStoreOperator.getCertificates("TRUSTED Certificate");
                    certProfile = (CertProfile)certList.get(row);
                } else {
                    this.theSuite.showWarningDialog(this.thePanel, "No choose certProfile.");
                }
            } else if (currentTab == TAB_AGENT) {
                int row = this.tblAgentCertificate.getSelectedRow();
                if (row != -1) {
                    List certList = secureStoreOperator.getCertificates("USER Certificate");
                    certProfile = (CertProfile)certList.get(row);
                } else {
                    this.theSuite.showWarningDialog(this.thePanel, "No choose certProfile.");
                }
            } else if (currentTab == TAB_CA) {
                int row = this.tblAuthority.getSelectedRow();
                if (row != -1) {
                    List certList = secureStoreOperator.getCertificates("CA Certificate");
                    certProfile = (CertProfile)certList.get(row);
                } else {
                    this.theSuite.showWarningDialog(this.thePanel, "No choose certProfile.");
                }
            }
        }
        catch (SecureStoreException e1) {
            this.theSuite.showErrorDialog(this.thePanel, e1.getMessage());
            e1.printStackTrace();
        }
        return certProfile;
    }

    private void repaintTable() {
        Object data;
        String purpose;
        String issuer;
        String validDate;
        String serial;
        String commonName;
        List list;
        Room room = this.theSuite.getRoom();
        SecureStoreOperator sso = room.getSecureStoreOperator();
        this.otherPeopleDataModel = new OtherPeopleDataModel();
        this.tblOtherPeople = new JTable(this.otherPeopleDataModel);
        this.tblOtherPeople.setName("tblOtherPeople");
        try {
            list = sso.getCertificates("TRUSTED Certificate");
            for (CertProfile certProfile : list) {
                commonName = certProfile.getSubjectDN().getCommonName();
                serial = certProfile.getSerialNumber().toString();
                validDate = String.valueOf(TCDSecureSuite.formatDate(certProfile.getIssueDate())) + " - " + TCDSecureSuite.formatDate(certProfile.getExpireDate());
                issuer = certProfile.getIssuerDN().getCommonName();
                purpose = "";
                try {
                    purpose = certProfile.getUsages();
                }
                catch (Exception ex) {
                    this.theSuite.showErrorDialog(this.thePanel, ex.getMessage());
                }
                data = new OtherPeopleData(commonName, serial, validDate, issuer, purpose);
                this.otherPeopleDataModel.addData((OtherPeopleData)data);
            }
        }
        catch (KeeperSoftException ex) {
            this.theSuite.showErrorDialog(this.thePanel, ex.getMessage());
            ex.printStackTrace();
        }
        catch (ASN1Exception ex) {
            this.theSuite.showErrorDialog(this.thePanel, ex.getMessage());
            ex.printStackTrace();
        }
        this.splOtherPeople = new JScrollPane(this.tblOtherPeople);
        this.splOtherPeople.setName("splOtherPeople");
        this.splOtherPeople.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.tabTable.remove(0);
        this.tabTable.addTab("Other People's", this.splOtherPeople);
        this.agentCertificateDataModel = new AgentCertificateDataModel();
        this.tblAgentCertificate = new JTable(this.agentCertificateDataModel);
        this.tblAgentCertificate.setName("tblAgentCertificate");
        try {
            list = sso.getCertificates("USER Certificate");
            for (CertProfile certProfile : list) {
                commonName = certProfile.getSubjectDN().getCommonName();
                serial = certProfile.getSerialNumber().toString();
                validDate = String.valueOf(TCDSecureSuite.formatDate(certProfile.getIssueDate())) + " - " + TCDSecureSuite.formatDate(certProfile.getExpireDate());
                issuer = certProfile.getIssuerDN().getCommonName();
                purpose = certProfile.getUsages();
                data = new AgentCertificateData(commonName, serial, validDate, issuer, purpose);
                this.agentCertificateDataModel.addData((AgentCertificateData)data);
            }
        }
        catch (KeeperSoftException ex) {
            this.theSuite.showErrorDialog(this.thePanel, ex.getMessage());
            ex.printStackTrace();
        }
        catch (ASN1Exception ex) {
            this.theSuite.showErrorDialog(this.thePanel, ex.getMessage());
            ex.printStackTrace();
        }
        this.splAgentCertificate = new JScrollPane(this.tblAgentCertificate);
        this.splAgentCertificate.setName("splAgentCertificate");
        this.splAgentCertificate.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.tabTable.remove(0);
        this.tabTable.addTab("Agent Certificates", this.splAgentCertificate);
        this.authorityDataModel = new AuthorityDataModel();
        this.tblAuthority = new JTable(this.authorityDataModel);
        this.tblAuthority.setName("tblAuthority");
        try {
            list = sso.getCertificates("CA Certificate");
            for (CertProfile certProfile : list) {
                DName dName = certProfile.getSubjectDN();
                String commonName2 = dName.getCommonName();
                validDate = String.valueOf(TCDSecureSuite.formatDate(certProfile.getIssueDate())) + " - " + TCDSecureSuite.formatDate(certProfile.getExpireDate());
                String signer = certProfile.getIssuerDN().getCommonName();
                purpose = certProfile.getUsages();
                data = new AuthorityData(commonName2, validDate, signer, purpose);
                this.authorityDataModel.addData((AuthorityData)data);
            }
        }
        catch (KeeperSoftException ex) {
            this.theSuite.showErrorDialog(this.thePanel, ex.getMessage());
            ex.printStackTrace();
        }
        catch (ASN1Exception ex) {
            this.theSuite.showErrorDialog(this.thePanel, ex.getMessage());
            ex.printStackTrace();
        }
        this.splAuthority = new JScrollPane(this.tblAuthority);
        this.splAuthority.setName("splAuthority");
        this.splAuthority.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.tabTable.remove(0);
        this.tabTable.addTab("Authorities (CA)", this.splAuthority);
    }
}

