/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import th.co.oga.security.pki.HouseKeeping.CertStoreList;
import th.co.oga.security.pki.HouseKeeping.CertStoreParams;
import th.co.oga.security.pki.HouseKeeping.CertStoreProfile;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.ProfileAlreadyExistException;
import th.co.oga.security.pki.HouseKeeping.ProfileNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.CertStoreStopFailException;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.utils.UnknowMadatoryException;
import ui.TCDSecureSuite;

public class PKIRepositories
extends JPanel {
    private final PKIRepositories thePanel = this;
    private static final long serialVersionUID = 1L;
    private JPanel pnlMain;
    private JLabel lblTitle;
    private JButton btnOk;
    private JButton btnReset;
    private ButtonGroup bgpSpecification;
    private JRadioButton[] radButton;
    private int counter = 1;
    private int row = 0;
    private int col = 0;
    private int[] numCol;
    private String[] strStore;
    private String[][] strProperties;
    private String[][] strValue;
    private JTextField[][] txtValue;
    private boolean[] selectStore;
    private CertStoreParams[] params;
    private CertStoreProfile[] csp;
    private CertStoreList csl;
    private TCDSecureSuite theSuite;
    private Room room;

    public PKIRepositories(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.room = theSuite.getRoom();
        this.setName("PKIRepositories");
        this.putData();
        this.initialize();
    }

    public void putData() {
        try {
            SecureStoreOperator sso = this.room.getSecureStoreOperator();
            CertStoreList cslDefault = sso.getSupportedCertStore();
            this.csl = this.room.getCertStoreList();
            this.row = cslDefault.size();
            this.strStore = new String[this.row];
            this.numCol = new int[this.row];
            this.selectStore = new boolean[this.row];
            this.csp = new CertStoreProfile[this.row];
            this.params = new CertStoreParams[this.row];
            Iterator it = cslDefault.iterator();
            int x = 0;
            while (it.hasNext()) {
                int num;
                CertStoreProfile certStoreProfile;
                this.csp[x] = certStoreProfile = (CertStoreProfile)it.next();
                this.numCol[x] = num = this.csp[x].getParams().size();
                if (num > this.col) {
                    this.col = num;
                }
                ++x;
            }
            x = 0;
            for (CertStoreProfile certStoreProfile : this.csl) {
                int i = 0;
                while (i < this.row) {
                    this.selectStore[x] = certStoreProfile.isEnabled();
                    if (this.csp[i].getCertStoreProviderNumber() == certStoreProfile.getCertStoreProviderNumber()) {
                        this.csp[i] = certStoreProfile;
                    }
                    ++i;
                }
                ++x;
            }
            this.strProperties = new String[this.row][this.col];
            this.strValue = new String[this.row][this.col];
            this.txtValue = new JTextField[this.row][this.col];
            int i = 0;
            while (i < this.csp.length) {
                this.strStore[i] = this.csp[i].getName();
                this.params[i] = this.csp[i].getParams();
                int j = 0;
                Enumeration enu = this.params[i].getMandatories();
                while (enu.hasMoreElements()) {
                    this.strProperties[i][j] = (String)enu.nextElement();
                    String check = this.params[i].getValue(this.strProperties[i][j]);
                    this.strValue[i][j] = check.equals(CertStoreParams.UNDEFINE) ? "" : this.params[i].getValue(this.strProperties[i][j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (UnknowMadatoryException e) {
            this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
            e.printStackTrace();
        }
    }

    public void initialize() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        JScrollPane scrollMain = new JScrollPane(this.getPnlMain());
        scrollMain.setBounds(150, 50, 500, 420);
        this.add((Component)scrollMain, this.getPnlMain().getName());
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getBtnSubmit(), this.getBtnSubmit().getName());
        this.add((Component)this.getBtnRemove(), this.getBtnRemove().getName());
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel();
            this.lblTitle.setName("lblTitle");
            this.lblTitle.setText("  PKIRepositories");
            this.lblTitle.setHorizontalTextPosition(2);
            this.lblTitle.setVerticalTextPosition(0);
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 760, 30);
        }
        return this.lblTitle;
    }

    private JPanel getPnlMain() {
        if (this.pnlMain == null) {
            this.pnlMain = new JPanel();
            this.pnlMain.setName("Main");
            this.pnlMain.setLayout(new GridLayout(0, 1, 3, 3));
            this.pnlMain.setSize(500, 420);
            this.getCertStoreService();
        }
        return this.pnlMain;
    }

    private ButtonGroup getBgpSpecification() {
        if (this.bgpSpecification == null) {
            this.bgpSpecification = new ButtonGroup();
        }
        return this.bgpSpecification;
    }

    private JButton getBtnSubmit() {
        if (this.btnOk == null) {
            this.btnOk = new JButton("OK");
            this.btnOk.setBounds(300, 480, 100, 25);
        }
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (PKIRepositories.this.counter % 2 == 0) {
                        int i = 0;
                        while (i < PKIRepositories.this.row) {
                            if (PKIRepositories.this.radButton[i].isSelected()) {
                                PKIRepositories.this.csp[i].stop();
                                PKIRepositories.this.csp[i].setEnabled(true);
                                if (PKIRepositories.this.numCol[i] > 0) {
                                    int j = 0;
                                    while (j < PKIRepositories.this.numCol[i]) {
                                        if (PKIRepositories.this.txtValue[i][j].getText().equals("")) {
                                            PKIRepositories.this.params[i].setValue(PKIRepositories.this.strProperties[i][j], CertStoreParams.UNDEFINE);
                                        } else {
                                            ((PKIRepositories)PKIRepositories.this).strValue[i][j] = PKIRepositories.this.txtValue[i][j].getText();
                                            PKIRepositories.this.params[i].setValue(PKIRepositories.this.strProperties[i][j], PKIRepositories.this.strValue[i][j]);
                                        }
                                        ++j;
                                    }
                                    PKIRepositories.this.csp[i].setParams(PKIRepositories.this.params[i]);
                                    PKIRepositories.this.csl.setCertStoreProfile(PKIRepositories.this.csp[i]);
                                }
                                PKIRepositories.this.room.save(PKIRepositories.this.csl);
                                PKIRepositories.this.theSuite.showWarningDialog("PKIRepositories", "Set " + PKIRepositories.this.csp[i].getName());
                            }
                            ++i;
                        }
                    }
                    PKIRepositories pKIRepositories = PKIRepositories.this;
                    pKIRepositories.counter = pKIRepositories.counter + 1;
                }
                catch (UnknowMadatoryException e) {
                    PKIRepositories.this.theSuite.showErrorDialog(PKIRepositories.this.thePanel, e.getMessage());
                    e.printStackTrace();
                }
                catch (ProfileAlreadyExistException e) {
                    PKIRepositories.this.theSuite.showErrorDialog(PKIRepositories.this.thePanel, e.getMessage());
                    e.printStackTrace();
                }
                catch (ConfigFailException e) {
                    PKIRepositories.this.theSuite.showErrorDialog(PKIRepositories.this.thePanel, e.getMessage());
                    e.printStackTrace();
                }
                catch (ProfileNotFoundException e) {
                    PKIRepositories.this.theSuite.showErrorDialog(PKIRepositories.this.thePanel, e.getMessage());
                    e.printStackTrace();
                }
                catch (CertStoreStopFailException e) {
                    PKIRepositories.this.theSuite.showErrorDialog(PKIRepositories.this.thePanel, e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        return this.btnOk;
    }

    private JButton getBtnRemove() {
        if (this.btnReset == null) {
            this.btnReset = new JButton("Reset");
            this.btnReset.setBounds(410, 480, 100, 25);
        }
        this.btnReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (PKIRepositories.this.counter % 2 == 0) {
                        int i = 0;
                        while (i < PKIRepositories.this.row) {
                            if (PKIRepositories.this.radButton[i].isSelected()) {
                                PKIRepositories.this.csp[i].stop();
                                PKIRepositories.this.csp[i].setEnabled(false);
                                PKIRepositories.this.csl.setCertStoreProfile(PKIRepositories.this.csp[i]);
                                PKIRepositories.this.room.save(PKIRepositories.this.csl);
                                PKIRepositories.this.theSuite.showWarningDialog("PKIRepositories", "Reset " + PKIRepositories.this.csp[i].getName());
                            }
                            ++i;
                        }
                    }
                    PKIRepositories pKIRepositories = PKIRepositories.this;
                    pKIRepositories.counter = pKIRepositories.counter + 1;
                }
                catch (ProfileAlreadyExistException e) {
                    PKIRepositories.this.theSuite.showErrorDialog(PKIRepositories.this.thePanel, e.getMessage());
                    e.printStackTrace();
                }
                catch (ConfigFailException e) {
                    PKIRepositories.this.theSuite.showErrorDialog(PKIRepositories.this.thePanel, e.getMessage());
                    e.printStackTrace();
                }
                catch (ProfileNotFoundException e) {
                    PKIRepositories.this.theSuite.showErrorDialog(PKIRepositories.this.thePanel, e.getMessage());
                    e.printStackTrace();
                }
                catch (CertStoreStopFailException e) {
                    PKIRepositories.this.theSuite.showErrorDialog(PKIRepositories.this.thePanel, e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        return this.btnReset;
    }

    private void getCertStoreService() {
        JPanel[] pnlMains = new JPanel[this.row];
        JLabel[] lblProxy = new JLabel[this.row];
        this.radButton = new JRadioButton[this.row];
        JPanel[] pnlProperties = new JPanel[this.row];
        boolean selectButton = true;
        int i = 0;
        while (i < this.row) {
            pnlMains[i] = new JPanel();
            pnlMains[i].setName("Store :: " + i);
            pnlMains[i].setLayout(null);
            this.radButton[i] = new JRadioButton("RadioButton CertStore");
            this.radButton[i].setName(this.strStore[i]);
            this.radButton[i].setBounds(10, 10, 350, 20);
            this.getBgpSpecification().add(this.radButton[i]);
            this.radButton[i].setText(this.strStore[i]);
            pnlMains[i].add(this.radButton[i]);
            if (selectButton && this.selectStore[i]) {
                this.radButton[i].setSelected(this.selectStore[i]);
                selectButton = false;
            }
            pnlProperties[i] = new JPanel();
            pnlProperties[i].setLayout(new GridLayout(0, 1, 3, 3));
            JPanel[] pnlData = new JPanel[this.numCol[i]];
            JLabel[] lblProperties = new JLabel[this.numCol[i]];
            int j = 0;
            while (j < this.numCol[i]) {
                pnlData[j] = new JPanel();
                pnlData[j].setName("properties" + i + j);
                pnlData[j].setLayout(new GridLayout(1, 2, 3, 3));
                lblProperties[j] = new JLabel(this.strProperties[i][j]);
                pnlData[j].add(lblProperties[j]);
                this.txtValue[i][j] = new JTextField(this.strValue[i][j]);
                pnlData[j].add(this.txtValue[i][j]);
                pnlProperties[i].add(pnlData[j]);
                ++j;
            }
            JScrollPane scrollProperties = new JScrollPane(pnlProperties[i]);
            scrollProperties.setBounds(30, 30, 430, 122);
            pnlMains[i].add(scrollProperties);
            lblProxy[i] = new JLabel("Store Name :: " + this.strStore[i]);
            pnlMains[i].add(lblProxy[i]);
            this.pnlMain.add((Component)pnlMains[i], i);
            ++i;
        }
    }
}

