/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.cert.X509CRLEntry;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertificateInvalidateException;
import th.co.oga.security.pki.HouseKeeping.CRLList;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.TrustedPolicyTaker;
import th.co.oga.security.pki.Operation.CertificateVerifyFailException;
import th.co.oga.security.pki.Operator.SecureOperator;
import th.co.oga.security.pki.x.CRL.CRLProfile;
import th.co.oga.security.pki.x.OCSP.OCSPOperator;

public class VerifyDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JLabel certVerifyLabel;
    private JLabel ocspVerifyLabel;
    private JLabel crlVerifyLabel;

    public VerifyDialog(JDialog owner) {
        super(owner, "Certificate verify", false);
        this.setFocusable(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(null);
        this.addWindowListener(new WindowAction());
        this.setSize(320, 180);
        JLabel lblCertificate = new JLabel("Cert Verify :");
        lblCertificate.setBounds(40, 30, 180, 20);
        this.getContentPane().add(lblCertificate);
        this.certVerifyLabel = new JLabel("-");
        this.certVerifyLabel.setBounds(200, 30, 200, 20);
        this.getContentPane().add(this.certVerifyLabel);
        JLabel lblCsr = new JLabel("CRL Check:");
        lblCsr.setBounds(40, 50, 180, 20);
        this.getContentPane().add(lblCsr);
        this.crlVerifyLabel = new JLabel("-");
        this.crlVerifyLabel.setBounds(200, 50, 200, 20);
        this.getContentPane().add(this.crlVerifyLabel);
        JLabel lblOnline = new JLabel("OCSP Check:");
        lblOnline.setBounds(40, 70, 180, 20);
        this.getContentPane().add(lblOnline);
        this.ocspVerifyLabel = new JLabel("-");
        this.ocspVerifyLabel.setBounds(200, 70, 200, 20);
        this.getContentPane().add(this.ocspVerifyLabel);
        JButton closeButton = new JButton("Close");
        closeButton.setBounds(130, 100, 70, 25);
        this.getContentPane().add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VerifyDialog.this.setVisible(false);
            }
        });
        this.setVisible(false);
    }

    public void setOCSPVerifyStatus(String status) {
        this.ocspVerifyLabel.setText(status);
    }

    public void setCertVerifyStatus(String status) {
        this.certVerifyLabel.setText(status);
    }

    public void setCRLVerifyStatus(String status) {
        this.crlVerifyLabel.setText(status);
    }

    public void start(Room room, CertProfile cert) {
        block17: {
            this.setVisible(true);
            this.setCertVerifyStatus("Checking ...");
            this.setCRLVerifyStatus("Checking ...");
            this.setOCSPVerifyStatus("Checking ...");
            TrustedPolicyTaker tTaker = room.getTrustedPolicyTaker();
            SecureOperator sOper = room.getSecureOperator();
            CRLList crlList = room.getCRLList();
            try {
                try {
                    sOper.certificateVerify(cert);
                    this.setCertVerifyStatus("Verified");
                }
                catch (CertificateInvalidateException e) {
                    this.setCertVerifyStatus("Not validate");
                }
            }
            catch (Exception e) {
                this.setCertVerifyStatus("!Error");
            }
            if (tTaker.isOCSPEnable()) {
                try {
                    try {
                        OCSPOperator ocspOper = new OCSPOperator(room);
                        ocspOper.verify(cert);
                        this.setOCSPVerifyStatus("Verified");
                    }
                    catch (CertificateVerifyFailException e) {
                        this.setOCSPVerifyStatus("Not validate");
                    }
                }
                catch (Exception e) {
                    this.setOCSPVerifyStatus("!Error");
                }
            } else {
                this.setOCSPVerifyStatus("Not configured");
            }
            if (tTaker.isCRLEnable()) {
                try {
                    CRLProfile crl = crlList.getProfile(CRLProfile.getCRLIssuerName((CertProfile)cert));
                    if (crl == null) {
                        this.setCRLVerifyStatus("CRL Not avaliable");
                        break block17;
                    }
                    X509CRLEntry revokedCert = crl.getRevokedCert(cert);
                    if (revokedCert == null) {
                        this.setCRLVerifyStatus("Verified");
                        break block17;
                    }
                    this.setCRLVerifyStatus("Revoked");
                }
                catch (Exception exception) {}
            } else {
                this.setCRLVerifyStatus("Not configured");
            }
        }
    }

    public static void main(String[] args) {
        VerifyDialog dialog = new VerifyDialog(new JDialog());
        dialog.setVisible(true);
        dialog.setCertVerifyStatus("No configered");
        dialog.setOCSPVerifyStatus("No configered");
        dialog.setCRLVerifyStatus("No configered");
    }

    class WindowAction
    implements WindowListener {
        WindowAction() {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            VerifyDialog.this.setVisible(false);
        }
    }
}

