/*
 * Decompiled with CFR 0.152.
 */
package ui.crypto;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import management.CryptographicManager;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Operation.DataEncryptionFailException;
import ui.TCDSecureSuite;

public class DecryptFile
extends JPanel {
    private static final long serialVersionUID = -2980984270583123914L;
    private JLabel lblTitle;
    private JLabel lblEncryptAlgorithm;
    private JLabel lblEncryptedFile;
    private JLabel lblKey;
    private JLabel lblDecryptToFile;
    private JComboBox cbxEncryptAlgorithm;
    private JTextField txtEncryptedFile;
    private JPasswordField pwdKey;
    private JTextField txtDecryptToFile;
    private JButton btnBrowseEncryptedFile;
    private JButton btnBrowseDecryptToFile;
    private JButton btnDecrypt;
    private TCDSecureSuite theSuite = null;
    private final DecryptFile thePanel = this;
    private CryptographicManager manager = null;

    public DecryptFile(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.setName("Decrypt File");
        this.manager = theSuite.getCryptographicManager();
        this.initialise();
        this.putData();
    }

    private void putData() {
        AlgorithmSet algoSet = this.manager.getEncryptionAlgorithm();
        int i = 0;
        while (i < algoSet.size()) {
            AlgorithmProfile algoProfile = (AlgorithmProfile)algoSet.get(i);
            this.cbxEncryptAlgorithm.addItem(algoProfile.getAlgorithmName());
            ++i;
        }
    }

    private void initialise() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getLblEncryptAlgorithm(), this.getLblEncryptAlgorithm().getName());
        this.add((Component)this.getLblEncryptedFile(), this.getLblEncryptedFile().getName());
        this.add((Component)this.getLblKey(), this.getLblKey().getName());
        this.add((Component)this.getLblDecryptToFile(), this.getLblDecryptToFile().getName());
        this.add((Component)this.getCbxEncryptAlgorithm(), this.getCbxEncryptAlgorithm().getName());
        this.add((Component)this.getTxtEncryptedFile(), this.getTxtEncryptedFile().getName());
        this.add((Component)this.getpwdKey(), this.getpwdKey().getName());
        this.add((Component)this.getTxtDecryptToFile(), this.getTxtDecryptToFile().getName());
        this.add((Component)this.getBtnBrowseDecryptToFile(), this.getBtnBrowseDecryptToFile().getName());
        this.add((Component)this.getBtnBrowseEncryptFile(), this.getBtnBrowseEncryptFile().getName());
        this.add((Component)this.getBtnDecrypt(), this.getBtnDecrypt().getName());
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel(" File Decryption ");
            this.lblTitle.setName("lblTitle");
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 770, 30);
        }
        return this.lblTitle;
    }

    private JLabel getLblEncryptAlgorithm() {
        if (this.lblEncryptAlgorithm == null) {
            this.lblEncryptAlgorithm = new JLabel("Encryption Algorithm:");
            this.lblEncryptAlgorithm.setBounds(30, 60, 150, 20);
        }
        return this.lblEncryptAlgorithm;
    }

    private JComboBox getCbxEncryptAlgorithm() {
        if (this.cbxEncryptAlgorithm == null) {
            this.cbxEncryptAlgorithm = new JComboBox();
            this.cbxEncryptAlgorithm.setName("cbxEncryptAlgorithm");
            this.cbxEncryptAlgorithm.setBackground(new Color(255, 255, 255));
            this.cbxEncryptAlgorithm.setBounds(180, 60, 200, 20);
        }
        return this.cbxEncryptAlgorithm;
    }

    private JLabel getLblEncryptedFile() {
        if (this.lblEncryptedFile == null) {
            this.lblEncryptedFile = new JLabel("Encrypted file:");
            this.lblEncryptedFile.setBounds(30, 90, 150, 20);
        }
        return this.lblEncryptedFile;
    }

    private JTextField getTxtEncryptedFile() {
        if (this.txtEncryptedFile == null) {
            this.txtEncryptedFile = new JTextField();
            this.txtEncryptedFile.setBounds(180, 90, 200, 20);
        }
        return this.txtEncryptedFile;
    }

    private JButton getBtnBrowseEncryptFile() {
        if (this.btnBrowseEncryptedFile == null) {
            this.btnBrowseEncryptedFile = new JButton("Browse");
            this.btnBrowseEncryptedFile.setBounds(400, 90, 100, 20);
            this.btnBrowseEncryptedFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("Browse Encrypted File");
                    JFileChooser fileChooser = new JFileChooser(TCDSecureSuite.DEFAULT_DIR);
                    int returnVal = fileChooser.showOpenDialog(DecryptFile.this.theSuite);
                    if (returnVal == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        String filename = selectedFile.getPath();
                        DecryptFile.this.txtEncryptedFile.setText(selectedFile.getPath());
                        if (filename.endsWith(".enc")) {
                            filename = filename.substring(0, filename.indexOf(".enc"));
                        }
                        DecryptFile.this.txtDecryptToFile.setText(filename);
                    }
                }
            });
        }
        return this.btnBrowseEncryptedFile;
    }

    private JLabel getLblKey() {
        if (this.lblKey == null) {
            this.lblKey = new JLabel("Key:");
            this.lblKey.setBounds(30, 120, 150, 20);
        }
        return this.lblKey;
    }

    private JTextField getpwdKey() {
        if (this.pwdKey == null) {
            this.pwdKey = new JPasswordField();
            this.pwdKey.setBounds(180, 120, 200, 20);
        }
        return this.pwdKey;
    }

    private JLabel getLblDecryptToFile() {
        if (this.lblDecryptToFile == null) {
            this.lblDecryptToFile = new JLabel("Decrypt to file:");
            this.lblDecryptToFile.setBounds(30, 150, 150, 20);
        }
        return this.lblDecryptToFile;
    }

    private JTextField getTxtDecryptToFile() {
        if (this.txtDecryptToFile == null) {
            this.txtDecryptToFile = new JTextField();
            this.txtDecryptToFile.setBounds(180, 150, 200, 20);
        }
        return this.txtDecryptToFile;
    }

    private JButton getBtnBrowseDecryptToFile() {
        if (this.btnBrowseDecryptToFile == null) {
            this.btnBrowseDecryptToFile = new JButton("Browse");
            this.btnBrowseDecryptToFile.setBounds(400, 150, 100, 20);
            this.btnBrowseDecryptToFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("Browse Decrypt to File");
                    JFileChooser fileChooser = new JFileChooser(TCDSecureSuite.DEFAULT_DIR);
                    int returnVal = fileChooser.showSaveDialog(DecryptFile.this.theSuite);
                    if (returnVal == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        String filename = selectedFile.getName();
                        DecryptFile.this.txtDecryptToFile.setText(selectedFile.getPath());
                    }
                }
            });
        }
        return this.btnBrowseDecryptToFile;
    }

    private JButton getBtnDecrypt() {
        if (this.btnDecrypt == null) {
            this.btnDecrypt = new JButton("Decrypt");
            this.btnDecrypt.setBounds(200, 200, 100, 30);
            this.btnDecrypt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int returnValue;
                    System.out.println("Decrypt");
                    String encryptedFilename = DecryptFile.this.txtEncryptedFile.getText();
                    String decryptToFilename = DecryptFile.this.txtDecryptToFile.getText();
                    File encryptedFile = new File(encryptedFilename);
                    if (!encryptedFile.exists()) {
                        DecryptFile.this.theSuite.showWarningDialog(DecryptFile.this.thePanel, "The encrypted [" + encryptedFilename + "] does not exist.\nPlease choose a file to be decrypted.");
                        return;
                    }
                    if (decryptToFilename.trim().length() == 0) {
                        DecryptFile.this.theSuite.showWarningDialog(DecryptFile.this.thePanel, "Please specify an output file.");
                        return;
                    }
                    if (decryptToFilename.equals(encryptedFilename)) {
                        DecryptFile.this.theSuite.showErrorDialog(DecryptFile.this.thePanel, "The output filename cannot be identical with the source");
                        return;
                    }
                    if (DecryptFile.this.pwdKey.getPassword().length == 0 && (returnValue = JOptionPane.showConfirmDialog(null, "Are you sure to proceed with blank key?", "Key Confirmation", 0)) == 1) {
                        return;
                    }
                    try {
                        System.out.println("doDecryptFile");
                        DecryptFile.this.doDecryptFile();
                        DecryptFile.this.theSuite.showInformationDialog(DecryptFile.this.thePanel, "Decryption is completed.");
                    }
                    catch (DataEncryptionFailException e) {
                        DecryptFile.this.theSuite.showErrorDialog(DecryptFile.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        DecryptFile.this.theSuite.showErrorDialog(DecryptFile.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btnDecrypt;
    }

    public void doDecryptFile() throws DataEncryptionFailException, IOException {
        int algoId = this.cbxEncryptAlgorithm.getSelectedIndex();
        String key = new String(this.pwdKey.getPassword());
        String srcFilename = this.txtEncryptedFile.getText();
        String desFilename = this.txtDecryptToFile.getText();
        this.manager.decryptFile(algoId, key, srcFilename, desFilename);
    }

    public void setEncryptedFile(String filename) {
        this.txtEncryptedFile.setText(filename);
    }

    public void setKey(String key) {
        this.pwdKey.setText(key);
    }

    public void setEncryptionAlgorithm(int i) {
        this.cbxEncryptAlgorithm.setSelectedIndex(i);
    }

    public void setDecryptToFilename(String filename) {
        this.txtDecryptToFile.setText(filename);
    }
}

