/*
 * Decompiled with CFR 0.152.
 */
package ui.crypto;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import management.CryptographicManager;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Operation.DataEncryptionFailException;
import th.co.oga.security.pki.Operation.KeyGenerateFailException;
import ui.TCDSecureSuite;

public class EncryptData
extends JPanel {
    private static final long serialVersionUID = -1720711576403877738L;
    private JLabel lblTitle = null;
    private JPanel pnlParameters = null;
    private JLabel lblEncryptedData = null;
    private JTextArea txtEncryptedData = null;
    private JButton btnEncrypt = null;
    private JButton btnHelp = null;
    private JLabel lblEncryptAlgorithm = null;
    private JComboBox cbxEncryptAlgorithm = null;
    private JLabel lblToBeEncryptedData = null;
    private JTextArea txtToBeEncryptedData = null;
    private TCDSecureSuite theSuite = null;
    private final EncryptData thePanel = this;
    private CryptographicManager manager = null;

    public EncryptData(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.setName("Encrypt Data");
        this.initialise();
        this.manager = theSuite.getCryptographicManager();
        this.putData();
    }

    private void putData() {
        AlgorithmSet algoSet = this.manager.getEncryptionAlgorithm();
        int i = 0;
        while (i < algoSet.size()) {
            AlgorithmProfile algoProfile = (AlgorithmProfile)algoSet.get(i);
            this.cbxEncryptAlgorithm.addItem(algoProfile.getAlgorithmName());
            ++i;
        }
    }

    private void initialise() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getPnlParameters(), this.getPnlParameters().getName());
        this.add((Component)this.getLblEncryptedData(), this.getLblEncryptedData().getName());
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.getTxtEncryptedData());
        scroll.setBounds(80, 350, 660, 100);
        this.add((Component)scroll, this.getTxtEncryptedData().getName());
        this.add((Component)this.getBtnEncrypt(), this.getBtnEncrypt().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton("Help");
            this.btnHelp.setName("btnHelp");
            this.btnHelp.setBounds(410, 480, 100, 30);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: encryptdata.html");
                    EncryptData.this.theSuite.showHelp("Help", "encryptdata.html");
                }
            });
        }
        return this.btnHelp;
    }

    public void setToBeEncryptedData(String s) {
        this.txtToBeEncryptedData.setText(s);
    }

    public void setAlgorithmSelectedIndex(int i) {
        this.cbxEncryptAlgorithm.setSelectedIndex(i);
    }

    private JButton getBtnEncrypt() {
        if (this.btnEncrypt == null) {
            this.btnEncrypt = new JButton("Encrypt");
            this.btnEncrypt.setName("btnEncrypt");
            this.btnEncrypt.setBounds(290, 480, 100, 30);
            this.btnEncrypt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("Encrypt Button");
                    try {
                        EncryptData.this.doEncryptData();
                        EncryptData.this.theSuite.showInformationDialog(EncryptData.this.thePanel, "Encryption is completed.");
                    }
                    catch (DataEncryptionFailException e) {
                        EncryptData.this.theSuite.showErrorDialog(EncryptData.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (NoSuchAlgorithmException e) {
                        EncryptData.this.theSuite.showErrorDialog(EncryptData.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (InvalidKeySpecException e) {
                        EncryptData.this.theSuite.showErrorDialog(EncryptData.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        EncryptData.this.theSuite.showErrorDialog(EncryptData.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (AlgorithmSupportException e) {
                        EncryptData.this.theSuite.showErrorDialog(EncryptData.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (InvalidKeyException e) {
                        EncryptData.this.theSuite.showErrorDialog(EncryptData.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (KeyGenerateFailException e) {
                        EncryptData.this.theSuite.showErrorDialog(EncryptData.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btnEncrypt;
    }

    private JComboBox getCbxEncryptAlgorithm() {
        if (this.cbxEncryptAlgorithm == null) {
            this.cbxEncryptAlgorithm = new JComboBox();
            this.cbxEncryptAlgorithm.setName("cbxEncryptAlgorithm");
            this.cbxEncryptAlgorithm.setBackground(new Color(255, 255, 255));
            this.cbxEncryptAlgorithm.setBounds(180, 40, 240, 20);
        }
        return this.cbxEncryptAlgorithm;
    }

    private JLabel getLblEncryptedData() {
        if (this.lblEncryptedData == null) {
            this.lblEncryptedData = new JLabel("Encrypted Data: ");
            this.lblEncryptedData.setName("lblEncryptedData");
            this.lblEncryptedData.setBounds(30, 320, 120, 20);
        }
        return this.lblEncryptedData;
    }

    private JLabel getLblEncryptedAlgorithm() {
        if (this.lblEncryptAlgorithm == null) {
            this.lblEncryptAlgorithm = new JLabel("Encrypted Algorithm: ");
            this.lblEncryptAlgorithm.setName("lblEncryptAlgorithm");
            this.lblEncryptAlgorithm.setBounds(30, 40, 150, 20);
        }
        return this.lblEncryptAlgorithm;
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel(" Plain Data Encryption ");
            this.lblTitle.setName("lblTitle");
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 770, 30);
        }
        return this.lblTitle;
    }

    private JLabel getLblToBeEncryptedData() {
        if (this.lblToBeEncryptedData == null) {
            this.lblToBeEncryptedData = new JLabel("To be encrypted data:");
            this.lblToBeEncryptedData.setName("lblToBeSignedText");
            this.lblToBeEncryptedData.setBounds(30, 80, 160, 20);
        }
        return this.lblToBeEncryptedData;
    }

    private JPanel getPnlParameters() {
        if (this.pnlParameters == null) {
            this.pnlParameters = new JPanel();
            this.pnlParameters.setName("pnlParameters");
            this.pnlParameters.setLayout(null);
            this.pnlParameters.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), " Parameters: "));
            this.pnlParameters.setBounds(20, 60, 750, 250);
            this.pnlParameters.add((Component)this.getLblEncryptedAlgorithm(), this.getLblEncryptedAlgorithm().getName());
            this.pnlParameters.add((Component)this.getCbxEncryptAlgorithm(), this.getCbxEncryptAlgorithm().getName());
            this.pnlParameters.add((Component)this.getLblToBeEncryptedData(), this.getLblToBeEncryptedData().getName());
            JScrollPane scroll = new JScrollPane();
            scroll.getViewport().add(this.getTxtToBeEncryptedData());
            scroll.setBounds(60, 110, 660, 100);
            this.pnlParameters.add((Component)scroll, this.getTxtToBeEncryptedData().getName());
        }
        return this.pnlParameters;
    }

    private JTextArea getTxtEncryptedData() {
        if (this.txtEncryptedData == null) {
            this.txtEncryptedData = new JTextArea();
            this.txtEncryptedData.setName("txtEncryptedData");
            this.txtEncryptedData.setBorder(new LineBorder(new Color(0, 0, 0)));
        }
        return this.txtEncryptedData;
    }

    private JTextArea getTxtToBeEncryptedData() {
        if (this.txtToBeEncryptedData == null) {
            this.txtToBeEncryptedData = new JTextArea();
            this.txtToBeEncryptedData.setName("txtToBeSignedText");
            this.txtToBeEncryptedData.setBorder(new LineBorder(new Color(0, 0, 0)));
        }
        return this.txtToBeEncryptedData;
    }

    public void doEncryptData() throws DataEncryptionFailException, NoSuchAlgorithmException, InvalidKeySpecException, IOException, AlgorithmSupportException, InvalidKeyException, KeyGenerateFailException {
        this.manager.resetEncrypedData();
        String text = this.txtToBeEncryptedData.getText();
        byte[] raw = text.getBytes();
        int algoId = this.cbxEncryptAlgorithm.getSelectedIndex();
        this.manager.encryptData(raw, algoId);
        ByteArrayOutputStream encryptedData = this.manager.getEncryptedData();
        String encryptedTet = new String(encryptedData.toByteArray());
        this.txtEncryptedData.setText(encryptedTet);
    }
}

