/*
 * Decompiled with CFR 0.152.
 */
package ui.crypto;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import management.CryptographicManager;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Operation.DataEncryptionFailException;
import ui.TCDSecureSuite;

public class EncryptFile
extends JPanel {
    private static final long serialVersionUID = -8335261527051256033L;
    private JLabel lblTitle;
    private JLabel lblEncryptAlgorithm;
    private JLabel lblToBeEncryptedFile;
    private JLabel lblKey;
    private JLabel lblSaveToFile;
    private JComboBox cbxEncryptAlgorithm;
    private JTextField txtToBeEncryptedFile;
    private JPasswordField pwdKey;
    private JTextField txtSaveToFile;
    private JButton btnBrowseToBeEncryptFile;
    private JButton btnBrowseSaveToFile;
    private JButton btnEncrypt;
    private TCDSecureSuite theSuite = null;
    private final EncryptFile thePanel = this;
    private CryptographicManager manager = null;

    public EncryptFile(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.setName("Encrypt File");
        this.manager = theSuite.getCryptographicManager();
        this.initialise();
        this.putData();
    }

    private void putData() {
        AlgorithmSet algoSet = this.manager.getEncryptionAlgorithm();
        int i = 0;
        while (i < algoSet.size()) {
            AlgorithmProfile algoProfile = (AlgorithmProfile)algoSet.get(i);
            this.cbxEncryptAlgorithm.addItem(algoProfile.getAlgorithmName());
            ++i;
        }
    }

    public void setToBeEncryptedFile(String filename) {
        this.txtToBeEncryptedFile.setText(filename);
    }

    public void setKey(String key) {
        this.pwdKey.setText(key);
    }

    public void setSaveToFile(String filename) {
        this.txtSaveToFile.setText(filename);
    }

    public void setEncryptionAlgorithm(int i) {
        this.cbxEncryptAlgorithm.setSelectedIndex(i);
    }

    public void doEncryptFile() throws DataEncryptionFailException, NoSuchAlgorithmException, InvalidKeySpecException, IOException, AlgorithmSupportException {
        int algoId = this.cbxEncryptAlgorithm.getSelectedIndex();
        String key = new String(this.pwdKey.getPassword());
        String srcFilename = this.txtToBeEncryptedFile.getText();
        String desFilename = this.txtSaveToFile.getText();
        this.manager.encryptFile(algoId, key, srcFilename, desFilename);
    }

    private void initialise() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getLblEncryptAlgorithm(), this.getLblEncryptAlgorithm().getName());
        this.add((Component)this.getLblToBeEncryptedFile(), this.getLblToBeEncryptedFile().getName());
        this.add((Component)this.getLblKey(), this.getLblKey().getName());
        this.add((Component)this.getLblSaveToFile(), this.getLblSaveToFile().getName());
        this.add((Component)this.getCbxEncryptAlgorithm(), this.getCbxEncryptAlgorithm().getName());
        this.add((Component)this.getTxtToBeEncryptedFile(), this.getTxtToBeEncryptedFile().getName());
        this.add((Component)this.getpwdKey(), this.getpwdKey().getName());
        this.add((Component)this.getTxtSaveToFile(), this.getTxtSaveToFile().getName());
        this.add((Component)this.getBtnBrowseSaveToFile(), this.getBtnBrowseSaveToFile().getName());
        this.add((Component)this.getBtnBrowseToBeEncryptFile(), this.getBtnBrowseToBeEncryptFile().getName());
        this.add((Component)this.getBtnEncrypt(), this.getBtnEncrypt().getName());
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel(" File Encryption ");
            this.lblTitle.setName("lblTitle");
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 770, 30);
        }
        return this.lblTitle;
    }

    private JLabel getLblEncryptAlgorithm() {
        if (this.lblEncryptAlgorithm == null) {
            this.lblEncryptAlgorithm = new JLabel("Encryption Algorithm:");
            this.lblEncryptAlgorithm.setBounds(30, 60, 150, 20);
        }
        return this.lblEncryptAlgorithm;
    }

    private JComboBox getCbxEncryptAlgorithm() {
        if (this.cbxEncryptAlgorithm == null) {
            this.cbxEncryptAlgorithm = new JComboBox();
            this.cbxEncryptAlgorithm.setName("cbxEncryptAlgorithm");
            this.cbxEncryptAlgorithm.setBackground(new Color(255, 255, 255));
            this.cbxEncryptAlgorithm.setBounds(180, 60, 200, 20);
        }
        return this.cbxEncryptAlgorithm;
    }

    private JLabel getLblToBeEncryptedFile() {
        if (this.lblToBeEncryptedFile == null) {
            this.lblToBeEncryptedFile = new JLabel("To be encrypted file:");
            this.lblToBeEncryptedFile.setBounds(30, 90, 150, 20);
        }
        return this.lblToBeEncryptedFile;
    }

    private JTextField getTxtToBeEncryptedFile() {
        if (this.txtToBeEncryptedFile == null) {
            this.txtToBeEncryptedFile = new JTextField();
            this.txtToBeEncryptedFile.setBounds(180, 90, 200, 20);
        }
        return this.txtToBeEncryptedFile;
    }

    private JButton getBtnBrowseToBeEncryptFile() {
        if (this.btnBrowseToBeEncryptFile == null) {
            this.btnBrowseToBeEncryptFile = new JButton("Browse");
            this.btnBrowseToBeEncryptFile.setBounds(400, 90, 100, 20);
            this.btnBrowseToBeEncryptFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("Browse To Be Encrypted File");
                    JFileChooser fileChooser = new JFileChooser(TCDSecureSuite.DEFAULT_DIR);
                    int returnVal = fileChooser.showOpenDialog(EncryptFile.this.theSuite);
                    if (returnVal == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        String filename = selectedFile.getName();
                        EncryptFile.this.txtToBeEncryptedFile.setText(selectedFile.getPath());
                        EncryptFile.this.txtSaveToFile.setText(String.valueOf(selectedFile.getPath()) + ".enc");
                    }
                }
            });
        }
        return this.btnBrowseToBeEncryptFile;
    }

    private JLabel getLblKey() {
        if (this.lblKey == null) {
            this.lblKey = new JLabel("Key:");
            this.lblKey.setBounds(30, 120, 150, 20);
        }
        return this.lblKey;
    }

    private JTextField getpwdKey() {
        if (this.pwdKey == null) {
            this.pwdKey = new JPasswordField();
            this.pwdKey.setBounds(180, 120, 200, 20);
        }
        return this.pwdKey;
    }

    private JLabel getLblSaveToFile() {
        if (this.lblSaveToFile == null) {
            this.lblSaveToFile = new JLabel("Save to file:");
            this.lblSaveToFile.setBounds(30, 150, 150, 20);
        }
        return this.lblSaveToFile;
    }

    private JTextField getTxtSaveToFile() {
        if (this.txtSaveToFile == null) {
            this.txtSaveToFile = new JTextField();
            this.txtSaveToFile.setBounds(180, 150, 200, 20);
        }
        return this.txtSaveToFile;
    }

    private JButton getBtnBrowseSaveToFile() {
        if (this.btnBrowseSaveToFile == null) {
            this.btnBrowseSaveToFile = new JButton("Browse");
            this.btnBrowseSaveToFile.setBounds(400, 150, 100, 20);
            this.btnBrowseSaveToFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("Browse Save to File");
                    JFileChooser fileChooser = new JFileChooser(TCDSecureSuite.DEFAULT_DIR);
                    int returnVal = fileChooser.showSaveDialog(EncryptFile.this.theSuite);
                    if (returnVal == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        String filename = selectedFile.getName();
                        EncryptFile.this.txtSaveToFile.setText(selectedFile.getPath());
                    }
                }
            });
        }
        return this.btnBrowseSaveToFile;
    }

    private JButton getBtnEncrypt() {
        if (this.btnEncrypt == null) {
            this.btnEncrypt = new JButton("Encrypt");
            this.btnEncrypt.setBounds(200, 200, 100, 30);
            this.btnEncrypt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int returnValue;
                    System.out.println("Encrypt");
                    String toBeEncryptedFilename = EncryptFile.this.txtToBeEncryptedFile.getText();
                    String saveToFilename = EncryptFile.this.txtSaveToFile.getText();
                    File toBeEncryptedFile = new File(toBeEncryptedFilename);
                    if (!toBeEncryptedFile.exists()) {
                        EncryptFile.this.theSuite.showWarningDialog(EncryptFile.this.thePanel, "To be encrypted [" + toBeEncryptedFilename + "] does not exist.\nPlease choose a file to be encrypted.");
                        return;
                    }
                    if (saveToFilename.trim().length() == 0) {
                        EncryptFile.this.theSuite.showWarningDialog(EncryptFile.this.thePanel, "Please specify an output file.");
                        return;
                    }
                    if (saveToFilename.equals(toBeEncryptedFilename)) {
                        EncryptFile.this.theSuite.showErrorDialog(EncryptFile.this.thePanel, "The output filename cannot be identical with the source");
                        return;
                    }
                    if (EncryptFile.this.pwdKey.getPassword().length == 0 && (returnValue = JOptionPane.showConfirmDialog(null, "Are you sure to proceed with blank key?", "Key Confirmation", 0)) == 1) {
                        return;
                    }
                    try {
                        System.out.println("doEncryptFile");
                        EncryptFile.this.doEncryptFile();
                        EncryptFile.this.theSuite.showInformationDialog(EncryptFile.this.thePanel, "Encryption is completed.");
                    }
                    catch (DataEncryptionFailException e) {
                        EncryptFile.this.theSuite.showErrorDialog(EncryptFile.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (NoSuchAlgorithmException e) {
                        EncryptFile.this.theSuite.showErrorDialog(EncryptFile.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (InvalidKeySpecException e) {
                        EncryptFile.this.theSuite.showErrorDialog(EncryptFile.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        EncryptFile.this.theSuite.showErrorDialog(EncryptFile.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (AlgorithmSupportException e) {
                        EncryptFile.this.theSuite.showErrorDialog(EncryptFile.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btnEncrypt;
    }
}

