/*
 * Decompiled with CFR 0.152.
 */
package ui.crypto;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import management.CryptographicManager;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import ui.TCDSecureSuite;

public class Signing
extends JPanel {
    private static final long serialVersionUID = 3151047799817972778L;
    private JLabel lblTitle = null;
    private JPanel pnlParameters = null;
    private JLabel lblSignature = null;
    private JTextArea txtSignature = null;
    private JButton btnSign = null;
    private JButton btnHelp = null;
    private JLabel lblSignerCertificate = null;
    private JLabel lblSignerAlgorithm = null;
    private JComboBox cbxSignerCertificate = null;
    private JComboBox cbxSignerAlgorithm = null;
    private JLabel lblToBeSignedText = null;
    private JTextArea txtToBeSignedText = null;
    private TCDSecureSuite theSuite = null;
    private final Signing thePanel = this;
    private CryptographicManager manager = null;

    public Signing(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.initialise();
        this.manager = theSuite.getCryptographicManager();
        this.putData();
    }

    private void putData() {
        try {
            CertProfile[] certProfileList = this.manager.getCertificates();
            int i = 0;
            while (i < certProfileList.length) {
                CertProfile certProfile = certProfileList[i];
                this.cbxSignerCertificate.addItem(certProfile.getSubjectDN().getCommonName());
                ++i;
            }
        }
        catch (SecureStoreException e1) {
            this.theSuite.showErrorDialog(this.thePanel, e1.getMessage());
            e1.printStackTrace();
        }
        catch (ASN1Exception e1) {
            this.theSuite.showErrorDialog(this.thePanel, e1.getMessage());
            e1.printStackTrace();
        }
        AlgorithmSet algoSet = this.manager.getAlgorithmSet();
        int i = 0;
        while (i < algoSet.size()) {
            AlgorithmProfile algoProfile = (AlgorithmProfile)algoSet.get(i);
            this.cbxSignerAlgorithm.addItem(algoProfile.getAlgorithmName());
            ++i;
        }
    }

    private void initialise() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getPnlParameters(), this.getPnlParameters().getName());
        this.add((Component)this.getLblSignature(), this.getLblSignature().getName());
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.getTxtSignature());
        scroll.setBounds(80, 350, 660, 100);
        this.add((Component)scroll, this.getTxtSignature().getName());
        this.add((Component)this.getBtnSign(), this.getBtnSign().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton("Help");
            this.btnHelp.setName("btnHelp");
            this.btnHelp.setBounds(410, 480, 100, 30);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: signing.html");
                    Signing.this.theSuite.showHelp("Help", "signing.html");
                }
            });
        }
        return this.btnHelp;
    }

    public void setToBeSignedText(String s) {
        this.txtToBeSignedText.setText(s);
    }

    public void setAlgorithmSelectedIndex(int i) {
        this.cbxSignerAlgorithm.setSelectedIndex(i);
    }

    public void doSigning() throws InvalidKeyException, SecureStoreException, NoSuchAlgorithmException, SecureStoreFindingFailException, SignatureException, AlgorithmSupportException, IOException {
        this.manager.resetSignedData();
        String text = this.txtToBeSignedText.getText();
        byte[] raw = text.getBytes();
        int profileId = this.cbxSignerCertificate.getSelectedIndex();
        int algoId = this.cbxSignerAlgorithm.getSelectedIndex();
        this.manager.signdata(raw, profileId, algoId);
        ByteArrayOutputStream signedData = this.manager.getSignedData();
        String signedText = new String(signedData.toByteArray());
        this.txtSignature.setText(signedText);
    }

    private JButton getBtnSign() {
        if (this.btnSign == null) {
            this.btnSign = new JButton("Sign");
            this.btnSign.setName("btnSign");
            this.btnSign.setBounds(290, 480, 100, 30);
            this.btnSign.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("Sign data");
                    try {
                        Signing.this.doSigning();
                        Signing.this.theSuite.showInformationDialog(Signing.this.thePanel, "Signing is completed.");
                        System.out.println("Sign Button");
                    }
                    catch (InvalidKeyException e) {
                        Signing.this.theSuite.showErrorDialog(Signing.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (SecureStoreException e) {
                        Signing.this.theSuite.showErrorDialog(Signing.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (NoSuchAlgorithmException e) {
                        Signing.this.theSuite.showErrorDialog(Signing.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (SecureStoreFindingFailException e) {
                        Signing.this.theSuite.showErrorDialog(Signing.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (SignatureException e) {
                        Signing.this.theSuite.showErrorDialog(Signing.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (AlgorithmSupportException e) {
                        Signing.this.theSuite.showErrorDialog(Signing.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        Signing.this.theSuite.showErrorDialog(Signing.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btnSign;
    }

    private JComboBox getCbxSignerAlgorithm() {
        if (this.cbxSignerAlgorithm == null) {
            this.cbxSignerAlgorithm = new JComboBox();
            this.cbxSignerAlgorithm.setName("cbxSignerAlgorithm");
            this.cbxSignerAlgorithm.setBackground(new Color(255, 255, 255));
            this.cbxSignerAlgorithm.setBounds(150, 50, 240, 20);
        }
        return this.cbxSignerAlgorithm;
    }

    private JComboBox getCbxSignerCertificate() {
        if (this.cbxSignerCertificate == null) {
            this.cbxSignerCertificate = new JComboBox();
            this.cbxSignerCertificate.setName("cbxSignerCertificate");
            this.cbxSignerCertificate.setBackground(new Color(255, 255, 255));
            this.cbxSignerCertificate.setBounds(150, 20, 240, 20);
        }
        return this.cbxSignerCertificate;
    }

    private JLabel getLblSignature() {
        if (this.lblSignature == null) {
            this.lblSignature = new JLabel("Signature: ");
            this.lblSignature.setName("lblSignature");
            this.lblSignature.setBounds(30, 320, 120, 20);
        }
        return this.lblSignature;
    }

    private JLabel getLblSignerAlgorithm() {
        if (this.lblSignerAlgorithm == null) {
            this.lblSignerAlgorithm = new JLabel("Signer Algorithm: ");
            this.lblSignerAlgorithm.setName("lblSignerAlgorithm");
            this.lblSignerAlgorithm.setBounds(30, 50, 120, 20);
        }
        return this.lblSignerAlgorithm;
    }

    private JLabel getLblSignerCertificate() {
        if (this.lblSignerCertificate == null) {
            this.lblSignerCertificate = new JLabel("Signer Certificate: ");
            this.lblSignerCertificate.setName("lblSignerCertificate");
            this.lblSignerCertificate.setBounds(30, 20, 120, 20);
        }
        return this.lblSignerCertificate;
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel(" Plain Data Signing ");
            this.lblTitle.setName("lblTitle");
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 770, 30);
        }
        return this.lblTitle;
    }

    private JLabel getLblToBeSignedText() {
        if (this.lblToBeSignedText == null) {
            this.lblToBeSignedText = new JLabel("To be signed text:");
            this.lblToBeSignedText.setName("lblToBeSignedText");
            this.lblToBeSignedText.setBounds(30, 80, 120, 20);
        }
        return this.lblToBeSignedText;
    }

    private JPanel getPnlParameters() {
        if (this.pnlParameters == null) {
            this.pnlParameters = new JPanel();
            this.pnlParameters.setName("pnlParameters");
            this.pnlParameters.setLayout(null);
            this.pnlParameters.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), " Parameters: "));
            this.pnlParameters.setBounds(20, 60, 750, 250);
            this.pnlParameters.add((Component)this.getLblSignerCertificate(), this.getLblSignerCertificate().getName());
            this.pnlParameters.add((Component)this.getCbxSignerCertificate(), this.getCbxSignerCertificate().getName());
            this.pnlParameters.add((Component)this.getLblSignerAlgorithm(), this.getLblSignerAlgorithm().getName());
            this.pnlParameters.add((Component)this.getCbxSignerAlgorithm(), this.getCbxSignerAlgorithm().getName());
            this.pnlParameters.add((Component)this.getLblToBeSignedText(), this.getLblToBeSignedText().getName());
            JScrollPane scroll2 = new JScrollPane();
            scroll2.getViewport().add(this.getTxtToBeSignedText());
            scroll2.setBounds(60, 110, 660, 100);
            this.pnlParameters.add((Component)scroll2, this.getTxtToBeSignedText().getName());
        }
        return this.pnlParameters;
    }

    private JTextArea getTxtSignature() {
        if (this.txtSignature == null) {
            this.txtSignature = new JTextArea();
            this.txtSignature.setName("txtSignature");
            this.txtSignature.setBorder(new LineBorder(new Color(0, 0, 0)));
        }
        return this.txtSignature;
    }

    private JTextArea getTxtToBeSignedText() {
        if (this.txtToBeSignedText == null) {
            this.txtToBeSignedText = new JTextArea();
            this.txtToBeSignedText.setName("txtToBeSignedText");
            this.txtToBeSignedText.setBorder(new LineBorder(new Color(0, 0, 0)));
        }
        return this.txtToBeSignedText;
    }
}

