/*
 * Decompiled with CFR 0.152.
 */
package ui.help;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import ui.TCDSecureSuite;
import ui.help.LogData;
import ui.help.LogDataModel;
import ui.help.LogTable;

public class LogManager
extends JPanel {
    private static final long serialVersionUID = 236549074230638225L;
    private JLabel lblFilter;
    private JComboBox cbxFilter = null;
    private JLabel lblTitle = null;
    private JTabbedPane tabPanel = null;
    private JButton btnExport = null;
    private JButton btnLoadOldLog = null;
    private JButton btnLoadCurrentLog = null;
    private JButton btnHelp = null;
    private JScrollPane splAllEvent = null;
    private JScrollPane splGeneral = null;
    private JScrollPane splAgent = null;
    private JScrollPane splTrusted = null;
    private JScrollPane splCryptographic = null;
    private JScrollPane splDataPackaging = null;
    private LogTable tblAllEvent = null;
    private LogTable tblGeneral = null;
    private LogTable tblAgent = null;
    private LogTable tblTrusted = null;
    private LogTable tblCryptographic = null;
    private LogTable tblDataPackaging = null;
    private LogDataModel allEventModel = null;
    private LogDataModel generalModel = null;
    private LogDataModel agentModel = null;
    private LogDataModel trustModel = null;
    private LogDataModel cryptoModel = null;
    private LogDataModel packagingModel = null;
    private TCDSecureSuite theSuite = null;
    private String currentLogFileName = null;
    private String loginfo;

    public void filter(String fLevel) {
        this.allEventModel.clearTable();
        this.generalModel.clearTable();
        this.agentModel.clearTable();
        this.trustModel.clearTable();
        this.cryptoModel.clearTable();
        this.packagingModel.clearTable();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.currentLogFileName)));
            String s = "";
            this.loginfo = "";
            while ((s = br.readLine()) != null) {
                this.loginfo = String.valueOf(this.loginfo) + s + "\n";
                StringTokenizer st = new StringTokenizer(s, "\t");
                if (!st.hasMoreTokens()) continue;
                String datetime = "";
                String level = "";
                String group = "";
                String description = "";
                if (st.hasMoreTokens()) {
                    datetime = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    level = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    group = st.nextToken();
                }
                while (st.hasMoreTokens()) {
                    description = String.valueOf(description) + " " + st.nextToken();
                }
                if (!level.equals(fLevel) && !fLevel.equals("ALL")) continue;
                this.allEventModel.addData(new LogData(datetime, level, description));
                if (group.equalsIgnoreCase("GENERAL")) {
                    this.generalModel.addData(new LogData(datetime, level, description));
                    continue;
                }
                if (group.equalsIgnoreCase("AGENT")) {
                    this.agentModel.addData(new LogData(datetime, level, description));
                    continue;
                }
                if (group.equalsIgnoreCase("TRUSTED")) {
                    this.trustModel.addData(new LogData(datetime, level, description));
                    continue;
                }
                if (group.equalsIgnoreCase("CRYPTOGRAPHIC")) {
                    this.cryptoModel.addData(new LogData(datetime, level, description));
                    continue;
                }
                if (!group.equalsIgnoreCase("DATAPACKAGING")) continue;
                this.packagingModel.addData(new LogData(datetime, level, description));
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.allEventModel.fireTableDataChanged();
        this.generalModel.fireTableDataChanged();
        this.trustModel.fireTableDataChanged();
        this.cryptoModel.fireTableDataChanged();
        this.packagingModel.fireTableDataChanged();
    }

    private JLabel getLblFilter() {
        if (this.lblFilter == null) {
            this.lblFilter = new JLabel("Filtered by Level:");
            this.lblFilter.setBounds(40, 50, 150, 20);
        }
        return this.lblFilter;
    }

    private JComboBox getCbxFilter() {
        if (this.cbxFilter == null) {
            this.cbxFilter = new JComboBox();
            this.cbxFilter.setBounds(150, 50, 150, 20);
            this.cbxFilter.setBackground(new Color(255, 255, 255));
            this.cbxFilter.addItem("ALL");
            this.cbxFilter.addItem("DEBUG");
            this.cbxFilter.addItem("INFO");
            this.cbxFilter.addItem("WARNING");
            this.cbxFilter.addItem("ERROR");
            this.cbxFilter.addItem("FATAL");
            this.cbxFilter.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    LogManager.this.filter((String)LogManager.this.cbxFilter.getSelectedItem());
                }
            });
        }
        return this.cbxFilter;
    }

    public static void archiveLog(String logPathName, String logFileName) {
        try {
            StringTokenizer st;
            System.out.println("Log Archiving : \t" + logPathName);
            System.out.println("\t\t" + logFileName);
            File file = new File(String.valueOf(logPathName) + "/" + logFileName);
            Date tmpDate = new Date();
            Date today = new Date(tmpDate.getYear(), tmpDate.getMonth(), tmpDate.getDate(), 0, 0, 0);
            System.out.println("Log Today: " + today);
            Date fileDate = today;
            String s = "";
            String date = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            s = br.readLine();
            if (s != null && (st = new StringTokenizer(s, "\t")).hasMoreTokens()) {
                String datetime = "";
                String level = "";
                String group = "";
                String description = "";
                if (st.hasMoreTokens()) {
                    datetime = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    level = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    group = st.nextToken();
                }
                while (st.hasMoreTokens()) {
                    description = String.valueOf(description) + " " + st.nextToken();
                }
                StringTokenizer st2 = new StringTokenizer(datetime, " ");
                if (st2.hasMoreTokens()) {
                    date = st2.nextToken();
                    StringTokenizer st3 = new StringTokenizer(date, "-");
                    int yy = Integer.parseInt(st3.nextToken()) - 2443;
                    int mm = Integer.parseInt(st3.nextToken()) - 1;
                    int dd = Integer.parseInt(st3.nextToken());
                    fileDate = new Date(yy, mm, dd);
                    System.out.println("File date " + fileDate);
                    System.out.println("\t\t" + yy + " " + mm + " " + dd);
                }
            }
            br.close();
            if (fileDate.before(today)) {
                String logNewPath = String.valueOf(logPathName) + "/" + logFileName + "." + fileDate.getDay() + fileDate.getMonth() + fileDate.getYear();
                System.out.println("Log archieve to " + logNewPath);
                file.renameTo(new File(logNewPath));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogManager(TCDSecureSuite theSuite, String logFileName) {
        this.setLayout(null);
        this.theSuite = theSuite;
        this.currentLogFileName = logFileName;
        this.setName("Log Manager");
        this.openLogFile(logFileName);
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getLblFilter(), this.getLblFilter().getName());
        this.add((Component)this.getCbxFilter(), this.getCbxFilter().getName());
        this.add((Component)this.getTabPanel(), this.getTabPanel().getName());
        this.add((Component)this.getBtnExport(), this.getBtnExport().getName());
        this.add((Component)this.getBtnLoadOldLog(), this.getBtnLoadOldLog().getName());
        this.add((Component)this.getBtnLoadCurrentLog(), this.getBtnLoadCurrentLog().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
    }

    private void openLogFile(String logFileName) {
        this.allEventModel = new LogDataModel();
        this.generalModel = new LogDataModel();
        this.agentModel = new LogDataModel();
        this.trustModel = new LogDataModel();
        this.cryptoModel = new LogDataModel();
        this.packagingModel = new LogDataModel();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(logFileName)));
            String s = "";
            this.loginfo = "";
            while ((s = br.readLine()) != null) {
                this.loginfo = String.valueOf(this.loginfo) + s + "\n";
                StringTokenizer st = new StringTokenizer(s, "\t");
                if (!st.hasMoreTokens()) continue;
                String datetime = "";
                String level = "";
                String group = "";
                String description = "";
                if (st.hasMoreTokens()) {
                    datetime = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    level = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    group = st.nextToken();
                }
                while (st.hasMoreTokens()) {
                    description = String.valueOf(description) + " " + st.nextToken();
                }
                this.allEventModel.addData(new LogData(datetime, level, description));
                if (group.equalsIgnoreCase("GENERAL")) {
                    this.generalModel.addData(new LogData(datetime, level, description));
                    continue;
                }
                if (group.equalsIgnoreCase("AGENT")) {
                    this.agentModel.addData(new LogData(datetime, level, description));
                    continue;
                }
                if (group.equalsIgnoreCase("TRUSTED")) {
                    this.trustModel.addData(new LogData(datetime, level, description));
                    continue;
                }
                if (group.equalsIgnoreCase("CRYPTOGRAPHIC")) {
                    this.cryptoModel.addData(new LogData(datetime, level, description));
                    continue;
                }
                if (!group.equalsIgnoreCase("DATAPACKAGING")) continue;
                this.packagingModel.addData(new LogData(datetime, level, description));
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private LogTable getTblAllEvent() {
        if (this.tblAllEvent == null) {
            this.tblAllEvent = new LogTable(this.theSuite, this.allEventModel);
        }
        return this.tblAllEvent;
    }

    private LogTable getTblGeneral() {
        if (this.tblGeneral == null) {
            this.tblGeneral = new LogTable(this.theSuite, this.generalModel);
        }
        return this.tblGeneral;
    }

    private LogTable getTblAgent() {
        if (this.tblAgent == null) {
            this.tblAgent = new LogTable(this.theSuite, this.agentModel);
        }
        return this.tblAgent;
    }

    private LogTable getTblCryptographic() {
        if (this.tblCryptographic == null) {
            this.tblCryptographic = new LogTable(this.theSuite, this.cryptoModel);
        }
        return this.tblCryptographic;
    }

    private LogTable getTblDataPackaging() {
        if (this.tblDataPackaging == null) {
            this.tblDataPackaging = new LogTable(this.theSuite, this.packagingModel);
        }
        return this.tblDataPackaging;
    }

    private LogTable getTblTrusted() {
        if (this.tblTrusted == null) {
            this.tblTrusted = new LogTable(this.theSuite, this.trustModel);
        }
        return this.tblTrusted;
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel(" Log Manager ");
            this.lblTitle.setBounds(10, 10, 760, 30);
            this.lblTitle.setBorder(new LineBorder(new Color(0, 0, 0)));
        }
        return this.lblTitle;
    }

    private JTabbedPane getTabPanel() {
        if (this.tabPanel == null) {
            this.tabPanel = new JTabbedPane(1);
            this.tabPanel.setBounds(10, 80, 760, 360);
            this.tabPanel.addTab("All Events", this.getSplAllEvent());
            this.tabPanel.addTab("General", this.getSplGeneral());
            this.tabPanel.addTab("Agent", this.getSplAgent());
            this.tabPanel.addTab("Trusted", this.getSplTrusted());
            this.tabPanel.addTab("Cryptographic", this.getSplCryptographic());
            this.tabPanel.addTab("Data Packaging", this.getSplDataPackaging());
        }
        return this.tabPanel;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton("Export");
            this.btnExport.setBounds(120, 480, 120, 30);
            this.btnExport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser dialog = new JFileChooser();
                    dialog.showSaveDialog(LogManager.this.theSuite);
                    File file = dialog.getSelectedFile();
                    try {
                        PrintWriter pw = new PrintWriter(new FileOutputStream(file));
                        pw.println(LogManager.this.loginfo);
                        pw.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return this.btnExport;
    }

    private JButton getBtnLoadOldLog() {
        if (this.btnLoadOldLog == null) {
            this.btnLoadOldLog = new JButton("Load Old Log");
            this.btnLoadOldLog.setBounds(250, 480, 150, 30);
            this.btnLoadOldLog.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser dialog = new JFileChooser();
                    dialog.showOpenDialog(LogManager.this.theSuite);
                    File file = dialog.getSelectedFile();
                    LogManager.this.openLogFile(file.getPath());
                    LogManager.this.tblAllEvent.setModel(LogManager.this.allEventModel);
                    LogManager.this.tblGeneral.setModel(LogManager.this.generalModel);
                    LogManager.this.tblAgent.setModel(LogManager.this.agentModel);
                    LogManager.this.tblTrusted.setModel(LogManager.this.trustModel);
                    LogManager.this.tblCryptographic.setModel(LogManager.this.cryptoModel);
                    LogManager.this.tblDataPackaging.setModel(LogManager.this.packagingModel);
                }
            });
        }
        return this.btnLoadOldLog;
    }

    private JButton getBtnLoadCurrentLog() {
        if (this.btnLoadCurrentLog == null) {
            this.btnLoadCurrentLog = new JButton("Load Current Log");
            this.btnLoadCurrentLog.setBounds(410, 480, 150, 30);
            this.btnLoadCurrentLog.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LogManager.this.openLogFile(LogManager.this.currentLogFileName);
                    LogManager.this.tblAllEvent.setModel(LogManager.this.allEventModel);
                    LogManager.this.tblGeneral.setModel(LogManager.this.generalModel);
                    LogManager.this.tblAgent.setModel(LogManager.this.agentModel);
                    LogManager.this.tblTrusted.setModel(LogManager.this.trustModel);
                    LogManager.this.tblCryptographic.setModel(LogManager.this.cryptoModel);
                    LogManager.this.tblDataPackaging.setModel(LogManager.this.packagingModel);
                }
            });
        }
        return this.btnLoadCurrentLog;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton("Help");
            this.btnHelp.setBounds(570, 480, 120, 30);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: LogManager.html");
                    LogManager.this.theSuite.showHelp("Help", "LogManager.html");
                }
            });
        }
        return this.btnHelp;
    }

    private JScrollPane getSplAllEvent() {
        if (this.splAllEvent == null) {
            this.splAllEvent = new JScrollPane(this.getTblAllEvent());
        }
        return this.splAllEvent;
    }

    private JScrollPane getSplGeneral() {
        if (this.splGeneral == null) {
            this.splGeneral = new JScrollPane(this.getTblGeneral());
        }
        return this.splGeneral;
    }

    private JScrollPane getSplAgent() {
        if (this.splAgent == null) {
            this.splAgent = new JScrollPane(this.getTblAgent());
        }
        return this.splAgent;
    }

    private JScrollPane getSplTrusted() {
        if (this.splTrusted == null) {
            this.splTrusted = new JScrollPane(this.getTblTrusted());
        }
        return this.splTrusted;
    }

    private JScrollPane getSplCryptographic() {
        if (this.splCryptographic == null) {
            this.splCryptographic = new JScrollPane(this.getTblCryptographic());
        }
        return this.splCryptographic;
    }

    private JScrollPane getSplDataPackaging() {
        if (this.splDataPackaging == null) {
            this.splDataPackaging = new JScrollPane(this.getTblDataPackaging());
        }
        return this.splDataPackaging;
    }
}

