/*
 * Decompiled with CFR 0.152.
 */
package ui.packaging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import management.SecurePackageManager;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.KeeperSoftException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Packaging.SecurePackageEncipherException;
import th.co.oga.security.pki.Packaging.SecurePackageEncodingFailException;
import th.co.oga.security.pki.Packaging.SecurePackageEnvelopeException;
import th.co.oga.security.pki.Packaging.SecurePackageInvalidDataException;
import ui.TCDSecureSuite;
import ui.packaging.CertProfileItem;

public class DataEnvelope
extends JPanel {
    private static final long serialVersionUID = 3541616203446839515L;
    private JLabel lblTitle = null;
    private JPanel pnlContent = null;
    private JLabel lblRecipient = null;
    private JLabel lblSelectedRecipient = null;
    private JList lstRecipient = null;
    private JList lstSelectedRecipient = null;
    private JButton btnAddRecipient = null;
    private JButton btnRemoveRecipient = null;
    private JButton btnEnvelope = null;
    private JButton btnSaveToFile = null;
    private JButton btnHelp = null;
    private ButtonGroup grpRadioButton = null;
    private JRadioButton radFromFile = null;
    private JRadioButton radFromRawData = null;
    private JTextField txtFromFile = null;
    private JButton btnBrowse = null;
    private JTextArea txtFromRawData = null;
    private JLabel lblContentType = null;
    private JLabel datContentType = null;
    private TCDSecureSuite theSuite = null;
    private Room room = null;
    private SecurePackageManager manager = null;
    private final DataEnvelope thePanel = this;
    private DefaultListModel lstSelectedRecipientData;
    private DefaultListModel lstRecipientData;
    private String envelopeFilename;

    public DataEnvelope(TCDSecureSuite theSuite) {
        try {
            this.theSuite = theSuite;
            this.room = theSuite.getRoom();
            this.manager = theSuite.getSecurePackageManager();
            System.out.println("manager " + this.manager);
            this.initialise();
            this.setName("Data Envelope");
            this.btnSaveToFile.setEnabled(false);
            this.btnSaveToFile.setVisible(false);
            this.putData();
        }
        catch (SecureStoreException e) {
            theSuite.showErrorDialog(this.thePanel, "Unable to get Secure Package Manager\n" + e.getMessage());
            e.printStackTrace();
            this.btnEnvelope.setEnabled(false);
        }
        catch (AlgorithmSupportException e) {
            theSuite.showErrorDialog(this.thePanel, "Unable to get Secure Package Manager\n" + e.getMessage());
            e.printStackTrace();
            this.btnEnvelope.setEnabled(false);
        }
        catch (EntryNotFoundException e) {
            theSuite.showErrorDialog(this.thePanel, "Unable to get Secure Package Manager\n" + e.getMessage());
            e.printStackTrace();
            this.btnEnvelope.setEnabled(false);
        }
    }

    private void putData() {
        try {
            SecureStoreOperator operator = this.room.getSecureStoreOperator();
            List list = operator.getCertificates("TRUSTED Certificate");
            for (CertProfile certProfile : list) {
                CertProfileItem certProfileItem = new CertProfileItem(certProfile);
                this.lstRecipientData.addElement(certProfileItem);
                String commonName = certProfile.getSubjectDN().getCommonName();
                System.out.println("Add to available recipient list " + commonName);
            }
        }
        catch (KeeperSoftException e) {
            this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
            e.printStackTrace();
        }
        catch (ASN1Exception e) {
            this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
            e.printStackTrace();
        }
        catch (CertificateException e) {
            this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
            e.printStackTrace();
        }
    }

    public void initialise() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getPnlContent(), this.getPnlContent().getName());
        this.add((Component)this.getLblRecipient(), this.getLblRecipient().getName());
        JScrollPane scroll1 = new JScrollPane();
        scroll1.setBounds(50, 380, 250, 60);
        scroll1.getViewport().add(this.getLstRecipient());
        this.add((Component)scroll1, this.getLstRecipient().getName());
        JScrollPane scroll2 = new JScrollPane();
        scroll2.setBounds(400, 380, 250, 60);
        scroll2.getViewport().add(this.getLstSelectedRecipient());
        this.add((Component)scroll2, this.getLstSelectedRecipient().getName());
        this.add((Component)this.getBtnAddRecipient(), this.getBtnAddRecipient().getName());
        this.add((Component)this.getBtnRemoveRecipient(), this.getBtnRemoveRecipient().getName());
        this.add((Component)this.getBtnEnvelope(), this.getBtnEnvelope().getName());
        this.add((Component)this.getBtnSaveToFile(), this.getBtnSaveToFile().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel(" XML Data Envelope");
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 760, 30);
        }
        return this.lblTitle;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(null);
            this.pnlContent.setBorder(new TitledBorder(new LineBorder(new Color(255, 255, 255)), "  Content:  "));
            this.pnlContent.setBounds(30, 50, 720, 300);
            this.grpRadioButton = this.getGrpRadioButton();
            this.pnlContent.add((Component)this.getRadFromFile(), this.getRadFromFile().getName());
            this.pnlContent.add((Component)this.getTxtFromFile(), this.getTxtFromFile().getName());
            this.pnlContent.add((Component)this.getBtnBrowse(), this.getBtnBrowse().getName());
            this.pnlContent.add((Component)this.getRadFromRawData(), this.getRadFromRawData().getName());
            JScrollPane scroll = new JScrollPane();
            scroll.getViewport().add(this.getTxtFromRawData());
            scroll.setBounds(180, 50, 400, 150);
            this.pnlContent.add((Component)scroll, this.getTxtFromRawData().getName());
            this.pnlContent.add((Component)this.getLblContentType(), this.getLblContentType().getName());
            this.pnlContent.add((Component)this.getDatContentType(), this.getDatContentType().getName());
        }
        return this.pnlContent;
    }

    private JLabel getLblRecipient() {
        if (this.lblRecipient == null) {
            this.lblRecipient = new JLabel("Recipient: ");
            this.lblRecipient.setBounds(50, 360, 100, 25);
        }
        return this.lblRecipient;
    }

    private JLabel getLblSelectedRecipient() {
        if (this.lblSelectedRecipient == null) {
            this.lblSelectedRecipient = new JLabel("Selected Recipient: ");
            this.lblSelectedRecipient.setBounds(400, 360, 150, 25);
        }
        return this.lblSelectedRecipient;
    }

    private JList getLstRecipient() {
        if (this.lstRecipient == null) {
            this.lstRecipientData = new DefaultListModel();
            this.lstRecipient = new JList(this.lstRecipientData);
            this.lstRecipient.setBackground(new Color(255, 255, 255));
        }
        return this.lstRecipient;
    }

    private JList getLstSelectedRecipient() {
        if (this.lstSelectedRecipient == null) {
            this.lstSelectedRecipientData = new DefaultListModel();
            this.lstSelectedRecipient = new JList(this.lstSelectedRecipientData);
            this.lstSelectedRecipient.setBackground(new Color(255, 255, 255));
        }
        return this.lstSelectedRecipient;
    }

    private JButton getBtnAddRecipient() {
        if (this.btnAddRecipient == null) {
            this.btnAddRecipient = new JButton("Add");
            this.btnAddRecipient.setBounds(310, 385, 80, 25);
            this.btnAddRecipient.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataEnvelope.this.selectCurrentRecipient();
                }
            });
        }
        return this.btnAddRecipient;
    }

    private JButton getBtnRemoveRecipient() {
        if (this.btnRemoveRecipient == null) {
            this.btnRemoveRecipient = new JButton("Remove");
            this.btnRemoveRecipient.setBounds(310, 410, 80, 25);
            this.btnRemoveRecipient.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataEnvelope.this.unselectCurrentRecipient();
                }
            });
        }
        return this.btnRemoveRecipient;
    }

    private JButton getBtnEnvelope() {
        if (this.btnEnvelope == null) {
            this.btnEnvelope = new JButton("Envelope");
            this.btnEnvelope.setBounds(220, 460, 120, 30);
            this.btnEnvelope.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        if (DataEnvelope.this.lstSelectedRecipientData.isEmpty()) {
                            DataEnvelope.this.theSuite.showErrorDialog(DataEnvelope.this.thePanel, "No recipient has been specified.");
                            return;
                        }
                        DataEnvelope.this.doEnvelope();
                        DataEnvelope.this.btnSaveToFile.setEnabled(true);
                        DataEnvelope.this.theSuite.showInformationDialog(DataEnvelope.this.thePanel, "Recipients have been added to the envelope.");
                        JFileChooser fileChooser = DataEnvelope.this.theSuite.getFileChosser();
                        int returnVal = fileChooser.showSaveDialog(DataEnvelope.this.theSuite);
                        if (returnVal == 0) {
                            File selectedFile = fileChooser.getSelectedFile();
                            String filename = selectedFile.getAbsolutePath();
                            DataEnvelope.this.setEnvelopeFilename(filename);
                            DataEnvelope.this.doSave();
                            DataEnvelope.this.theSuite.showInformationDialog(DataEnvelope.this.thePanel, "Envelope is successfully saved.");
                        }
                    }
                    catch (SecurePackageEncodingFailException e) {
                        DataEnvelope.this.theSuite.showErrorDialog(DataEnvelope.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (SecurePackageEnvelopeException e) {
                        DataEnvelope.this.theSuite.showErrorDialog(DataEnvelope.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        DataEnvelope.this.theSuite.showErrorDialog(DataEnvelope.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (SecurePackageEncipherException e) {
                        DataEnvelope.this.theSuite.showErrorDialog(DataEnvelope.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        DataEnvelope.this.theSuite.showErrorDialog(DataEnvelope.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btnEnvelope;
    }

    private JButton getBtnSaveToFile() {
        if (this.btnSaveToFile == null) {
            this.btnSaveToFile = new JButton("Save To File");
            this.btnSaveToFile.setBounds(260, 460, 120, 30);
            this.btnSaveToFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = DataEnvelope.this.theSuite.getFileChosser();
                    int returnVal = fileChooser.showOpenDialog(DataEnvelope.this.theSuite);
                    if (returnVal == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        String filename = selectedFile.getAbsolutePath();
                        DataEnvelope.this.setEnvelopeFilename(filename);
                        DataEnvelope.this.doSave();
                        DataEnvelope.this.theSuite.showInformationDialog(DataEnvelope.this.thePanel, "Envelope is successfully saved.");
                    }
                }
            });
        }
        return this.btnSaveToFile;
    }

    protected void setEnvelopeFilename(String filename) {
        this.envelopeFilename = filename;
        this.txtFromFile.setText(filename);
        System.out.println("setEnvelopeFilename : " + filename);
    }

    protected void doSave() {
        try {
            System.out.println("Save envelope to " + this.envelopeFilename);
            this.manager.exportEnvelope(this.envelopeFilename);
        }
        catch (SecurePackageInvalidDataException e) {
            this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
            e.printStackTrace();
        }
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton("Help");
            this.btnHelp.setBounds(360, 460, 120, 30);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: dataenvelope.html");
                    DataEnvelope.this.theSuite.showHelp("Help", "dataenvelope.html");
                }
            });
        }
        return this.btnHelp;
    }

    private ButtonGroup getGrpRadioButton() {
        if (this.grpRadioButton == null) {
            this.grpRadioButton = new ButtonGroup();
            this.grpRadioButton.add(this.getRadFromFile());
            this.grpRadioButton.add(this.getRadFromRawData());
        }
        return this.grpRadioButton;
    }

    private JRadioButton getRadFromFile() {
        if (this.radFromFile == null) {
            this.radFromFile = new JRadioButton("From file: ");
            this.radFromFile.setBounds(20, 20, 150, 20);
        }
        return this.radFromFile;
    }

    private JTextField getTxtFromFile() {
        if (this.txtFromFile == null) {
            this.txtFromFile = new JTextField();
            this.txtFromFile.setBounds(180, 20, 200, 20);
        }
        return this.txtFromFile;
    }

    private JButton getBtnBrowse() {
        if (this.btnBrowse == null) {
            this.btnBrowse = new JButton("Browse");
            this.btnBrowse.setBounds(400, 20, 120, 20);
            this.btnBrowse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JFileChooser fileChooser = DataEnvelope.this.theSuite.getFileChosser();
                    fileChooser.resetChoosableFileFilters();
                    int returnVal = fileChooser.showOpenDialog(DataEnvelope.this.theSuite);
                    if (returnVal == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        String filename = selectedFile.getAbsolutePath();
                        DataEnvelope.this.setEnvelopeFilename(filename);
                        DataEnvelope.this.setSourceFromFile(true);
                    }
                }
            });
        }
        return this.btnBrowse;
    }

    private JRadioButton getRadFromRawData() {
        if (this.radFromRawData == null) {
            this.radFromRawData = new JRadioButton("From Raw Data: ");
            this.radFromRawData.setBounds(20, 50, 150, 20);
        }
        return this.radFromRawData;
    }

    private JTextArea getTxtFromRawData() {
        if (this.txtFromRawData == null) {
            this.txtFromRawData = new JTextArea();
            this.txtFromRawData.setBorder(new LineBorder(new Color(0, 0, 0)));
        }
        return this.txtFromRawData;
    }

    private JLabel getLblContentType() {
        if (this.lblContentType == null) {
            this.lblContentType = new JLabel("Content type: ");
            this.lblContentType.setBounds(40, 250, 100, 20);
        }
        return this.lblContentType;
    }

    private JLabel getDatContentType() {
        if (this.datContentType == null) {
            this.datContentType = new JLabel("Data");
            this.datContentType.setBounds(150, 250, 150, 20);
        }
        return this.datContentType;
    }

    public void setFromFilename(String filename) {
        this.txtFromFile.setText(filename);
    }

    public void setRaw(String data) {
        this.txtFromRawData.setText(data);
    }

    public void doEnvelope() throws Exception {
        String fromFilename = this.txtFromFile.getText();
        Enumeration enumeration = this.lstSelectedRecipientData.elements();
        CertProfile[] certProfileList = new CertProfile[this.lstSelectedRecipientData.size()];
        int i = 0;
        while (enumeration.hasMoreElements()) {
            CertProfileItem item = (CertProfileItem)((Object)enumeration.nextElement());
            certProfileList[i] = item.getCertProfile();
            ++i;
        }
        System.out.println("Enveloping " + fromFilename);
        System.out.println("Number of certs : " + certProfileList.length);
        if (this.radFromFile.isSelected()) {
            System.out.println("fromFilename : " + fromFilename);
            System.out.println("certProfileList : " + certProfileList);
            this.manager.envelopeData(fromFilename, certProfileList);
        } else if (this.radFromRawData.isSelected()) {
            String rawText = this.txtFromRawData.getText();
            byte[] rawData = rawText.getBytes();
            this.manager.envelopeData(rawData, certProfileList);
        }
    }

    public void selectCurrentRecipient() {
        CertProfileItem certProfileItem = (CertProfileItem)((Object)this.lstRecipient.getSelectedValue());
        if (certProfileItem == null) {
            return;
        }
        this.lstRecipientData.removeElement((Object)certProfileItem);
        this.lstSelectedRecipientData.addElement(certProfileItem);
    }

    public void unselectCurrentRecipient() {
        CertProfileItem certProfileItem = (CertProfileItem)((Object)this.lstSelectedRecipient.getSelectedValue());
        if (certProfileItem == null) {
            return;
        }
        this.lstSelectedRecipientData.removeElement((Object)certProfileItem);
        this.lstRecipientData.addElement(certProfileItem);
    }

    public void setSourceFromFile(boolean b) {
        this.radFromFile.setSelected(b);
    }

    public void setSourceFromRaw(boolean b) {
        this.radFromRawData.setSelected(b);
    }
}

