/*
 * Decompiled with CFR 0.152.
 */
package ui.packaging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import management.SecurePackageManager;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Packaging.SecurePackageInvalidDataException;
import th.co.oga.security.pki.Packaging.SecurePackageSigningFailException;
import ui.TCDSecureSuite;

public class DataSigning
extends JPanel {
    private static final long serialVersionUID = 2228343889871210719L;
    private JLabel lblTitle = null;
    private JPanel pnlSource = null;
    private JLabel lblOutputToFile = null;
    private JTextField txtOutputToFile = null;
    private JButton btnOutputToFileBrowse = null;
    private JButton btnSign = null;
    private JButton btnHelp = null;
    private ButtonGroup grpRadioButton = null;
    private JRadioButton radFromFile = null;
    private JRadioButton radFromRawData = null;
    private JTextField txtFromFile = null;
    private JButton btnBrowseSourceFile = null;
    private JButton btnBrowse = null;
    private JTextArea txtFromRawData = null;
    private TCDSecureSuite theSuite = null;
    private final DataSigning thePanel = this;
    private SecurePackageManager manager = null;

    public DataSigning(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.setName("Data Signing");
        try {
            this.manager = theSuite.getSecurePackageManager();
            this.initialise();
        }
        catch (SecureStoreException e) {
            theSuite.showErrorDialog(this.thePanel, "Unable to get Secure Package Manager\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (AlgorithmSupportException e) {
            theSuite.showErrorDialog(this.thePanel, "Unable to get Secure Package Manager\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (EntryNotFoundException e) {
            theSuite.showErrorDialog(this.thePanel, "Unable to get Secure Package Manager\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void initialise() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getPnlSource(), this.getPnlSource().getName());
        this.add((Component)this.getLblOutputToFile(), this.getLblOutputToFile().getName());
        this.add((Component)this.getCbxOutputToFile(), this.getCbxOutputToFile().getName());
        this.add((Component)this.getBtnOutputToFileBrowse(), this.getBtnOutputToFileBrowse().getName());
        this.add((Component)this.getBtnSign(), this.getBtnSign().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel(" XML Data Signing");
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 760, 30);
        }
        return this.lblTitle;
    }

    private JPanel getPnlSource() {
        if (this.pnlSource == null) {
            this.pnlSource = new JPanel();
            this.pnlSource.setLayout(null);
            this.pnlSource.setBorder(new TitledBorder(new LineBorder(new Color(255, 255, 255)), "  Source:  "));
            this.pnlSource.setBounds(30, 50, 720, 300);
            this.grpRadioButton = this.getGrpRadioButton();
            this.pnlSource.add((Component)this.getRadFromFile(), this.getRadFromFile().getName());
            this.pnlSource.add((Component)this.getTxtFromFile(), this.getTxtFromFile().getName());
            this.pnlSource.add((Component)this.getBtnBrowseSourceFile(), this.getBtnBrowseSourceFile().getName());
            this.pnlSource.add((Component)this.getRadFromRawData(), this.getRadFromRawData().getName());
            JScrollPane scroll = new JScrollPane();
            scroll.getViewport().add(this.getTxtFromRawData());
            scroll.setBounds(180, 50, 400, 150);
            this.pnlSource.add((Component)scroll, this.getTxtFromRawData().getName());
        }
        return this.pnlSource;
    }

    private JLabel getLblOutputToFile() {
        if (this.lblOutputToFile == null) {
            this.lblOutputToFile = new JLabel("Output to file: ");
            this.lblOutputToFile.setBounds(160, 360, 100, 25);
        }
        return this.lblOutputToFile;
    }

    private JTextField getCbxOutputToFile() {
        if (this.txtOutputToFile == null) {
            this.txtOutputToFile = new JTextField();
            this.txtOutputToFile.setBackground(new Color(255, 255, 255));
            this.txtOutputToFile.setBounds(260, 360, 220, 25);
        }
        return this.txtOutputToFile;
    }

    private JButton getBtnOutputToFileBrowse() {
        if (this.btnOutputToFileBrowse == null) {
            this.btnOutputToFileBrowse = new JButton("Browse");
            this.btnOutputToFileBrowse.setBounds(500, 360, 100, 25);
            this.btnOutputToFileBrowse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JFileChooser fileChooser = new JFileChooser(TCDSecureSuite.DEFAULT_DIR);
                    fileChooser.resetChoosableFileFilters();
                    int returnVal = fileChooser.showSaveDialog(DataSigning.this.theSuite);
                    if (returnVal == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        String filename = selectedFile.getAbsolutePath();
                        DataSigning.this.setOutputFile(filename);
                    }
                }
            });
        }
        return this.btnOutputToFileBrowse;
    }

    private JButton getBtnSign() {
        if (this.btnSign == null) {
            this.btnSign = new JButton("Sign");
            this.btnSign.setBounds(260, 460, 120, 30);
            this.btnSign.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        String sourceFilename = DataSigning.this.txtFromFile.getText();
                        File file = new File(sourceFilename);
                        if (!DataSigning.this.radFromFile.isSelected() && !DataSigning.this.radFromRawData.isSelected()) {
                            DataSigning.this.theSuite.showWarningDialog(DataSigning.this.thePanel, "Please make a choise of source.");
                            return;
                        }
                        if (DataSigning.this.radFromFile.isSelected() && sourceFilename.trim().length() == 0) {
                            DataSigning.this.theSuite.showWarningDialog(DataSigning.this.thePanel, "The source filename is empty.");
                            return;
                        }
                        if (DataSigning.this.radFromFile.isSelected() && !file.exists()) {
                            DataSigning.this.theSuite.showWarningDialog(DataSigning.this.thePanel, "The source file [" + sourceFilename + "] does not exist");
                            return;
                        }
                        if (DataSigning.this.txtOutputToFile.getText().trim().length() == 0) {
                            DataSigning.this.theSuite.showWarningDialog(DataSigning.this.thePanel, "Please specify an output file");
                            return;
                        }
                        DataSigning.this.doSign();
                        DataSigning.this.theSuite.showInformationDialog(DataSigning.this.thePanel, "Data has been signed.");
                        DataSigning.this.btnSign.setEnabled(false);
                    }
                    catch (SecureStoreException e) {
                        DataSigning.this.theSuite.showErrorDialog(DataSigning.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (SecureStoreFindingFailException e) {
                        DataSigning.this.theSuite.showErrorDialog(DataSigning.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (SecurePackageInvalidDataException e) {
                        DataSigning.this.theSuite.showErrorDialog(DataSigning.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        DataSigning.this.theSuite.showErrorDialog(DataSigning.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (AlgorithmSupportException e) {
                        DataSigning.this.theSuite.showErrorDialog(DataSigning.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (SecurePackageSigningFailException e) {
                        DataSigning.this.theSuite.showErrorDialog(DataSigning.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        DataSigning.this.theSuite.showErrorDialog(DataSigning.this.thePanel, "General exception in operation\n" + e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btnSign;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton("Help");
            this.btnHelp.setBounds(400, 460, 120, 30);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: datasigning.html");
                    DataSigning.this.theSuite.showHelp("Help", "datasigning.html");
                }
            });
        }
        return this.btnHelp;
    }

    private ButtonGroup getGrpRadioButton() {
        if (this.grpRadioButton == null) {
            this.grpRadioButton = new ButtonGroup();
            this.grpRadioButton.add(this.getRadFromFile());
            this.grpRadioButton.add(this.getRadFromRawData());
        }
        return this.grpRadioButton;
    }

    private JRadioButton getRadFromFile() {
        if (this.radFromFile == null) {
            this.radFromFile = new JRadioButton("From file: ");
            this.radFromFile.setBounds(20, 20, 150, 20);
        }
        return this.radFromFile;
    }

    private JTextField getTxtFromFile() {
        if (this.txtFromFile == null) {
            this.txtFromFile = new JTextField();
            this.txtFromFile.setBounds(180, 20, 250, 20);
        }
        return this.txtFromFile;
    }

    private JButton getBtnBrowseSourceFile() {
        if (this.btnBrowseSourceFile == null) {
            this.btnBrowseSourceFile = new JButton("Browse");
            this.btnBrowseSourceFile.setBounds(500, 20, 120, 20);
            this.btnBrowseSourceFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JFileChooser fileChooser = DataSigning.this.theSuite.getFileChosser();
                    fileChooser.resetChoosableFileFilters();
                    if (fileChooser.showOpenDialog(DataSigning.this.theSuite) == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        String filename = selectedFile.getAbsolutePath();
                        DataSigning.this.setSourceFilename(filename);
                        DataSigning.this.radFromFile.setSelected(true);
                        DataSigning.this.setOutputFile(String.valueOf(filename) + ".sign");
                        DataSigning.this.btnSign.setEnabled(true);
                    }
                }
            });
        }
        return this.btnBrowseSourceFile;
    }

    private JRadioButton getRadFromRawData() {
        if (this.radFromRawData == null) {
            this.radFromRawData = new JRadioButton("From Raw Data: ");
            this.radFromRawData.setBounds(20, 50, 150, 20);
        }
        return this.radFromRawData;
    }

    private JTextArea getTxtFromRawData() {
        if (this.txtFromRawData == null) {
            this.txtFromRawData = new JTextArea();
            this.txtFromRawData.setBorder(new LineBorder(new Color(0, 0, 0)));
        }
        return this.txtFromRawData;
    }

    public void setRaw(String data) {
        this.txtFromRawData.setText(data);
    }

    public void setSourceFilename(String filename) {
        this.txtFromFile.setText(filename);
    }

    public void setOutputFile(String filename) {
        this.txtOutputToFile.setText(filename);
    }

    public void doSign() throws SecureStoreException, SecureStoreFindingFailException, SecurePackageInvalidDataException, IOException, AlgorithmSupportException, SecurePackageSigningFailException {
        String fromFilename = this.txtFromFile.getText();
        String outputFilename = this.txtOutputToFile.getText();
        if (this.radFromFile.isSelected()) {
            this.manager.signPrimary(fromFilename, outputFilename);
        } else if (this.radFromRawData.isSelected()) {
            String rawText = this.txtFromRawData.getText();
            byte[] rawData = rawText.getBytes();
            this.manager.signPrimary(rawData, outputFilename);
        }
    }

    public void setSignFromRaw(boolean b) {
        this.radFromRawData.setSelected(b);
    }

    public void setSignFromFile(boolean b) {
        this.radFromFile.setSelected(b);
    }
}

