/*
 * Decompiled with CFR 0.152.
 */
package ui.packaging;

import SecurePackaging.P7SecurePackager;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.SMIME.SMIMEPackager;
import th.co.oga.security.pki.Transport.EmailAuthenticator;
import ui.TCDSecureSuite;

public class MailForm
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 2681091887951805351L;
    private TCDSecureSuite theSuite = null;
    private P7SecurePackager packager;
    private SMIMEPackager sPackager;
    private RawSignedData signedData = null;
    private JTextField txtSmtp = new InputField();
    private JTextField txtUser = new InputField();
    private JPasswordField txtPassword = new PasswordField();
    private JTextField txtFrom = new InputField();
    private JTextField txtTo = new InputField();
    private JTextField txtSubject = new InputField();
    private List reqFields = new ArrayList();
    private JButton btnSend;

    public MailForm(Room room) throws SecureStoreException, AlgorithmSupportException, EntryNotFoundException {
        this.reqFields.add(this.txtSmtp);
        this.reqFields.add(this.txtFrom);
        this.reqFields.add(this.txtTo);
        this.reqFields.add(this.txtSubject);
        this.btnSend = new JButton("Send");
        this.packager = new P7SecurePackager(room);
        this.sPackager = new SMIMEPackager(room);
        this.setLocationRelativeTo(null);
        this.setTitle("SendMail");
        this.setSize(550, 320);
        Container pane = this.getContentPane();
        pane.setLayout(null);
        JLabel lblSmtp = new JLabel("SMTP Server :", 11);
        lblSmtp.setBounds(20, 10, 120, 20);
        this.txtSmtp.setBounds(145, 10, 200, 20);
        pane.add(lblSmtp);
        pane.add(this.txtSmtp);
        CaptionLabel lblAlertSmtp = new CaptionLabel("Fully DNS name or IP Address, e.g. mail.acme.com");
        lblAlertSmtp.setBounds(145, 30, 300, 20);
        pane.add(lblAlertSmtp);
        JLabel lblUser = new JLabel("SMTP User :", 11);
        lblUser.setBounds(20, 60, 120, 20);
        this.txtUser.setBounds(145, 60, 100, 20);
        pane.add(lblUser);
        pane.add(this.txtUser);
        JLabel lblPassword = new JLabel("Password :", 11);
        lblPassword.setBounds(20, 80, 120, 20);
        this.txtPassword.setBounds(145, 80, 100, 20);
        pane.add(lblPassword);
        pane.add(this.txtPassword);
        JLabel lblSubject = new JLabel("Subject :", 11);
        lblSubject.setBounds(20, 110, 120, 20);
        this.txtSubject.setBounds(145, 110, 300, 20);
        pane.add(lblSubject);
        pane.add(this.txtSubject);
        JLabel lblForm = new JLabel("Form :", 11);
        lblForm.setBounds(20, 140, 120, 20);
        this.txtFrom.setBounds(145, 140, 300, 20);
        pane.add(lblForm);
        pane.add(this.txtFrom);
        CaptionLabel lblAlertForm = new CaptionLabel("Email address e.g. alice@acme.com");
        lblAlertForm.setBounds(145, 160, 300, 20);
        pane.add(lblAlertForm);
        JLabel lblTo = new JLabel("To :", 11);
        lblTo.setBounds(20, 180, 120, 20);
        this.txtTo.setBounds(145, 180, 300, 20);
        pane.add(lblTo);
        pane.add(this.txtTo);
        CaptionLabel lblAlertTo = new CaptionLabel("Email address e.g. bob@acme.com");
        lblAlertTo.setBounds(145, 200, 300, 20);
        pane.add(lblAlertTo);
        this.btnSend.setBounds(180, 230, 85, 25);
        this.btnSend.setActionCommand("Send");
        this.btnSend.addActionListener(this);
        pane.add(this.btnSend);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setActionCommand("Cancel");
        btnCancel.addActionListener(this);
        btnCancel.setBounds(280, 230, 85, 25);
        pane.add(btnCancel);
        this.updateButtonState();
        this.deactivate();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equalsIgnoreCase("Send")) {
            try {
                Properties p = new Properties();
                p.put("mail.smtp.host", this.txtSmtp);
                Session ses = null;
                if (this.txtUser.getText().trim().length() > 0 && this.txtPassword.getText().trim().length() > 0) {
                    EmailAuthenticator email = new EmailAuthenticator();
                    PasswordAuthentication authen = new PasswordAuthentication(this.txtUser.getText().trim(), new String(this.txtPassword.getPassword()));
                    email.setPasswordAuthentication(authen);
                    ses = Session.getInstance((Properties)p, (Authenticator)email);
                } else {
                    ses = Session.getInstance((Properties)p, null);
                }
                MimeMessage msg = new MimeMessage(ses);
                msg.setFrom((Address)new InternetAddress(this.txtFrom.getText().trim()));
                msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.txtTo.getText().trim()));
                msg.setSubject(this.txtSubject.getText().trim());
                this.sPackager.attachP7MData((Message)msg, SMIMEPackager.P7M_SIGNING_FORMAT, this.packager.exportSignedData(this.signedData));
                Transport.send((Message)msg);
                this.deactivate();
            }
            catch (Exception ex) {
                this.theSuite.showErrorDialog(this.theSuite, ex.getMessage());
            }
        } else if (cmd.equalsIgnoreCase("Cancel")) {
            this.deactivate();
        }
    }

    void updateButtonState() {
        boolean active = true;
        int i = 0;
        while (i < this.reqFields.size()) {
            if (((JTextField)this.reqFields.get(i)).getText().trim().length() == 0) {
                active = false;
                break;
            }
            ++i;
        }
        if (active && this.txtUser.getText().trim().length() > 0 && this.txtPassword.getPassword().length == 0) {
            active = false;
        }
        this.btnSend.setEnabled(active);
    }

    public void active(RawSignedData signedData) {
        this.btnSend.setEnabled(false);
        this.signedData = signedData;
        this.txtPassword.setText("");
        this.setVisible(true);
    }

    public void deactivate() {
        this.setVisible(false);
    }

    class CaptionLabel
    extends JLabel {
        CaptionLabel(String text) {
            super(text);
            this.setFont(new Font("Tahoma", 2, 10));
        }
    }

    class InputField
    extends JTextField {
        InputField() {
            this.getDocument().addDocumentListener(new RequiredFieldHandler());
        }
    }

    class PasswordField
    extends JPasswordField {
        PasswordField() {
            this.getDocument().addDocumentListener(new RequiredFieldHandler());
        }
    }

    class RequiredFieldHandler
    implements DocumentListener {
        RequiredFieldHandler() {
        }

        public void changedUpdate(DocumentEvent e) {
            MailForm.this.updateButtonState();
        }

        public void insertUpdate(DocumentEvent e) {
            MailForm.this.updateButtonState();
        }

        public void removeUpdate(DocumentEvent e) {
            MailForm.this.updateButtonState();
        }
    }
}

