/*
 * Decompiled with CFR 0.152.
 */
package ui.packaging;

import SecurePackaging.P7SecurePackager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.utils.CharsetComboBox;
import ui.TCDSecureSuite;

public class OpenEnvelope
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -7988695761000296621L;
    private JTextField txtEnvelopedFile = new JTextField();
    private JButton btnEnvelopedFileBrowse = new JButton("Browse");
    private JButton btnOpen = new JButton("Open");
    private JButton btnExportToFile = new JButton("Export To File");
    private JTextArea txtContent = new JTextArea();
    private JLabel datContentType = new JLabel("Data");
    private CharsetComboBox charsetList = new CharsetComboBox();
    private TCDSecureSuite theSuite = null;
    private P7SecurePackager packager;
    private RawEnvelopedData envData;
    private ByteArrayOutputStream buff = new ByteArrayOutputStream();

    public OpenEnvelope(TCDSecureSuite theSuite) {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        JLabel lblTitle = new JLabel(" XML Open Data Envelope");
        lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
        lblTitle.setBounds(10, 10, 760, 30);
        this.add(lblTitle);
        JLabel lblEnvelopedFile = new JLabel("Enveloped File: ");
        lblEnvelopedFile.setBounds(20, 60, 120, 20);
        this.add(lblEnvelopedFile);
        this.txtEnvelopedFile.setBounds(140, 60, 250, 20);
        this.txtEnvelopedFile.getDocument().addDocumentListener(new DocumentAction());
        this.add(this.txtEnvelopedFile);
        this.btnEnvelopedFileBrowse.setBounds(410, 60, 100, 20);
        this.btnEnvelopedFileBrowse.addActionListener(this);
        this.add(this.btnEnvelopedFileBrowse);
        this.btnOpen.setBounds(520, 60, 100, 20);
        this.btnOpen.addActionListener(this);
        this.add(this.btnOpen);
        JPanel pnlContent = new JPanel();
        pnlContent.setLayout(null);
        pnlContent.setBorder(new TitledBorder(new LineBorder(new Color(255, 255, 255)), "  Content:  "));
        pnlContent.setBounds(30, 100, 720, 300);
        JLabel lblData = new JLabel("Character set: ");
        lblData.setBounds(40, 20, 120, 20);
        pnlContent.add(lblData);
        this.charsetList.setBounds(160, 20, 160, 20);
        this.charsetList.setActionCommand("Refresh");
        this.charsetList.addActionListener((ActionListener)this);
        pnlContent.add((Component)this.charsetList);
        this.txtContent.setBorder(new LineBorder(new Color(0, 0, 0)));
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.txtContent);
        scroll.setBounds(30, 40, 660, 200);
        pnlContent.add(scroll);
        JLabel lblContentType = new JLabel("Content type: ");
        lblContentType.setBounds(40, 260, 100, 20);
        pnlContent.add(lblContentType);
        this.datContentType.setBounds(150, 260, 150, 20);
        pnlContent.add(this.datContentType);
        this.add(pnlContent);
        this.btnExportToFile.setBounds(260, 460, 120, 30);
        this.btnExportToFile.setActionCommand("Export");
        this.btnExportToFile.addActionListener(this);
        this.add(this.btnExportToFile);
        JButton btnHelp = new JButton("Help");
        btnHelp.setBounds(400, 460, 120, 30);
        btnHelp.addActionListener(this);
        this.add(btnHelp);
        try {
            this.theSuite = theSuite;
            this.setName("Open Envelope");
            this.packager = new P7SecurePackager(theSuite.getRoom());
        }
        catch (Exception e) {
            theSuite.showErrorDialog(this, "Unable to get Secure Package Manager\n" + e.getMessage());
        }
        this.buttonStateUpdate();
    }

    public void buttonStateUpdate() {
        this.btnOpen.setEnabled(this.txtEnvelopedFile.getText().trim().length() > 0);
        if (this.envData != null) {
            this.btnExportToFile.setEnabled(true);
        } else {
            this.btnExportToFile.setEnabled(false);
        }
    }

    private void applyEnvData() throws UnsupportedEncodingException {
        this.txtContent.setText(new String(this.buff.toByteArray(), this.charsetList.getSelectedCharset().name()));
    }

    public void actionPerformed(ActionEvent event) {
        File selectedFile;
        int returnVal;
        JFileChooser fileChooser;
        String cmd = event.getActionCommand();
        if (cmd.equalsIgnoreCase("Browse")) {
            fileChooser = this.theSuite.getFileChosser();
            fileChooser.resetChoosableFileFilters();
            returnVal = fileChooser.showOpenDialog(this.theSuite);
            if (returnVal == 0) {
                selectedFile = fileChooser.getSelectedFile();
                this.txtEnvelopedFile.setText(selectedFile.getAbsolutePath());
            }
        }
        if (cmd.equalsIgnoreCase("Open")) {
            try {
                File file = new File(this.txtEnvelopedFile.getText().trim());
                if (file.isFile() && file.exists() && file.canRead()) {
                    this.envData = this.packager.importEnvelopedData(new FileInputStream(file));
                    this.buff.write(this.packager.openEnvelopedData(this.packager.importEnvelopedData(new FileInputStream(file))));
                    this.applyEnvData();
                    this.buttonStateUpdate();
                } else {
                    this.theSuite.showWarningDialog(this, "File access fail.");
                }
            }
            catch (Exception e) {
                this.theSuite.showErrorDialog(this, e.getMessage());
            }
        }
        if (cmd.equalsIgnoreCase("Refresh")) {
            try {
                this.applyEnvData();
            }
            catch (Exception e) {
                this.theSuite.showErrorDialog(this, e.getMessage());
            }
        }
        if (cmd.equalsIgnoreCase("Export") && (returnVal = (fileChooser = this.theSuite.getFileChosser()).showSaveDialog(this.theSuite)) == 0) {
            selectedFile = fileChooser.getSelectedFile();
            try {
                System.out.println("Export to file");
                System.out.println("Save to file");
                System.out.println("Start --> " + Utils.getWacthTime());
                byte[] contentData = this.packager.openEnvelopedData(this.envData);
                FileOutputStream tarOut = new FileOutputStream(selectedFile);
                this.packager.getData(contentData, tarOut);
                tarOut.close();
                System.out.println("Finished --> " + Utils.getWacthTime());
                this.theSuite.showInformationDialog(this, "Enveloped content has been exported.");
            }
            catch (Exception e) {
                this.theSuite.showErrorDialog(this, e.getMessage());
            }
        }
        if (cmd.equalsIgnoreCase("Help")) {
            this.theSuite.showHelp("Help", "openenvelope.html");
        }
    }

    class DocumentAction
    implements DocumentListener {
        DocumentAction() {
        }

        public void changedUpdate(DocumentEvent arg0) {
            OpenEnvelope.this.buttonStateUpdate();
        }

        public void insertUpdate(DocumentEvent arg0) {
            OpenEnvelope.this.buttonStateUpdate();
        }

        public void removeUpdate(DocumentEvent arg0) {
            OpenEnvelope.this.buttonStateUpdate();
        }
    }
}

