/*
 * Decompiled with CFR 0.152.
 */
package ui.packaging;

import SecurePackaging.P7SecurePackager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sun.misc.BASE64Encoder;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.RawSignerInfo;
import th.co.oga.security.pki.Packaging.SecurePackageInvalidDataException;
import th.co.oga.security.utils.CharsetComboBox;
import ui.TCDSecureSuite;
import ui.packaging.CertProfileItem;
import ui.packaging.MailForm;

public class SignedDataViewer
extends JPanel {
    private static final long serialVersionUID = -7595608889396555710L;
    private JTextField txtSignedFile = new JTextField();
    private JButton btnBrowse = new JButton("Browse");
    private JButton btnLoad = new JButton("Load");
    private JButton btnMail = new JButton("SendMail");
    private JButton btnSign = new JButton("Sign");
    private JButton btnExport = new JButton("ExportData");
    private JButton btnSaveFile = new JButton("FileSave");
    private JTextArea txtContent = new JTextArea();
    private SignerList signerList = new SignerList();
    private CharsetComboBox charsetList = new CharsetComboBox();
    private JButton btnVerify = new JButton("Verify");
    private JTextArea txtSignature = new JTextArea();
    private JButton btnSaveSignature = new JButton("Save");
    JFileChooser fileChooser;
    private TCDSecureSuite theSuite = null;
    private RawSignedData signedData;
    private P7SecurePackager packager;
    private MailForm sendmail;

    public SignedDataViewer(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        JLabel lblTitle = new JLabel(" XML Signed Data Viewer");
        lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
        lblTitle.setBounds(10, 10, 760, 30);
        this.add(lblTitle);
        JLabel lblSignedFile = new JLabel("Signed File: ");
        lblSignedFile.setBounds(20, 60, 120, 20);
        this.add(lblSignedFile);
        this.txtSignedFile.setBounds(140, 60, 250, 20);
        this.txtSignedFile.getDocument().addDocumentListener(new DocumentAction());
        this.add(this.txtSignedFile);
        this.btnBrowse.setBounds(410, 60, 100, 20);
        this.btnBrowse.addActionListener(new ButtonAction());
        this.add(this.btnBrowse);
        this.btnLoad.setBounds(520, 60, 100, 20);
        this.btnLoad.addActionListener(new ButtonAction());
        this.add(this.btnLoad);
        this.add(new SignedDataPanel());
        this.btnSign.setBounds(60, 460, 120, 30);
        this.btnSign.addActionListener(new ButtonAction());
        this.add(this.btnSign);
        this.btnMail.setBounds(190, 460, 120, 30);
        this.btnMail.addActionListener(new ButtonAction());
        this.add(this.btnMail);
        this.btnExport.setBounds(320, 460, 120, 30);
        this.btnExport.addActionListener(new ButtonAction());
        this.btnExport.setActionCommand("Export");
        this.add(this.btnExport);
        this.btnSaveFile.setBounds(450, 460, 120, 30);
        this.btnSaveFile.addActionListener(new ButtonAction());
        this.add(this.btnSaveFile);
        JButton btnHelp = new JButton("Help");
        btnHelp.setBounds(580, 460, 120, 30);
        btnHelp.addActionListener(new ButtonAction());
        this.add(btnHelp);
        this.fileChooser = theSuite.getFileChosser();
        try {
            this.packager = new P7SecurePackager(theSuite.getRoom());
        }
        catch (Exception e) {
            theSuite.showErrorDialog(this, "Cannot instantiate PKCS7 secure packager");
        }
        try {
            this.sendmail = new MailForm(theSuite.getRoom());
        }
        catch (Exception e) {
            theSuite.showErrorDialog(this, "Cannot instantiate Send mail form");
        }
    }

    public void setSignedData(RawSignedData signedData) throws CertificateException, UnsupportedEncodingException {
        this.signedData = signedData;
        this.applyData();
    }

    private void applyData() throws CertificateException, UnsupportedEncodingException {
        this.signerList.setData(this.signedData);
        this.refreshContent();
        this.buttonStateUpdate();
    }

    private void refreshContent() throws UnsupportedEncodingException {
        try {
            this.txtContent.setText(new String(this.packager.exportSignedData(this.signedData), this.charsetList.getSelectedCharset().name()));
        }
        catch (SecurePackageInvalidDataException e) {
            throw new IllegalArgumentException("Signed data have some incorect data ...");
        }
    }

    public void buttonStateUpdate() {
        this.btnLoad.setEnabled(this.txtSignedFile.getText().trim().length() > 0);
        if (this.signedData != null) {
            this.btnExport.setEnabled(true);
            this.btnMail.setEnabled(true);
            this.btnSign.setEnabled(true);
            this.btnSaveFile.setEnabled(true);
        } else {
            this.btnExport.setEnabled(false);
            this.btnMail.setEnabled(false);
            this.btnSign.setEnabled(false);
            this.btnSaveFile.setEnabled(false);
        }
        if (this.signerList.getSelectedSigner() != null) {
            this.btnVerify.setEnabled(true);
            this.btnSaveSignature.setEnabled(true);
        } else {
            this.btnVerify.setEnabled(false);
            this.btnSaveSignature.setEnabled(false);
        }
    }

    class SignedDataPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        SignedDataPanel() {
            this.setLayout(null);
            this.setBorder(new TitledBorder(new LineBorder(new Color(255, 255, 255)), "  Signed Data:  "));
            this.setBounds(30, 100, 720, 330);
            SignedDataViewer.this.txtContent.setBorder(new LineBorder(new Color(0, 0, 0)));
            JScrollPane scroll2 = new JScrollPane();
            scroll2.getViewport().add(SignedDataViewer.this.txtContent);
            scroll2.setBounds(30, 40, 660, 120);
            this.add(scroll2);
            JLabel lblSignatures = new JLabel("Signer : ");
            lblSignatures.setBounds(40, 160, 100, 20);
            this.add(lblSignatures);
            JScrollPane scroll1 = new JScrollPane();
            scroll1.getViewport().add(SignedDataViewer.this.signerList);
            scroll1.setBounds(30, 180, 320, 125);
            this.add(scroll1);
            SignedDataViewer.this.btnVerify.setBounds(600, 290, 80, 20);
            SignedDataViewer.this.btnVerify.addActionListener(new ButtonAction());
            this.add(SignedDataViewer.this.btnVerify);
            JLabel lblData = new JLabel("Character set: ");
            lblData.setBounds(40, 20, 120, 20);
            this.add(lblData);
            SignedDataViewer.this.charsetList.setBounds(160, 20, 160, 20);
            SignedDataViewer.this.charsetList.setActionCommand("Refresh");
            SignedDataViewer.this.charsetList.addActionListener((ActionListener)new ButtonAction());
            this.add((Component)SignedDataViewer.this.charsetList);
            JLabel lblSigner = new JLabel("Signatures : ");
            lblSigner.setBounds(360, 160, 100, 20);
            this.add(lblSigner);
            SignedDataViewer.this.txtSignature.setBorder(new LineBorder(new Color(0, 0, 0)));
            JScrollPane scroll3 = new JScrollPane();
            scroll3.getViewport().add(SignedDataViewer.this.txtSignature);
            scroll3.setBounds(360, 180, 330, 100);
            this.add(scroll3);
            SignedDataViewer.this.btnSaveSignature.setBounds(500, 290, 80, 20);
            SignedDataViewer.this.btnSaveSignature.addActionListener(new ButtonAction());
            this.add(SignedDataViewer.this.btnSaveSignature);
            SignedDataViewer.this.buttonStateUpdate();
        }
    }

    class DocumentAction
    implements DocumentListener {
        DocumentAction() {
        }

        public void changedUpdate(DocumentEvent arg0) {
            SignedDataViewer.this.buttonStateUpdate();
        }

        public void insertUpdate(DocumentEvent arg0) {
            SignedDataViewer.this.buttonStateUpdate();
        }

        public void removeUpdate(DocumentEvent arg0) {
            SignedDataViewer.this.buttonStateUpdate();
        }
    }

    class SignerList
    extends JList {
        private static final long serialVersionUID = 4046060110972320560L;
        private RawSignerInfo signer;

        SignerList() {
            super(new DefaultListModel());
            this.setBackground(Color.white);
            this.addListSelectionListener(new SelectAction());
        }

        public RawSignerInfo getSelectedSigner() {
            return this.signer;
        }

        public void setData(RawSignedData signedData) throws CertificateException {
            DefaultListModel lm = (DefaultListModel)this.getModel();
            Iterator iterator = signedData.getSigners();
            lm.clear();
            while (iterator.hasNext()) {
                RawSignerInfo rawSignerInfo = (RawSignerInfo)iterator.next();
                CertProfileItem certProfileItem = new CertProfileItem(rawSignerInfo.getSignerCertificate());
                lm.addElement(certProfileItem);
            }
            this.setSelectedIndex(0);
        }

        class SelectAction
        implements ListSelectionListener {
            SelectAction() {
            }

            public void valueChanged(ListSelectionEvent e) {
                JList list = (JList)e.getSource();
                int cnt = 0;
                if (SignedDataViewer.this.signedData != null) {
                    Iterator signers = SignedDataViewer.this.signedData.getSigners();
                    while (signers.hasNext()) {
                        Object obj = signers.next();
                        if (cnt == list.getSelectedIndex()) {
                            SignerList.this.signer = (RawSignerInfo)obj;
                            String outSigner = "";
                            try {
                                outSigner = String.valueOf(outSigner) + "Cert SN: " + SignerList.this.signer.getSignerCertificate().getSerialNumber() + "\n";
                                outSigner = String.valueOf(outSigner) + "Issuer: " + SignerList.this.signer.getSignerCertificate().getSubjectDN().getSubject() + "\n";
                                outSigner = String.valueOf(outSigner) + "SigningTime: " + SignerList.this.signer.getSigningTime() + "\n";
                                byte[] signatureData = SignerList.this.signer.getSignature();
                                BASE64Encoder base = new BASE64Encoder();
                                String strSignature = base.encode(signatureData);
                                outSigner = String.valueOf(outSigner) + "Signature Data: " + strSignature;
                            }
                            catch (ASN1Exception e1) {
                                e1.printStackTrace();
                            }
                            SignedDataViewer.this.txtSignature.setText(outSigner);
                        }
                        ++cnt;
                    }
                }
                SignedDataViewer.this.buttonStateUpdate();
            }
        }
    }

    class ButtonAction
    implements ActionListener {
        ButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            block37: {
                RawSignerInfo signer;
                FileOutputStream fos;
                System.out.println("Got button command " + e.getActionCommand());
                if (e.getActionCommand().equalsIgnoreCase("Browse")) {
                    SignedDataViewer.this.fileChooser.resetChoosableFileFilters();
                    if (SignedDataViewer.this.fileChooser.showOpenDialog(SignedDataViewer.this.theSuite) == 0) {
                        SignedDataViewer.this.txtSignedFile.setText(SignedDataViewer.this.fileChooser.getSelectedFile().getPath());
                    }
                }
                if (e.getActionCommand().equalsIgnoreCase("Load")) {
                    try {
                        File file = new File(SignedDataViewer.this.txtSignedFile.getText().trim());
                        if (!file.exists()) {
                            SignedDataViewer.this.theSuite.showWarningDialog(SignedDataViewer.this.theSuite, "The specific signed file does not exist.");
                            return;
                        }
                        FileInputStream fis = new FileInputStream(file);
                        SignedDataViewer.this.setSignedData(SignedDataViewer.this.packager.importSignedData(fis));
                        fis.close();
                    }
                    catch (Exception ex) {
                        SignedDataViewer.this.theSuite.showErrorDialog(SignedDataViewer.this.theSuite, ex.getMessage());
                    }
                }
                if (e.getActionCommand().equalsIgnoreCase("SendMail")) {
                    try {
                        SignedDataViewer.this.sendmail.active(SignedDataViewer.this.signedData);
                    }
                    catch (Exception ex) {
                        SignedDataViewer.this.theSuite.showErrorDialog(SignedDataViewer.this.theSuite, ex.getMessage());
                    }
                }
                if (e.getActionCommand().equalsIgnoreCase("Export")) {
                    SignedDataViewer.this.fileChooser.resetChoosableFileFilters();
                    if (SignedDataViewer.this.fileChooser.showSaveDialog(SignedDataViewer.this.theSuite) == 0) {
                        try {
                            fos = new FileOutputStream(SignedDataViewer.this.fileChooser.getSelectedFile());
                            SignedDataViewer.this.packager.getData(SignedDataViewer.this.signedData, fos);
                            fos.close();
                            SignedDataViewer.this.theSuite.showInformationDialog(SignedDataViewer.this.theSuite, "Data has been exported.");
                        }
                        catch (Exception ex) {
                            SignedDataViewer.this.theSuite.showErrorDialog(SignedDataViewer.this.theSuite, ex.getMessage());
                        }
                    }
                }
                if (e.getActionCommand().equalsIgnoreCase("FileSave")) {
                    SignedDataViewer.this.fileChooser.resetChoosableFileFilters();
                    if (SignedDataViewer.this.fileChooser.showSaveDialog(SignedDataViewer.this.theSuite) == 0) {
                        try {
                            fos = new FileOutputStream(SignedDataViewer.this.fileChooser.getSelectedFile());
                            SignedDataViewer.this.packager.exportSignedData(SignedDataViewer.this.signedData, fos);
                            fos.close();
                        }
                        catch (Exception ex) {
                            SignedDataViewer.this.theSuite.showErrorDialog(SignedDataViewer.this.theSuite, ex.getMessage());
                        }
                    }
                }
                if (e.getActionCommand().equalsIgnoreCase("Help")) {
                    SignedDataViewer.this.theSuite.showHelp("Help", "signeddataviewer.html");
                }
                if (e.getActionCommand().equalsIgnoreCase("Save")) {
                    SignedDataViewer.this.fileChooser.resetChoosableFileFilters();
                    if (SignedDataViewer.this.fileChooser.showSaveDialog(SignedDataViewer.this.theSuite) == 0 && (signer = SignedDataViewer.this.signerList.getSelectedSigner()) != null) {
                        try {
                            FileOutputStream fout = new FileOutputStream(SignedDataViewer.this.fileChooser.getSelectedFile());
                            fout.write(signer.getSignature());
                            fout.close();
                        }
                        catch (Exception ex) {
                            SignedDataViewer.this.theSuite.showErrorDialog(SignedDataViewer.this.theSuite, "Error while save signature file, " + ex.getMessage());
                        }
                    }
                }
                if (e.getActionCommand().equalsIgnoreCase("Refresh") && SignedDataViewer.this.signedData != null) {
                    try {
                        SignedDataViewer.this.refreshContent();
                    }
                    catch (Exception ex) {
                        SignedDataViewer.this.theSuite.showErrorDialog(SignedDataViewer.this.theSuite, "Error while change character set,\n" + ex.toString());
                    }
                }
                if (e.getActionCommand().equalsIgnoreCase("Verify")) {
                    try {
                        signer = SignedDataViewer.this.signerList.getSelectedSigner();
                        if (signer != null) {
                            SignedDataViewer.this.packager.signerVerify(SignedDataViewer.this.signedData, signer.getSignerCertificate());
                            SignedDataViewer.this.theSuite.showInformationDialog(SignedDataViewer.this.theSuite, "Signature is verified.");
                        } else {
                            SignedDataViewer.this.theSuite.showWarningDialog(SignedDataViewer.this.theSuite, "Please select signature in list.");
                        }
                    }
                    catch (Exception ex) {
                        SignedDataViewer.this.theSuite.showErrorDialog(SignedDataViewer.this.theSuite, "Signature is not verified.\n" + ex.getMessage());
                    }
                }
                if (e.getActionCommand().equalsIgnoreCase("Sign")) {
                    try {
                        CertProfile[] certs = SignedDataViewer.this.theSuite.getRoom().getCertificates();
                        ArrayList<CertProfileItem> arrayList = new ArrayList<CertProfileItem>();
                        int i = 0;
                        while (i < certs.length) {
                            CertProfileItem certItem = new CertProfileItem(certs[i]);
                            arrayList.add(certItem);
                            ++i;
                        }
                        Object[] options = arrayList.toArray();
                        Object cert = JOptionPane.showInputDialog(null, "Choose signer's certificate", "Available Signer Certificate", 1, null, options, options[0]);
                        if (cert == null) break block37;
                        CertProfileItem certProfile = (CertProfileItem)((Object)cert);
                        SignedDataViewer.this.packager.sign(SignedDataViewer.this.signedData, certProfile.getCertProfile());
                        if (SignedDataViewer.this.fileChooser.showSaveDialog(SignedDataViewer.this.theSuite) == 0) {
                            try {
                                FileOutputStream fos2 = new FileOutputStream(SignedDataViewer.this.fileChooser.getSelectedFile());
                                SignedDataViewer.this.packager.exportSignedData(SignedDataViewer.this.signedData, fos2);
                                fos2.close();
                            }
                            catch (Exception ex) {
                                SignedDataViewer.this.theSuite.showErrorDialog(SignedDataViewer.this.theSuite, ex.getMessage());
                            }
                        }
                        SignedDataViewer.this.applyData();
                    }
                    catch (Exception ex) {
                        SignedDataViewer.this.theSuite.showErrorDialog(SignedDataViewer.this.theSuite, ex.getMessage());
                    }
                }
            }
        }
    }
}

