/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Algorithm;

import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Operator.AlgorithmOperator;

public class AlgoUtils
extends AlgorithmOperator {
    private AlgorithmSet digestAlgos;
    private AlgorithmSet signatureAlgos;
    private AlgorithmSet dataEncryptAlgos;
    private AlgorithmSet keyWrapAlgos;
    private AlgorithmSet encryptAlgos;

    public AlgoUtils(AlgorithmSupportTable algoTable) {
        super(algoTable);
        this.digestAlgos = algoTable.getMessageDigestAlgorithm();
        this.signatureAlgos = algoTable.getSignatureAlgorithm();
        this.dataEncryptAlgos = algoTable.getSymetricEncryptionAlgorithm();
        this.keyWrapAlgos = algoTable.getAsymetricEncryptionAlgorithm();
        this.encryptAlgos = algoTable.getEncryptionAlgorithm();
    }

    public AlgorithmProfile getDigestAlgorithmByOID(String oid) throws AlgorithmSupportException {
        return this.digestAlgos.findByOID(oid);
    }

    public AlgorithmProfile getSignatureAlgorithmByOID(String oid) throws AlgorithmSupportException {
        return this.signatureAlgos.findByOID(oid);
    }

    public AlgorithmProfile getDataEncryptionAlgorithmByOID(String oid) throws AlgorithmSupportException {
        return this.dataEncryptAlgos.findByOID(oid);
    }

    public AlgorithmProfile getKeyWrappingAlgorithmByOID(String oid) throws AlgorithmSupportException {
        return this.keyWrapAlgos.findByOID(oid);
    }

    public AlgorithmProfile getDigestAlgorithmByName(String algName) throws AlgorithmSupportException {
        return this.digestAlgos.findByOID(algName);
    }

    public AlgorithmProfile getSignatureAlgorithmByName(String algName) throws AlgorithmSupportException {
        return this.signatureAlgos.findByOID(algName);
    }

    public AlgorithmProfile getDataEncryptionAlgorithmByName(String algName) throws AlgorithmSupportException {
        return this.dataEncryptAlgos.findByOID(algName);
    }

    public AlgorithmProfile getKeyWrappingAlgorithmByName(String algName) throws AlgorithmSupportException {
        return this.keyWrapAlgos.findByOID(algName);
    }
}

