/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Algorithm;

import th.co.oga.security.pki.Algorithm.AlgorithmSPEC;

public class AlgorithmProfile
implements AlgorithmSPEC {
    private String oid;
    private String name;
    private String path;
    private String algoName;
    private String modeName;
    private String paddingName;
    private String keySizeSpec;

    public AlgorithmProfile(String oid, String name) {
        this(oid, name, name);
    }

    public AlgorithmProfile(String oid, String name, String path) {
        this(oid, name, path, null);
    }

    public AlgorithmProfile(String oid, String name, String path, String keySizeSpec) {
        this.oid = oid;
        this.name = name;
        this.path = path;
        this.keySizeSpec = keySizeSpec == null ? this.getKeySizeSpec() : keySizeSpec;
        this.algoName = this.getEncryptionAlgorithmName();
        this.modeName = this.getEncryptionMode();
        this.paddingName = this.getEncryptionPadding();
    }

    protected String getStandardName() {
        if (this.path.indexOf("/") > -1) {
            return this.path.substring(0, this.path.indexOf("/"));
        }
        return this.path;
    }

    public boolean isPBE() {
        return this.name.toUpperCase().indexOf("PBE") > -1;
    }

    public String getMessageDigestAlgorithmName() {
        String algName = null;
        String[] md_names = "SHA1,SHA256,SHA,HMAC_SHAR1,HMAC,MD2,MD4,MD5".split(",");
        int i = 0;
        while (i < md_names.length) {
            if (this.path.toUpperCase().indexOf(md_names[i]) > -1) {
                algName = md_names[i];
                break;
            }
            ++i;
        }
        return algName;
    }

    public String getEncryptionAlgorithmName() {
        String encryptionName = null;
        String[] symetric_names = "AES,DESede,DES,RC2,RC4,RC5,BW".split(",");
        int i = 0;
        while (i < symetric_names.length) {
            if (this.path.indexOf(symetric_names[i]) > -1) {
                encryptionName = symetric_names[i];
                break;
            }
            ++i;
        }
        if (encryptionName == null) {
            String[] asymetric_names = "DSA,RSA,DH".split(",");
            int i2 = 0;
            while (i2 < asymetric_names.length) {
                if (this.path.indexOf(asymetric_names[i2]) > -1) {
                    encryptionName = asymetric_names[i2];
                    break;
                }
                ++i2;
            }
        }
        return encryptionName;
    }

    public String getEncryptionName() {
        String cipherName = this.algoName;
        if (this.modeName != null && this.modeName.length() > 0) {
            cipherName = String.valueOf(cipherName) + "_" + this.modeName;
        }
        return cipherName;
    }

    public String getKeyAlgorithmName() {
        String keyAlgName = null;
        String[] symetric_names = "AES,DESede,DES,RC2,RC4,RC5,BW".split(",");
        int i = 0;
        while (i < symetric_names.length) {
            if (this.path.toUpperCase().indexOf(symetric_names[i].toUpperCase()) > -1) {
                keyAlgName = symetric_names[i];
                break;
            }
            ++i;
        }
        if (keyAlgName == null) {
            String[] asymetric_names = "DSA,RSA,DH".split(",");
            int i2 = 0;
            while (i2 < asymetric_names.length) {
                if (this.path.toUpperCase().indexOf(asymetric_names[i2].toUpperCase()) > -1) {
                    keyAlgName = asymetric_names[i2];
                    break;
                }
                ++i2;
            }
        }
        return keyAlgName;
    }

    public String getAlgorithmName() {
        return this.name;
    }

    public String getAlgorithmType() {
        String stdName = this.getStandardName();
        if ("DSA,RSA,DH".indexOf(stdName) > -1) {
            return "Encryption Algorithm";
        }
        if ("AES,DESede,DES,RC2,RC4,RC5,BW".indexOf(stdName) > -1) {
            return "Encryption Algorithm";
        }
        if ("SHA1PRNG,PKCS11PRNG,BBS".indexOf(stdName) > -1) {
            return "Secure Random Algorithm";
        }
        if ("SHA1,SHA256,SHA,HMAC_SHAR1,HMAC,MD2,MD4,MD5".indexOf(stdName) > -1) {
            return "Message Digest Algorithm";
        }
        return "Other Algorithm";
    }

    public String getName() {
        return this.name;
    }

    public String getOID() {
        return this.oid;
    }

    public String getPath() {
        return this.path;
    }

    public String getTransform() {
        String trns = this.algoName;
        if (this.modeName != null && this.modeName.length() > 0) {
            trns = String.valueOf(trns) + "/" + this.modeName;
        }
        if (this.paddingName != null && this.paddingName.length() > 0) {
            trns = String.valueOf(trns) + "/" + this.paddingName;
        }
        return trns;
    }

    public boolean isInPath(String algos) {
        return this.isInPath(algos.split(":"));
    }

    public boolean isInPath(String[] algos) {
        boolean found = false;
        if (algos.length > 0) {
            found = true;
            int i = 0;
            while (i < algos.length) {
                if (this.path.indexOf(algos[i]) == -1) {
                    found = false;
                }
                ++i;
            }
        }
        return found;
    }

    public String getEncryptionGroup(String stdName) {
        if ("DSA,RSA,DH".indexOf(stdName) > -1) {
            return "ASYMETRIC";
        }
        if ("AES,DESede,DES,RC2,RC4,RC5,BW".indexOf(stdName) > -1) {
            return "SYMETRIC";
        }
        return "Other Algorithm";
    }

    public String getEncryptionType() {
        if (this.path.indexOf("/") > -1) {
            if (this.path.indexOf("PBE") > -1) {
                return "PBE";
            }
            return "FIPS";
        }
        return "BASIC";
    }

    public String getEncryptionMode() {
        String[] elements;
        String algoMode = null;
        String[] modes = "CBC,ECB,OFB,CFB,PCBC".split(",");
        int i = 0;
        while (i < modes.length) {
            if (this.path.indexOf(modes[i]) > -1) {
                algoMode = modes[i];
                break;
            }
            ++i;
        }
        if (algoMode == null && (elements = this.path.split("/")).length > 1) {
            algoMode = elements[1];
        }
        return algoMode;
    }

    public String getEncryptionPadding() {
        String padding = null;
        String[] pads = "NoPadding,PKCS5Padding,OEAPPadding,ISOPadding".split(",");
        int i = 0;
        while (i < pads.length) {
            if (this.path.indexOf(pads[i]) > -1) {
                padding = pads[i];
                break;
            }
            ++i;
        }
        return padding;
    }

    public String getKeySizeSpec() {
        String keyAlgName = this.getKeyAlgorithmName();
        if (keyAlgName != null) {
            String algName = this.getName();
            if (keyAlgName.equalsIgnoreCase("DES")) {
                return "FIX:56";
            }
            if (keyAlgName.equalsIgnoreCase("DESEDE")) {
                return "FIX:168";
            }
            if (keyAlgName.equalsIgnoreCase("AES")) {
                return "STEP:128,192,256";
            }
            if (keyAlgName.equalsIgnoreCase("RC2")) {
                return "BETWEEN:8,1024";
            }
            if (keyAlgName.equalsIgnoreCase("RSA")) {
                return "STEP:1024,2048";
            }
            if (keyAlgName.equalsIgnoreCase("DSA")) {
                return "STEP:1024";
            }
            if (keyAlgName.equalsIgnoreCase("DH")) {
                return "STEP:1024";
            }
        }
        return "NA";
    }

    public String getKeySizeMethod() {
        String[] parts = this.keySizeSpec.split(":");
        String method = null;
        if (parts.length > 0) {
            method = parts[0];
        }
        if (method == null) {
            return "NA";
        }
        return method;
    }

    public String[] getKeySizeValues() {
        String[] parts = this.keySizeSpec.split(":");
        String method = null;
        if (parts.length > 0) {
            method = parts[0];
        }
        if (method == null) {
            method = "NA";
        }
        String[] values = null;
        if (method.equalsIgnoreCase("NA")) {
            values = new String[]{"0"};
        }
        if (method.compareTo("BETWEEN") == 0) {
            values = new String[]{"0", "0"};
            if (parts.length > 1) {
                String[] vls = parts[1].split(",");
                if (vls.length == 1) {
                    values[0] = vls[0];
                } else if (vls.length > 1) {
                    values[0] = vls[0];
                    values[1] = vls[1];
                }
            }
        }
        if (method.compareTo("STEP") == 0 && parts.length > 1) {
            values = parts[1].split(",");
        }
        if (method.compareTo("FIX") == 0 && parts.length > 1) {
            values = new String[]{parts[1]};
        }
        return values;
    }
}

