/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Algorithm;

import java.util.ArrayList;
import java.util.List;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSetName;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.OIDs;

public class AlgorithmSet
extends ArrayList {
    private AlgorithmSetName type;
    private ArrayList idxOID = new ArrayList();
    private ArrayList idxName = new ArrayList();

    public AlgorithmSet(AlgorithmSetName type) {
        this.type = type;
    }

    public void addAlgorithm(AlgorithmProfile algo) {
        this.add(algo);
        this.idxOID.add(algo.getOID());
        this.idxName.add(algo.getName());
    }

    public boolean isSupport(AlgorithmProfile algo) {
        return this.indexOf(algo) > -1;
    }

    public String getName() {
        return this.type.getName();
    }

    public AlgorithmProfile findByOID(String oid) throws AlgorithmSupportException {
        int pointer = -1;
        if (oid.equals(OIDs.NA)) {
            if (this.idxOID.size() > 0) {
                pointer = 0;
            }
        } else {
            pointer = this.idxOID.indexOf(oid);
        }
        if (pointer < 0) {
            throw new AlgorithmSupportException(" Algorithm " + this.type.getName() + " is not support oid:" + oid);
        }
        return (AlgorithmProfile)this.get(pointer);
    }

    public AlgorithmProfile findByOID(long[] oid) throws AlgorithmSupportException {
        return this.findByOID(OIDs.fromLongs(oid));
    }

    public AlgorithmProfile findByName(String name) throws AlgorithmSupportException {
        int pointer = this.idxName.indexOf(name);
        if (pointer < 0) {
            throw new AlgorithmSupportException(" Algorithm " + this.type.getName() + " is not support name:" + name);
        }
        return (AlgorithmProfile)this.get(pointer);
    }

    public AlgorithmProfile find(AlgorithmProfile digestAlgo, AlgorithmProfile encAlgo) throws AlgorithmSupportException {
        int pointer = -1;
        String name1 = digestAlgo.getAlgorithmName().toUpperCase();
        String name2 = encAlgo.getAlgorithmName().toUpperCase();
        int i = 0;
        while (i < this.size()) {
            String alName = ((String)this.idxName.get(i)).toUpperCase();
            if (alName.indexOf(name1) > -1 && alName.indexOf(name2) > -1) {
                pointer = i;
                break;
            }
            ++i;
        }
        if (pointer < 0) {
            throw new AlgorithmSupportException(" Algorithm " + this.type.getName() + " is not support name:" + name1 + " with " + name2);
        }
        return (AlgorithmProfile)this.get(pointer);
    }

    public List findByKeyWord(String keys) throws AlgorithmSupportException {
        ArrayList<AlgorithmProfile> rtn = new ArrayList<AlgorithmProfile>();
        int p = 0;
        while (p < this.idxName.size()) {
            AlgorithmProfile ap = (AlgorithmProfile)this.get(p);
            if (ap.isInPath(keys)) {
                rtn.add(ap);
            }
            ++p;
        }
        if (rtn.size() == 0) {
            throw new AlgorithmSupportException(" No any Algorithm in set: " + this.type.getName() + " sound like keys word " + keys);
        }
        return rtn;
    }
}

