/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Algorithm;

public class AlgorithmSetName {
    public static AlgorithmSetName MESSAGE_DIGEST;
    public static AlgorithmSetName DIGEST_ALGO;
    public static AlgorithmSetName ENCRYPTION_ALGO;
    public static AlgorithmSetName ENCRYPT_SYMETRIC;
    public static AlgorithmSetName DATA_ENCIPHERMENT;
    public static AlgorithmSetName ENCRYPT_ASYMETRIC;
    public static AlgorithmSetName KEY_ENCIPHERMENT;
    public static AlgorithmSetName SECRET_KEY_ALGO;
    public static AlgorithmSetName KEY_WRAP_ALGO;
    public static AlgorithmSetName KEY_GEN_ALGO;
    public static AlgorithmSetName KEY_PAIR_ALGO;
    public static AlgorithmSetName PASSWORD_BASE_ENCRYPTION;
    public static AlgorithmSetName PBE_ALGO;
    public static AlgorithmSetName SIGNATURE_ALGO;
    public static AlgorithmSetName KEY_TYPE;
    public static AlgorithmSetName SECURE_RANDOM;
    public static AlgorithmSetName PRNG;
    private String name;

    static {
        DIGEST_ALGO = MESSAGE_DIGEST = new AlgorithmSetName("MessageDigestAlgorithm");
        ENCRYPTION_ALGO = new AlgorithmSetName("EncryptionAlgorithm");
        DATA_ENCIPHERMENT = ENCRYPT_SYMETRIC = new AlgorithmSetName("SymetricEncryptionAlgorithm");
        KEY_ENCIPHERMENT = ENCRYPT_ASYMETRIC = new AlgorithmSetName("AsymetricEncryptionAlgorithm");
        SECRET_KEY_ALGO = new AlgorithmSetName("SecretKeyAlgorithm");
        KEY_WRAP_ALGO = new AlgorithmSetName("KeyWrapAlgorithm");
        KEY_GEN_ALGO = new AlgorithmSetName("KeyGenAlgorithm");
        KEY_PAIR_ALGO = new AlgorithmSetName("KeyPairAlgorithm");
        PBE_ALGO = PASSWORD_BASE_ENCRYPTION = new AlgorithmSetName("PasswordBaseEncryptionAlgorithm");
        SIGNATURE_ALGO = new AlgorithmSetName("SignatureAlgorithm");
        KEY_TYPE = new AlgorithmSetName("KeyType");
        PRNG = SECURE_RANDOM = new AlgorithmSetName("SecureRandom");
    }

    protected AlgorithmSetName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean is(AlgorithmSetName type) {
        return this.name.equalsIgnoreCase(type.getName());
    }
}

