/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Algorithm;

import java.util.ArrayList;
import java.util.List;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSetName;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;

public class AlgorithmSupportTable {
    private String version = "Algorithm support table";
    protected ArrayList types = new ArrayList();
    protected AlgorithmSet[] set;

    public AlgorithmSupportTable(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public List getTypeList() {
        return this.types;
    }

    public AlgorithmSet getAlgorithmSet(AlgorithmSetName type) throws AlgorithmSupportException {
        if (this.types.indexOf(type) > -1) {
            return this.set[this.types.indexOf(type)];
        }
        throw new AlgorithmSupportException("Algorithm type " + type.getName() + " not found in Algorithm support table .");
    }

    public AlgorithmSet getEncryptionAlgorithm() {
        return this.set[this.types.indexOf(AlgorithmSetName.ENCRYPTION_ALGO)];
    }

    public AlgorithmSet getSymetricEncryptionAlgorithm() {
        return this.set[this.types.indexOf(AlgorithmSetName.ENCRYPT_SYMETRIC)];
    }

    public AlgorithmSet getAsymetricEncryptionAlgorithm() {
        return this.set[this.types.indexOf(AlgorithmSetName.ENCRYPT_ASYMETRIC)];
    }

    public AlgorithmSet getPasswordBaseEncryptionAlgorithm() {
        return this.set[this.types.indexOf(AlgorithmSetName.PASSWORD_BASE_ENCRYPTION)];
    }

    public AlgorithmSet getKeyPairAlgorithm() {
        return this.set[this.types.indexOf(AlgorithmSetName.KEY_PAIR_ALGO)];
    }

    public AlgorithmSet getSignatureAlgorithm() {
        return this.set[this.types.indexOf(AlgorithmSetName.SIGNATURE_ALGO)];
    }

    public AlgorithmSet getKeyGenAlgorithm() {
        return this.set[this.types.indexOf(AlgorithmSetName.KEY_GEN_ALGO)];
    }

    public AlgorithmSet getKeyWrapAlgorithm() {
        return this.set[this.types.indexOf(AlgorithmSetName.KEY_WRAP_ALGO)];
    }

    public AlgorithmSet getMessageDigestAlgorithm() {
        return this.set[this.types.indexOf(AlgorithmSetName.MESSAGE_DIGEST)];
    }

    public AlgorithmSet getSecureRandomAlgorithm() {
        return this.set[this.types.indexOf(AlgorithmSetName.SECURE_RANDOM)];
    }
}

