/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.CMS.CMSIssuerAndSerialNumber;
import th.co.oga.security.pki.CMS.CMSVersion;

public class CMSCertIdentifier
implements ASN1Value {
    public static Type ISSUER_AND_SERIALNUMBER = Type.ISSUER_AND_SERIALNUMBER;
    public static Type SUBJECT_KEY_IDENTIFIER = Type.SUBJECT_KEY_IDENTIFIER;
    private Type type;
    private CMSIssuerAndSerialNumber issuerAndSerialNumber = null;
    private OCTET_STRING subjectKeyIdentifier = null;
    private static Template templateInstance = new Template();

    public Type getType() {
        return this.type;
    }

    public CMSIssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public OCTET_STRING getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    private CMSCertIdentifier() {
    }

    public CMSCertIdentifier(Type type, CMSIssuerAndSerialNumber issuerAndSerialNumber, OCTET_STRING subjectKeyIdentifier) {
        this.type = type;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.subjectKeyIdentifier = subjectKeyIdentifier;
    }

    public boolean isType(Type type) {
        return this.type.equals(type);
    }

    public static CMSCertIdentifier createIssuerAndSerialNumber(CMSIssuerAndSerialNumber ias) {
        return new CMSCertIdentifier(ISSUER_AND_SERIALNUMBER, ias, null);
    }

    public static CMSCertIdentifier createInstance(CMSIssuerAndSerialNumber ias) {
        return new CMSCertIdentifier(ISSUER_AND_SERIALNUMBER, ias, null);
    }

    public static CMSCertIdentifier createSubjectKeyIdentifier(OCTET_STRING ski) {
        return new CMSCertIdentifier(SUBJECT_KEY_IDENTIFIER, null, ski);
    }

    public static CMSCertIdentifier createSubjectKeyIdentifier(byte[] ski) {
        return CMSCertIdentifier.createSubjectKeyIdentifier(new OCTET_STRING(ski));
    }

    public CMSVersion getSignerInfoVersion() {
        if (this.type == SUBJECT_KEY_IDENTIFIER) {
            return CMSVersion.V3;
        }
        Assert._assert((this.type == ISSUER_AND_SERIALNUMBER ? 1 : 0) != 0);
        return CMSVersion.V1;
    }

    public Tag getTag() {
        if (this.type == SUBJECT_KEY_IDENTIFIER) {
            return Tag.get((long)0L);
        }
        Assert._assert((this.type == ISSUER_AND_SERIALNUMBER ? 1 : 0) != 0);
        return CMSIssuerAndSerialNumber.TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        if (this.type == SUBJECT_KEY_IDENTIFIER) {
            this.subjectKeyIdentifier.encode(Tag.get((long)0L), ostream);
        } else {
            Assert._assert((this.type == ISSUER_AND_SERIALNUMBER ? 1 : 0) != 0);
            this.issuerAndSerialNumber.encode(ostream);
        }
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.encode(ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Type {
        private int type;
        static Type ISSUER_AND_SERIALNUMBER = new Type(0);
        static Type SUBJECT_KEY_IDENTIFIER = new Type(1);

        private Type(int type) {
            this.type = type;
        }

        boolean equals(Type type) {
            return this.type == type.type;
        }
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(Tag.get((long)0L), (ASN1Template)OCTET_STRING.getTemplate());
            this.choicet.addElement((ASN1Template)CMSIssuerAndSerialNumber.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            CHOICE c = (CHOICE)this.choicet.decode(istream);
            if (c.getTag() == SEQUENCE.TAG) {
                return CMSCertIdentifier.createIssuerAndSerialNumber((CMSIssuerAndSerialNumber)c.getValue());
            }
            Assert._assert((boolean)c.getTag().equals((Object)Tag.get((long)0L)));
            OCTET_STRING ski = (OCTET_STRING)c.getValue();
            return CMSCertIdentifier.createSubjectKeyIdentifier(ski);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            return this.decode(istream);
        }
    }
}

