/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cms.DigestedData;
import org.mozilla.jss.pkix.cms.EncryptedData;
import org.mozilla.jss.pkix.cms.EnvelopedData;
import org.mozilla.jss.pkix.cms.SignedAndEnvelopedData;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.CMS.CMSSignedData;

public class CMSContentInfo
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    public static OBJECT_IDENTIFIER DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 1L});
    public static OBJECT_IDENTIFIER SIGNED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 2L});
    public static OBJECT_IDENTIFIER ENVELOPED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 3L});
    public static OBJECT_IDENTIFIER SIGNED_AND_ENVELOPED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 4L});
    public static OBJECT_IDENTIFIER DIGESTED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 5L});
    public static OBJECT_IDENTIFIER ENCRYPTED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 6L});
    private OBJECT_IDENTIFIER contentType;
    private ANY content;
    private SEQUENCE sequence = new SEQUENCE();
    private static Template templateInstance = new Template();

    private CMSContentInfo() {
    }

    public CMSContentInfo(OBJECT_IDENTIFIER contentType, ASN1Value content) {
        this.contentType = contentType;
        this.sequence.addElement((ASN1Value)contentType);
        if (content != null) {
            if (content instanceof ANY) {
                this.content = (ANY)content;
            } else {
                try {
                    this.content = (ANY)ASN1Util.decode((ASN1Template)ANY.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)content));
                }
                catch (InvalidBERException e) {
                    Assert.notReached((String)"InvalidBERException while convertingASN1Value to ANY");
                }
            }
            this.sequence.addElement((ASN1Value)new EXPLICIT(new Tag(0L), content));
        }
    }

    public CMSContentInfo(OBJECT_IDENTIFIER contentType, byte[] content) throws InvalidBERException {
        this(contentType, (ASN1Value)((ANY)ASN1Util.decode((ASN1Template)ANY.getTemplate(), (byte[])content)));
    }

    public CMSContentInfo(byte[] data) {
        this(DATA, (ASN1Value)new OCTET_STRING(data));
    }

    public CMSContentInfo(SignedData sd) {
        this(SIGNED_DATA, (ASN1Value)sd);
    }

    public CMSContentInfo(EnvelopedData ed) {
        this(ENVELOPED_DATA, (ASN1Value)ed);
    }

    public CMSContentInfo(SignedAndEnvelopedData sed) {
        this(SIGNED_AND_ENVELOPED_DATA, (ASN1Value)sed);
    }

    public CMSContentInfo(DigestedData dd) {
        this(DIGESTED_DATA, (ASN1Value)dd);
    }

    public CMSContentInfo(EncryptedData ed) {
        this(ENCRYPTED_DATA, (ASN1Value)ed);
    }

    public OBJECT_IDENTIFIER getContentType() {
        return this.contentType;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public ASN1Value getInterpretedContent() throws InvalidBERException {
        if (this.contentType.equals((Object)DATA)) {
            return this.content.decodeWith((ASN1Template)new OCTET_STRING.Template());
        }
        if (this.contentType.equals((Object)SIGNED_DATA)) {
            return this.content.decodeWith((ASN1Template)new CMSSignedData.Template());
        }
        if (this.contentType.equals((Object)ENVELOPED_DATA)) {
            return this.content.decodeWith((ASN1Template)new EnvelopedData.Template());
        }
        if (this.contentType.equals((Object)SIGNED_AND_ENVELOPED_DATA)) {
            return this.content.decodeWith((ASN1Template)new SignedAndEnvelopedData.Template());
        }
        if (this.contentType.equals((Object)DIGESTED_DATA)) {
            return this.content.decodeWith((ASN1Template)new DigestedData.Template());
        }
        if (this.contentType.equals((Object)ENCRYPTED_DATA)) {
            return this.content.decodeWith((ASN1Template)new EncryptedData.Template());
        }
        return this.content;
    }

    public ANY getContent() {
        return this.content;
    }

    public byte[] getByteContent() {
        return ASN1Util.encode((ASN1Value)this.content);
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public boolean tagMatch(Tag tag) {
            return tag.equals((Object)TAG);
        }

        public Template() {
            this.seqt.addElement((ASN1Template)new OBJECT_IDENTIFIER.Template());
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new ANY.Template()));
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 2 ? 1 : 0) != 0);
            ASN1Value content = seq.elementAt(1) == null ? null : ((EXPLICIT)seq.elementAt(1)).getContent();
            return new CMSContentInfo((OBJECT_IDENTIFIER)seq.elementAt(0), content);
        }
    }
}

