/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.Tag;

public class CMSContentType
implements ASN1Value {
    private OBJECT_IDENTIFIER contentType = null;
    private static final Tag TAG = OBJECT_IDENTIFIER.TAG;
    private static Template templateInstance = new Template();

    CMSContentType(OBJECT_IDENTIFIER contentType) {
        this.contentType = contentType;
    }

    public CMSContentType(String oid) {
        this(new OBJECT_IDENTIFIER(oid));
    }

    public String getOID() {
        long[] src = this.contentType.getNumbers();
        String x = "";
        int i = 0;
        while (i < src.length) {
            x = String.valueOf(x) + (x.length() > 0 ? "." : "") + (int)src[i];
            ++i;
        }
        return x;
    }

    public OBJECT_IDENTIFIER getObjectIdentifier() {
        return this.contentType;
    }

    public boolean equals(CMSContentType comp) {
        return this.contentType.equals((Object)comp.getObjectIdentifier());
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        this.contentType.encode(tag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            OBJECT_IDENTIFIER ct = (OBJECT_IDENTIFIER)OBJECT_IDENTIFIER.getTemplate().decode(implicitTag, istream);
            return new CMSContentType(ct);
        }
    }
}

