/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.CMS.CMSUtils;

public class CMSDigestInfo
implements ASN1Value {
    private AlgorithmIdentifier digestAlgorithm;
    private OCTET_STRING digest;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private CMSDigestInfo() {
    }

    public CMSDigestInfo(AlgorithmIdentifier digestAlgorithm, OCTET_STRING digest) {
        if (digestAlgorithm == null || digest == null) {
            throw new IllegalArgumentException();
        }
        this.sequence = new SEQUENCE();
        this.digestAlgorithm = digestAlgorithm;
        this.sequence.addElement((ASN1Value)digestAlgorithm);
        this.digest = digest;
        this.sequence.addElement((ASN1Value)digest);
    }

    public CMSDigestInfo(AlgorithmProfile algo, byte[] digest) {
        this(CMSUtils.getAlgoId(algo), new OCTET_STRING(digest));
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public OCTET_STRING getDigest() {
        return this.digest;
    }

    public byte[] getDigestData() {
        return this.digest.toByteArray();
    }

    public Tag getTag() {
        return TAG;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CMSDigestInfo)) {
            return false;
        }
        CMSDigestInfo di = (CMSDigestInfo)obj;
        return CMSDigestInfo.byteArraysAreSame(di.digest.toByteArray(), this.digest.toByteArray());
    }

    private static boolean byteArraysAreSame(byte[] left, byte[] right) {
        Assert._assert((left != null && right != null ? 1 : 0) != 0);
        if (left.length != right.length) {
            return false;
        }
        int i = 0;
        while (i < left.length) {
            if (left[i] != right[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream ostream) throws InvalidBERException, IOException {
            return this.decode(TAG, ostream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream ostream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, ostream);
            return new CMSDigestInfo((AlgorithmIdentifier)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1));
        }
    }
}

