/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.CMS.CMSContentInfo;
import th.co.oga.security.pki.CMS.CMSUtils;

public class CMSDigestedData
implements ASN1Value {
    public static INTEGER VERSION = new INTEGER(1L);
    private INTEGER version;
    private AlgorithmIdentifier digestAlgorithm;
    private CMSContentInfo contentInfo;
    private OCTET_STRING digest;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    private CMSDigestedData() {
    }

    public CMSDigestedData(INTEGER ver, AlgorithmIdentifier digestAlgorithm, CMSContentInfo contentInfo, OCTET_STRING digest) throws IllegalArgumentException {
        if (ver == null || digestAlgorithm == null || contentInfo == null || digest == null) {
            throw new IllegalArgumentException("DigestedData constructor parameter is null");
        }
        this.version = ver;
        this.digestAlgorithm = digestAlgorithm;
        this.contentInfo = contentInfo;
        this.digest = digest;
        this.sequence = new SEQUENCE();
        this.sequence.addElement((ASN1Value)this.version);
        this.sequence.addElement((ASN1Value)digestAlgorithm);
        this.sequence.addElement((ASN1Value)contentInfo);
        this.sequence.addElement((ASN1Value)digest);
    }

    public CMSDigestedData(AlgorithmProfile digestAlg, CMSContentInfo contentInfo, byte[] digest) throws IllegalArgumentException {
        this(VERSION, CMSUtils.getAlgoId(digestAlg), contentInfo, new OCTET_STRING(digest));
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public CMSContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public OCTET_STRING getDigest() {
        return this.digest;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)CMSContentInfo.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new CMSDigestedData((INTEGER)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1), (CMSContentInfo)seq.elementAt(2), (OCTET_STRING)seq.elementAt(3));
        }
    }
}

