/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.CMS.CMSContentType;
import th.co.oga.security.pki.OIDs;

public class CMSEncapsulatedContentInfo
implements ASN1Value {
    public static CMSContentType DATA = new CMSContentType(OIDs.PKCS7Data);
    public static CMSContentType SIGNED_DATA = new CMSContentType(OIDs.PKCS7signedData);
    public static CMSContentType ENVELOPED_DATA = new CMSContentType(OIDs.PKCS7envelopedData);
    public static CMSContentType SIGNED_AND_ENVELOPED_DATA = new CMSContentType(OIDs.PKCS7signedAndEnvelopedData);
    public static CMSContentType DIGESTED_DATA = new CMSContentType(OIDs.PKCS7digestedData);
    public static CMSContentType ENCRYPTED_DATA = new CMSContentType(OIDs.PKCS7encryptedData);
    public static CMSContentType TIMESTAMP_DATA = new CMSContentType(OIDs.TIMESTAMP_TOKEN_INFO);
    private CMSContentType contentType;
    private OCTET_STRING content;
    private SEQUENCE sequence = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    private CMSEncapsulatedContentInfo() {
    }

    public CMSEncapsulatedContentInfo(byte[] data) {
        this(DATA, (ASN1Value)new OCTET_STRING(data));
    }

    public CMSEncapsulatedContentInfo(CMSContentType contentType, ASN1Value content) {
        this.contentType = contentType;
        this.sequence.addElement((ASN1Value)contentType);
        if (content != null) {
            this.content = content instanceof OCTET_STRING ? (OCTET_STRING)content : new OCTET_STRING(ASN1Util.encode((ASN1Value)content));
            this.sequence.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)this.content));
        }
    }

    public CMSContentType getContentType() {
        return this.contentType;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public OCTET_STRING getContent() {
        return this.content;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public boolean tagMatch(Tag tag) {
            return tag.equals((Object)TAG);
        }

        public Template() {
            this.seqt.addElement((ASN1Template)CMSContentType.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new OCTET_STRING.Template()));
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 2 ? 1 : 0) != 0);
            ASN1Value content = seq.elementAt(1) == null ? null : ((EXPLICIT)seq.elementAt(1)).getContent();
            return new CMSEncapsulatedContentInfo((CMSContentType)seq.elementAt(0), content);
        }
    }
}

