/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.CMS.CMSUtils;

public class CMSEncryptedContentInfo
implements ASN1Value {
    private OBJECT_IDENTIFIER contentType;
    private AlgorithmIdentifier contentEncryptionAlgorithm;
    private OCTET_STRING encryptedContent;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private CMSEncryptedContentInfo() {
    }

    public CMSEncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier encryptAlgorithm, OCTET_STRING encryptedContent) {
        this(contentType, encryptAlgorithm, encryptedContent, false);
    }

    public CMSEncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier encryptAlgorithm, byte[] cipherText) {
        this(contentType, encryptAlgorithm, new OCTET_STRING(cipherText), false);
    }

    public CMSEncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier encryptAlgorithm, OCTET_STRING encryptedContent, boolean createHackedCRSCompatibleECI) {
        this.contentType = contentType;
        this.contentEncryptionAlgorithm = encryptAlgorithm;
        this.encryptedContent = encryptedContent;
        this.sequence.addElement((ASN1Value)contentType);
        this.sequence.addElement((ASN1Value)this.contentEncryptionAlgorithm);
        if (encryptedContent != null) {
            if (createHackedCRSCompatibleECI) {
                this.sequence.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)encryptedContent));
            } else {
                this.sequence.addElement(new Tag(0L), (ASN1Value)encryptedContent);
            }
        }
    }

    public OBJECT_IDENTIFIER getContentType() {
        return this.contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public OCTET_STRING getEncryptedContent() {
        return this.encryptedContent;
    }

    public byte[] getCipherText() {
        return this.encryptedContent.toByteArray();
    }

    public boolean hasEncryptedContent() {
        return this.encryptedContent != null;
    }

    public byte[] getAlgorithmParameters() {
        return CMSUtils.getAlgorithmParamerters(this.contentEncryptionAlgorithm);
    }

    public static CMSEncryptedContentInfo createCRSCompatibleEncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier encryptAlgorithm, OCTET_STRING encryptedContent) {
        return new CMSEncryptedContentInfo(contentType, encryptAlgorithm, encryptedContent, true);
    }

    public static CMSEncryptedContentInfo createCRSCompatibleEncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier encryptAlgorithm, byte[] cipherText) {
        return new CMSEncryptedContentInfo(contentType, encryptAlgorithm, new OCTET_STRING(cipherText), true);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        this.sequence.encode(tag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return tag.equals((Object)TAG);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement((ASN1Template)new OBJECT_IDENTIFIER.Template());
            seqt.addElement((ASN1Template)new AlgorithmIdentifier.Template());
            seqt.addOptionalElement(new Tag(0L), (ASN1Template)new OCTET_STRING.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 3 ? 1 : 0) != 0);
            return new CMSEncryptedContentInfo((OBJECT_IDENTIFIER)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1), (OCTET_STRING)seq.elementAt(2));
        }
    }
}

