/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.CMS.CMSEncryptedContentInfo;

public class CMSEncryptedData
implements ASN1Value {
    private INTEGER version;
    private CMSEncryptedContentInfo encryptedContentInfo;
    private SEQUENCE sequence;
    public static final INTEGER DEFAULT_VERSION = new INTEGER(0L);
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private CMSEncryptedData() {
    }

    public CMSEncryptedData(INTEGER version, CMSEncryptedContentInfo encryptedContentInfo) {
        if (version == null || encryptedContentInfo == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.sequence = new SEQUENCE();
        this.version = version;
        this.sequence.addElement((ASN1Value)version);
        this.encryptedContentInfo = encryptedContentInfo;
        this.sequence.addElement((ASN1Value)encryptedContentInfo);
    }

    public CMSEncryptedData(CMSEncryptedContentInfo encryptedContentInfo) {
        this(DEFAULT_VERSION, encryptedContentInfo);
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public CMSEncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement((ASN1Template)CMSEncryptedContentInfo.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new CMSEncryptedData((INTEGER)seq.elementAt(0), (CMSEncryptedContentInfo)seq.elementAt(1));
        }
    }
}

