/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.CMS.CMSContentInfo;
import th.co.oga.security.pki.CMS.CMSContentInfoAlteredException;
import th.co.oga.security.pki.CMS.CMSSignatureVerifyException;
import th.co.oga.security.pki.CMS.CMSSignedData;
import th.co.oga.security.pki.CMS.CMSSignerInfoNotValidateException;
import th.co.oga.security.pki.CMS.CMSSigningException;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Packaging.CMSPackager;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.RawSignerInfo;
import th.co.oga.security.pki.Packaging.SecurePackageCRLException;
import th.co.oga.security.pki.Packaging.SecurePackageSigningFailException;
import th.co.oga.security.pki.Packaging.SecurePackageVerifyFailException;
import th.co.oga.security.pki.Packaging.SecureTaker;

public class CMSOperator
extends SecureTaker {
    private CMSPackager packager;

    public CMSOperator(Room room) throws AlgorithmSupportException, EntryNotFoundException, SecureStoreException {
        super(room.getSecureOperator());
        room.applyPolicy(this);
        this.packager = new CMSPackager(room);
    }

    public void sMimeVerify(CMSSignedData signedData) throws CMSSignatureVerifyException, CMSSignerInfoNotValidateException, CMSContentInfoAlteredException {
        try {
            RawSignedData rsd = this.packager.adapter.getSignedData(signedData);
            Iterator signers = rsd.getSigners();
            while (signers.hasNext()) {
                RawSignerInfo signer = (RawSignerInfo)signers.next();
                this.packager.signerVerify(rsd, signer.getSignerCertificate());
            }
        }
        catch (SignatureException e) {
            throw new CMSSignerInfoNotValidateException(e.toString());
        }
        catch (SecurePackageCRLException e) {
            throw new CMSSignerInfoNotValidateException(e.toString());
        }
        catch (CertificateException e) {
            throw new CMSSignatureVerifyException(e.toString());
        }
        catch (SecurePackageVerifyFailException e) {
            throw new CMSSignatureVerifyException(e.toString());
        }
        catch (ASN1Exception e) {
            throw new CMSSignatureVerifyException(e.toString());
        }
        catch (IOException e) {
            throw new CMSSignatureVerifyException(e.toString());
        }
        catch (AlgorithmSupportException e) {
            throw new CMSSignatureVerifyException(e.toString());
        }
    }

    protected CMSContentInfo sMimeSign(byte[] data, boolean keepData) throws CMSSigningException {
        try {
            RawSignedData rsd = this.packager.signData(data);
            CMSSignedData signedData = this.packager.adapter.getSignedData(rsd);
            if (!keepData) {
                signedData.purgeContentData();
            }
            signedData.setCertificate(this.sOper.getIssuerCertificate(this.defaultCertificate));
            return new CMSContentInfo(CMSContentInfo.SIGNED_DATA, signedData);
        }
        catch (Exception e) {
            throw new CMSSigningException(e.toString());
        }
    }

    protected CMSSignedData sMimeSign(CMSSignedData signedData) throws CertProfileException, AlgorithmSupportException, IOException, CertificateException, ASN1Exception, SecureStoreFindingFailException, SecurePackageSigningFailException {
        RawSignedData rsd = this.packager.adapter.getSignedData(signedData);
        this.packager.sign(rsd);
        return this.packager.adapter.getSignedData(rsd);
    }

    public CMSContentInfo sMimeSign(byte[] data) throws CMSSigningException {
        return this.sMimeSign(data, false);
    }

    protected String getDigestAlgorithmsName(CMSSignedData signedData) throws AlgorithmSupportException {
        String algos = "";
        SET set = signedData.getDigestAlgorithmIdentifiers();
        int i = 0;
        while (i < set.size()) {
            AlgorithmIdentifier algId = (AlgorithmIdentifier)set.elementAt(i);
            algos = String.valueOf(algos.length() > 0 ? "," : "") + this.macAlgoSet.findByOID(algId.getOID().getNumbers()).getAlgorithmName();
            ++i;
        }
        return algos;
    }
}

