/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.CMS.CMSCertIdentifier;

public class CMSRecipientInfo
implements ASN1Value {
    private INTEGER version;
    private CMSCertIdentifier recipientID;
    private AlgorithmIdentifier keyEncryptionAlgorithmID;
    private OCTET_STRING encryptedKey;
    private SEQUENCE sequence = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private CMSRecipientInfo() {
    }

    public CMSRecipientInfo(CMSCertIdentifier rid, AlgorithmIdentifier keyAlgID, byte[] encryptedKey) {
        this.recipientID = rid;
        this.keyEncryptionAlgorithmID = keyAlgID;
        this.encryptedKey = new OCTET_STRING(encryptedKey);
        this.version = rid.isType(CMSCertIdentifier.ISSUER_AND_SERIALNUMBER) ? new INTEGER(0L) : new INTEGER(2L);
        this.sequence.addElement((ASN1Value)this.version);
        this.sequence.addElement((ASN1Value)this.recipientID);
        this.sequence.addElement((ASN1Value)this.keyEncryptionAlgorithmID);
        this.sequence.addElement((ASN1Value)this.encryptedKey);
    }

    public CMSRecipientInfo(INTEGER version, CMSCertIdentifier rid, AlgorithmIdentifier keyEncryptionAlgorithmID, OCTET_STRING encryptedKey) {
        Assert._assert((rid != null ? 1 : 0) != 0);
        Assert._assert((keyEncryptionAlgorithmID != null ? 1 : 0) != 0);
        Assert._assert((encryptedKey != null ? 1 : 0) != 0);
        this.version = version;
        this.recipientID = rid;
        this.keyEncryptionAlgorithmID = keyEncryptionAlgorithmID;
        this.encryptedKey = encryptedKey;
        this.sequence.addElement((ASN1Value)version);
        this.sequence.addElement((ASN1Value)this.recipientID);
        this.sequence.addElement((ASN1Value)keyEncryptionAlgorithmID);
        this.sequence.addElement((ASN1Value)encryptedKey);
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public CMSCertIdentifier getRecipientIdentifier() {
        return this.recipientID;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithmID() {
        return this.keyEncryptionAlgorithmID;
    }

    public OCTET_STRING getEncryptedKey() {
        return this.encryptedKey;
    }

    public byte[] getEncryptedKeyByte() {
        return this.encryptedKey.toByteArray();
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        this.sequence.encode(tag, ostream);
    }

    public static class Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals((Object)TAG);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement((ASN1Template)new INTEGER.Template());
            seqt.addElement((ASN1Template)new CMSCertIdentifier.Template());
            seqt.addElement((ASN1Template)new AlgorithmIdentifier.Template());
            seqt.addElement((ASN1Template)new OCTET_STRING.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 4 ? 1 : 0) != 0);
            return new CMSRecipientInfo((INTEGER)seq.elementAt(0), (CMSCertIdentifier)seq.elementAt(1), (AlgorithmIdentifier)seq.elementAt(2), (OCTET_STRING)seq.elementAt(3));
        }
    }
}

