/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.util.Calendar;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.pkix.primitive.Attribute;
import th.co.oga.security.pki.CMS.CMSAttributeName;
import th.co.oga.security.pki.CMS.CMSCertIdentifier;
import th.co.oga.security.pki.CMS.CMSIssuerAndSerialNumber;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.SMIME.SMIMECapabilities;
import th.co.oga.security.pki.SMIME.SMIMECapability;
import th.co.oga.security.pki.SMIME.sMIMEEncryptionKeyReference;
import th.co.oga.security.pki.x.XSigningTime;

public class CMSSignedAttributes
implements CMSAttributeName {
    public static OBJECT_IDENTIFIER CONTENT_TYPE_OID = new OBJECT_IDENTIFIER(CONTENT_TYPE);
    public static OBJECT_IDENTIFIER SIGNING_TIME_OID = new OBJECT_IDENTIFIER(SIGNING_TIME);
    public static OBJECT_IDENTIFIER MESSAGE_DIGEST_OID = new OBJECT_IDENTIFIER(MESSAGE_DIGEST);
    public static OBJECT_IDENTIFIER SMIME_CAPABILITIES_OID = new OBJECT_IDENTIFIER(SMIME_CAPABILITIES);
    public static OBJECT_IDENTIFIER MSOE_ENCRYPTION_KEY_REFERENCE_OID = new OBJECT_IDENTIFIER(MSOE_ENCRYPTION_KEY_REFERENCE);
    public static OBJECT_IDENTIFIER SMIME_ENCRYPTION_LEY_PREFERENCE_OID = new OBJECT_IDENTIFIER(SMIME_ENCRYPTION_LEY_PREFERENCE);
    private SET set;

    public CMSSignedAttributes() {
        this.set = new SET();
    }

    public CMSSignedAttributes(SET set) {
        this.set = set;
    }

    public SET getAttributes() {
        return this.set;
    }

    public static String getText(Attribute attr) throws InvalidBERException {
        String txt = "";
        ANY value = new ANY(ASN1Util.encode((ASN1Value)attr.getValues().elementAt(0)));
        if (attr.getType().equals((Object)CONTENT_TYPE_OID)) {
            OBJECT_IDENTIFIER oid = (OBJECT_IDENTIFIER)value.decodeWith((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            txt = oid.toString();
        } else if (attr.getType().equals((Object)SIGNING_TIME_OID)) {
            XSigningTime st = (XSigningTime)value.decodeWith((ASN1Template)XSigningTime.getTemplate());
            txt = st.getText();
        } else if (attr.getType().equals((Object)MESSAGE_DIGEST_OID)) {
            OCTET_STRING st = (OCTET_STRING)value.decodeWith((ASN1Template)OCTET_STRING.getTemplate());
            txt = new String(st.toByteArray());
        } else {
            txt = new String("");
        }
        return txt;
    }

    public static Attribute getContentTypeAttribute(OBJECT_IDENTIFIER contentType) {
        return new Attribute(CONTENT_TYPE_OID, (ASN1Value)contentType);
    }

    public static Attribute getSigningTimeAttribute() {
        return new Attribute(SIGNING_TIME_OID, (ASN1Value)new XSigningTime(Calendar.getInstance()));
    }

    public static Attribute getMessageDigestAttribute(byte[] digest) {
        return new Attribute(MESSAGE_DIGEST_OID, (ASN1Value)new OCTET_STRING(digest));
    }

    public static Attribute getMSOEEncryptionKeyPreferenceAttribute(CMSCertIdentifier certID) {
        return new Attribute(MSOE_ENCRYPTION_KEY_REFERENCE_OID, (ASN1Value)certID);
    }

    public static Attribute getSMIMEEncryptionKeyReference(CMSIssuerAndSerialNumber certID) {
        return new Attribute(SMIME_ENCRYPTION_LEY_PREFERENCE_OID, (ASN1Value)new sMIMEEncryptionKeyReference(certID));
    }

    public static Attribute getSMIMECapabilities() {
        SMIMECapabilities caps = new SMIMECapabilities();
        caps.setItem(new SMIMECapability(OIDs.DES3_CBC));
        caps.setItem(new SMIMECapability(OIDs.RC2_CBC, 128));
        caps.setItem(new SMIMECapability(OIDs.RC2_CBC, 64));
        caps.setItem(new SMIMECapability(OIDs.DES_CBC));
        caps.setItem(new SMIMECapability(OIDs.RC2_CBC, 40));
        return new Attribute(SMIME_CAPABILITIES_OID, (ASN1Value)caps);
    }

    public static SET getSMIMESignedAttributes(OBJECT_IDENTIFIER contentType, byte[] msgDigest) {
        SET attrs = new SET();
        attrs.addElement((ASN1Value)CMSSignedAttributes.getContentTypeAttribute(contentType));
        attrs.addElement((ASN1Value)CMSSignedAttributes.getSigningTimeAttribute());
        attrs.addElement((ASN1Value)CMSSignedAttributes.getMessageDigestAttribute(msgDigest));
        return attrs;
    }

    public void addContentType(OBJECT_IDENTIFIER contentType) {
        this.set.addElement((ASN1Value)CMSSignedAttributes.getContentTypeAttribute(contentType));
    }

    public void addSigningTime() {
        this.set.addElement((ASN1Value)CMSSignedAttributes.getSigningTimeAttribute());
    }

    public void addMessageDigest(byte[] digest) {
        this.set.addElement((ASN1Value)CMSSignedAttributes.getMessageDigestAttribute(digest));
    }

    public void addSMIMECapabilities() {
        this.set.addElement((ASN1Value)CMSSignedAttributes.getSMIMECapabilities());
    }

    public void addMSOEEncryptionKeyPreference(CMSCertIdentifier certID) {
        this.set.addElement((ASN1Value)CMSSignedAttributes.getMSOEEncryptionKeyPreferenceAttribute(certID));
    }

    public void addSMIMEEncryptionKeyReference(CMSIssuerAndSerialNumber certID) {
        this.set.addElement((ASN1Value)CMSSignedAttributes.getSMIMEEncryptionKeyReference(certID));
    }
}

