/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.CMS.CMSEncapsulatedContentInfo;
import th.co.oga.security.pki.CMS.CMSSignerInfo;
import th.co.oga.security.pki.CMS.CMSUtils;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.X500.DName;

public class CMSSignedData
implements ASN1Value {
    private static final INTEGER VERSION = new INTEGER(1L);
    private INTEGER version;
    private SET digestAlgorithms;
    private CMSEncapsulatedContentInfo contentInfo;
    private SET certificates;
    private SET crls;
    private SET signerInfos;
    static final Tag TAG = SEQUENCE.TAG;

    public CMSSignedData(SET digestAlg, CMSEncapsulatedContentInfo contentInfo, SET certs, SET crls, SET signerInfos) {
        this.version = VERSION;
        this.digestAlgorithms = digestAlg == null ? new SET() : digestAlg;
        CMSSignedData.verifyNotNull(contentInfo);
        this.contentInfo = contentInfo;
        this.certificates = certs;
        this.crls = crls;
        this.signerInfos = signerInfos == null ? new SET() : signerInfos;
    }

    public CMSSignedData() {
        this.version = VERSION;
    }

    public CMSSignedData(CMSEncapsulatedContentInfo cinfo) {
        this();
        this.contentInfo = cinfo;
    }

    CMSSignedData(INTEGER version, SET digestAlgorithms, CMSEncapsulatedContentInfo contentInfo, SET certificates, SET crls, SET signerInfos) {
        CMSSignedData.verifyNotNull(version);
        this.version = version;
        CMSSignedData.verifyNotNull(digestAlgorithms);
        this.digestAlgorithms = digestAlgorithms;
        CMSSignedData.verifyNotNull(contentInfo);
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.crls = crls;
        CMSSignedData.verifyNotNull(signerInfos);
        this.signerInfos = signerInfos;
    }

    public CMSSignedData(CMSEncapsulatedContentInfo contentInfo, AlgorithmProfile digestAlgo, CertProfile[] certs) throws ASN1Exception, IOException, CertPackageException {
        this(null, contentInfo, new SET(), null, null);
        this.digestAlgorithms = new SET();
        this.digestAlgorithms.addElement((ASN1Value)CMSUtils.getAlgoId(digestAlgo));
        if (certs != null) {
            int i = 0;
            while (i < certs.length) {
                this.setCertificate(certs[i]);
                ++i;
            }
        }
    }

    public void setSignerInfo(CMSSignerInfo signer) {
        if (this.signerInfos == null) {
            this.signerInfos = new SET();
            this.signerInfos.addElement((ASN1Value)signer);
        } else {
            SET nSet = new SET();
            nSet.addElement((ASN1Value)signer);
            int i = 0;
            while (i < this.signerInfos.size()) {
                nSet.addElement(this.signerInfos.elementAt(i));
                ++i;
            }
            this.signerInfos = nSet;
        }
    }

    public void setDigestAlgo(AlgorithmIdentifier algo) {
        if (this.digestAlgorithms == null) {
            this.digestAlgorithms = new SET();
        }
        boolean found = false;
        if (this.digestAlgorithms.size() > 0) {
            int e = 0;
            while (e < this.digestAlgorithms.size()) {
                AlgorithmIdentifier dsgAlgo = (AlgorithmIdentifier)this.digestAlgorithms.elementAt(e);
                if (CMSUtils.isSameAlgorithm(algo, dsgAlgo)) {
                    found = true;
                    break;
                }
                ++e;
            }
        }
        if (!found) {
            this.digestAlgorithms.addElement((ASN1Value)algo);
        }
    }

    public void setCerts(CertProfile[] certs) throws IOException, ASN1Exception, CertPackageException {
        if (certs != null) {
            int i = 0;
            while (i < certs.length) {
                this.setCertificate(certs[i]);
                ++i;
            }
        }
    }

    public void setCertificate(CertProfile cert) throws IOException, ASN1Exception, CertPackageException {
        if (this.certificates == null) {
            this.certificates = new SET();
        }
        try {
            Certificate mCert = (Certificate)Certificate.getTemplate().decode((InputStream)new ByteArrayInputStream(cert.getBytes()));
            DName issuer = new DName(mCert.getInfo().getSubject());
            INTEGER sn = mCert.getInfo().getSerialNumber();
            boolean duplicate = false;
            int i = 0;
            while (i < this.certificates.size()) {
                Certificate pCert = (Certificate)this.certificates.elementAt(i);
                DName pIssuer = new DName(pCert.getInfo().getSubject());
                INTEGER pSn = pCert.getInfo().getSerialNumber();
                if (issuer.equals(pIssuer) && sn.compareTo((BigInteger)pSn) == 0) {
                    duplicate = true;
                    break;
                }
                ++i;
            }
            if (!duplicate) {
                SET nSet = new SET();
                nSet.addElement((ASN1Value)mCert);
                int i2 = 0;
                while (i2 < this.certificates.size()) {
                    nSet.addElement((ASN1Value)((Certificate)this.certificates.elementAt(i2)));
                    ++i2;
                }
                this.certificates = nSet;
            }
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception(e.toString());
        }
    }

    public void setDataContent(byte[] data) {
        this.contentInfo = new CMSEncapsulatedContentInfo(data);
    }

    public void purgeContentData() {
        CMSEncapsulatedContentInfo info;
        this.contentInfo = info = new CMSEncapsulatedContentInfo(this.contentInfo.getContentType(), null);
    }

    public void setVersion(int ver) {
        this.version = new INTEGER((long)ver);
    }

    private static void verifyNotNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public SET getDigestAlgorithmIdentifiers() {
        return this.digestAlgorithms;
    }

    public CMSEncapsulatedContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public SET getCertificates() {
        return this.certificates;
    }

    public boolean hasCertificates() {
        return this.certificates != null;
    }

    public SET getCrls() {
        return this.crls;
    }

    public boolean hasCrls() {
        return this.crls != null;
    }

    public SET getSignerInfos() {
        return this.signerInfos;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        SEQUENCE sequence = new SEQUENCE();
        sequence.addElement((ASN1Value)this.version);
        sequence.addElement((ASN1Value)this.digestAlgorithms);
        sequence.addElement((ASN1Value)this.contentInfo);
        if (this.certificates != null) {
            sequence.addElement(new Tag(0L), (ASN1Value)this.certificates);
        }
        if (this.crls != null) {
            sequence.addElement(new Tag(1L), (ASN1Value)this.crls);
        }
        sequence.addElement((ASN1Value)this.signerInfos);
        sequence.encode(tag, ostream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement((ASN1Template)new SET.OF_Template((ASN1Template)AlgorithmIdentifier.getTemplate()));
            this.seqt.addElement((ASN1Template)CMSEncapsulatedContentInfo.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), (ASN1Template)new SET.OF_Template((ASN1Template)Certificate.getTemplate()));
            this.seqt.addOptionalElement(new Tag(1L), (ASN1Template)new SET.OF_Template((ASN1Template)ANY.getTemplate()));
            this.seqt.addElement((ASN1Template)new SET.OF_Template((ASN1Template)CMSSignerInfo.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 6 ? 1 : 0) != 0);
            return new CMSSignedData((INTEGER)seq.elementAt(0), (SET)seq.elementAt(1), (CMSEncapsulatedContentInfo)seq.elementAt(2), (SET)seq.elementAt(3), (SET)seq.elementAt(4), (SET)seq.elementAt(5));
        }
    }
}

