/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Calendar;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.CMS.CMSCertIdentifier;
import th.co.oga.security.pki.CMS.CMSDigestEncryptionFailException;
import th.co.oga.security.pki.CMS.CMSEncapsulatedContentInfo;
import th.co.oga.security.pki.CMS.CMSIssuerAndSerialNumber;
import th.co.oga.security.pki.CMS.CMSSignatureInvalidateException;
import th.co.oga.security.pki.CMS.CMSUtils;
import th.co.oga.security.pki.CMS.CMSVersion;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.Operation.CryptoOperatorException;
import th.co.oga.security.pki.Operator.SecureOperator;
import th.co.oga.security.pki.P7.P7ContentInfo;
import th.co.oga.security.pki.x.XSigningTime;

public class CMSSignerInfo
implements ASN1Value {
    private static final CMSVersion VERSION = CMSVersion.V1;
    public static OBJECT_IDENTIFIER CONTENT_TYPE_OID = new OBJECT_IDENTIFIER(OIDs.PKCS9_ContentType);
    public static OBJECT_IDENTIFIER SIGNING_TIME_OID = new OBJECT_IDENTIFIER(OIDs.PKCS9_SigningTime);
    public static OBJECT_IDENTIFIER MESSAGE_DIGEST_OID = new OBJECT_IDENTIFIER(OIDs.PKCS9_MessageDigest);
    private CMSVersion version;
    private CMSCertIdentifier sid;
    private AlgorithmIdentifier digestAlgorithm;
    private SET signedAttrs;
    private AlgorithmIdentifier signatureAlgorithm;
    private OCTET_STRING signautreData;
    private SET unsignedAttrs;
    private static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    public CMSSignerInfo(CMSCertIdentifier signerIdentifier, AlgorithmIdentifier digestAlgorithm, SET signedAttributes, AlgorithmIdentifier signatureAlgorithm, byte[] encryptedDigest, SET unsignedAttributes) {
        this(signerIdentifier.getSignerInfoVersion(), signerIdentifier, digestAlgorithm, signedAttributes, signatureAlgorithm, encryptedDigest, unsignedAttributes);
    }

    CMSSignerInfo(CMSVersion version, CMSCertIdentifier signerIdentifier, AlgorithmIdentifier digestAlgorithm, SET signedAttributes, AlgorithmIdentifier signatureAlgorithm, byte[] encryptedDigest, SET unsignedAttributes) {
        this.version = version;
        this.sid = signerIdentifier;
        this.digestAlgorithm = digestAlgorithm;
        this.signedAttrs = signedAttributes;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signautreData = new OCTET_STRING(encryptedDigest);
        this.unsignedAttrs = unsignedAttributes;
    }

    public CMSSignerInfo(CMSCertIdentifier sid, AlgorithmProfile digestAlgo, SET signedAttrs, AlgorithmProfile signingAlgo, byte[] signatureValue, SET unsignedAttrs) {
        this(VERSION, sid, CMSUtils.getAlgoId(digestAlgo), signedAttrs, CMSUtils.getAlgoId(signingAlgo), signatureValue, unsignedAttrs);
    }

    public CMSSignerInfo(int ver, CMSCertIdentifier sid, AlgorithmProfile digestAlgo, SET signedAttrs, AlgorithmProfile signingAlgo, byte[] signatureValue) {
        this(CMSVersion.fromInt(ver), sid, CMSUtils.getAlgoId(digestAlgo), signedAttrs, CMSUtils.getAlgoId(signingAlgo), signatureValue, null);
    }

    public CMSCertIdentifier getSignerIdentifier() {
        return this.sid;
    }

    public CMSIssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.sid.getIssuerAndSerialNumber();
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.digestAlgorithm;
    }

    public AlgorithmIdentifier getSignatureAlgorithmIdentifier() {
        return this.signatureAlgorithm;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithmIdentifier() {
        return this.signatureAlgorithm;
    }

    public int getVersion() {
        return this.version.getVersion();
    }

    public SET getSignedAttributes() {
        return this.signedAttrs;
    }

    public boolean hasSignedAttributes() {
        return this.signedAttrs != null;
    }

    public byte[] getEncryptedDigest() {
        return this.signautreData.toByteArray();
    }

    public SET getUnsignedAttributes() {
        return this.unsignedAttrs;
    }

    public boolean hasUnsignedAttributes() {
        return this.unsignedAttrs != null;
    }

    private static Attribute getContentTypeAttribute(OBJECT_IDENTIFIER contentType) {
        return new Attribute(CONTENT_TYPE_OID, (ASN1Value)contentType);
    }

    private static Attribute getSigningTimeAttribute() {
        return new Attribute(SIGNING_TIME_OID, (ASN1Value)new XSigningTime(Calendar.getInstance()));
    }

    private static Attribute getMessageDigestAttribute(byte[] digest) {
        return new Attribute(MESSAGE_DIGEST_OID, (ASN1Value)new OCTET_STRING(digest));
    }

    public static SET getSignedAttributes(OBJECT_IDENTIFIER contentType, byte[] msgDigest) {
        SET attrs = new SET();
        attrs.addElement((ASN1Value)CMSSignerInfo.getContentTypeAttribute(contentType));
        attrs.addElement((ASN1Value)CMSSignerInfo.getSigningTimeAttribute());
        attrs.addElement((ASN1Value)CMSSignerInfo.getMessageDigestAttribute(msgDigest));
        return attrs;
    }

    public static CMSSignerInfo getSignerInfo(SecureOperator oper, CMSEncapsulatedContentInfo content, byte[] msgDigest, AlgorithmProfile algo, CertProfile cert, SET signedAttrs, SET unsignedAttrs) throws ASN1Exception, AlgorithmSupportException, NoSuchAlgorithmException, CMSDigestEncryptionFailException {
        OCTET_STRING encryptedDigest;
        byte[] toBeSigned;
        CMSIssuerAndSerialNumber issuerAndSerialNumber = new CMSIssuerAndSerialNumber(cert.getX509Cert());
        CMSCertIdentifier signerID = CMSCertIdentifier.createInstance(issuerAndSerialNumber);
        AlgorithmProfile dsgAlg = oper.getDigestAlgorithm(algo.getMessageDigestAlgorithmName());
        AlgorithmProfile encAlgo = oper.getAsymetricEncryptionAlgorithmByName(algo.getEncryptionAlgorithmName());
        System.out.println("Signature Algorithm is:" + encAlgo.getOID());
        AlgorithmIdentifier digestAlgorithm = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(dsgAlg.getOID()), null);
        AlgorithmIdentifier signatureAlgorithm = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(encAlgo.getOID()), null);
        SET signedAttributes = null;
        SET unsignedAttributes = null;
        if (!content.getContentType().equals(P7ContentInfo.DATA) && signedAttrs == null) {
            signedAttrs = CMSSignerInfo.getSignedAttributes(P7ContentInfo.DATA, msgDigest);
        }
        if (signedAttrs != null) {
            Assert._assert((signedAttrs.size() >= 2 ? 1 : 0) != 0);
            signedAttributes = signedAttrs;
        }
        byte[] digest = null;
        digest = signedAttributes == null ? msgDigest : oper.hashing(ASN1Util.encode((ASN1Value)signedAttributes), dsgAlg);
        if (algo.isInPath("RSA")) {
            SEQUENCE digestInfo = new SEQUENCE();
            digestInfo.addElement((ASN1Value)new AlgorithmIdentifier(digestAlgorithm.getOID(), null));
            digestInfo.addElement((ASN1Value)new OCTET_STRING(digest));
            toBeSigned = ASN1Util.encode((ASN1Value)digestInfo);
        } else {
            toBeSigned = digest;
        }
        try {
            encryptedDigest = new OCTET_STRING(oper.getSignature(toBeSigned, algo, cert));
        }
        catch (Exception e) {
            throw new CMSDigestEncryptionFailException(e.toString());
        }
        if (unsignedAttrs != null) {
            unsignedAttributes = unsignedAttrs;
        }
        return new CMSSignerInfo(signerID, digestAlgorithm, signedAttributes, signatureAlgorithm, encryptedDigest.toByteArray(), unsignedAttributes);
    }

    public void verify(SecureOperator oper, byte[] messageDigest, OBJECT_IDENTIFIER contentType, CertProfile signedCer) throws AlgorithmSupportException, NoSuchAlgorithmException, SignatureException, CryptoOperatorException, CMSSignatureInvalidateException {
        if (this.signedAttrs == null) {
            this.verifyWithoutAuthenticatedAttributes(oper, messageDigest, contentType, signedCer);
        } else {
            this.verifyWithAuthenticatedAttributes(oper, messageDigest, contentType, signedCer);
        }
    }

    private void verifyWithoutAuthenticatedAttributes(SecureOperator oper, byte[] msgDigest, OBJECT_IDENTIFIER contentType, CertProfile signedCer) throws AlgorithmSupportException, NoSuchAlgorithmException, SignatureException, CryptoOperatorException, CMSSignatureInvalidateException {
        byte[] toBeVerified;
        if (!contentType.equals((Object)P7ContentInfo.DATA)) {
            throw new SignatureException("Content-Type is not DATA, but there are no authenticated attributes");
        }
        AlgorithmProfile signedAlg = oper.getSupportAlgorithm().getSignatureAlgorithm().findByOID(this.signatureAlgorithm.getOID().getNumbers());
        if (signedAlg.isInPath("RSA")) {
            SEQUENCE digestInfo = new SEQUENCE();
            digestInfo.addElement((ASN1Value)new AlgorithmIdentifier(this.digestAlgorithm.getOID(), null));
            digestInfo.addElement((ASN1Value)new OCTET_STRING(msgDigest));
            toBeVerified = ASN1Util.encode((ASN1Value)digestInfo);
        } else {
            toBeVerified = msgDigest;
        }
        if (!oper.signDataVerify(this.signautreData.toByteArray(), toBeVerified, signedAlg, signedCer)) {
            throw new CMSSignatureInvalidateException();
        }
    }

    private void verifyWithAuthenticatedAttributes(SecureOperator oper, byte[] msgDigest, OBJECT_IDENTIFIER contentType, CertProfile signedCer) throws AlgorithmSupportException, NoSuchAlgorithmException, SignatureException, CryptoOperatorException {
        byte[] toBeVerified;
        int numAttrib = this.signedAttrs.size();
        if (numAttrib < 2) {
            throw new SignatureException("At least two authenticated attributes must be present, content-type and message-digest");
        }
        boolean foundContentType = false;
        boolean foundMessageDigest = false;
        int i = 0;
        while (i < numAttrib) {
            ASN1Value val;
            SET vals;
            if (!(this.signedAttrs.elementAt(i) instanceof Attribute)) {
                throw new SignatureException("Element of authenticatedAttributes is not an Attribute");
            }
            Attribute attrib = (Attribute)this.signedAttrs.elementAt(i);
            if (attrib.getType().equals((Object)CONTENT_TYPE_OID)) {
                OBJECT_IDENTIFIER ctype;
                block23: {
                    vals = attrib.getValues();
                    if (vals.size() != 1) {
                        throw new SignatureException("Content-Type attribute does not have exactly one value");
                    }
                    val = vals.elementAt(0);
                    try {
                        if (val instanceof OBJECT_IDENTIFIER) {
                            ctype = (OBJECT_IDENTIFIER)val;
                            break block23;
                        }
                        if (val instanceof ANY) {
                            ctype = (OBJECT_IDENTIFIER)((ANY)val).decodeWith((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
                            break block23;
                        }
                        throw new InvalidBERException("Content-Type authenticated attribute has unexpected content type");
                    }
                    catch (InvalidBERException e) {
                        throw new SignatureException("Content-Type authenticated attribute does not have OBJECT IDENTIFIER value ");
                    }
                }
                if (!ctype.equals((Object)contentType)) {
                    throw new SignatureException("Content-type in authenticated attributes does not  match content-type being verified");
                }
                foundContentType = true;
            } else if (attrib.getType().equals((Object)MESSAGE_DIGEST_OID)) {
                byte[] mdigest;
                block24: {
                    vals = attrib.getValues();
                    if (vals.size() != 1) {
                        throw new SignatureException("Message-digest attribute does not have  exactly one value");
                    }
                    val = vals.elementAt(0);
                    try {
                        if (val instanceof OCTET_STRING) {
                            mdigest = ((OCTET_STRING)val).toByteArray();
                            break block24;
                        }
                        if (val instanceof ANY) {
                            OCTET_STRING os = (OCTET_STRING)((ANY)val).decodeWith((ASN1Template)OCTET_STRING.getTemplate());
                            mdigest = os.toByteArray();
                            break block24;
                        }
                        throw new InvalidBERException("Content-Type authenticated attribute has unexpected  content type");
                    }
                    catch (InvalidBERException e) {
                        throw new SignatureException("Message-digest attribute does not have OCTET STRING value");
                    }
                }
                if (!CMSSignerInfo.byteArraysAreSame(mdigest, msgDigest)) {
                    throw new SignatureException("Message-digest attribute does not match message digest being verified");
                }
                foundMessageDigest = true;
            }
            ++i;
        }
        if (!foundContentType) {
            throw new SignatureException("Authenticated attributes does not contain PKCS #9 content-type attribute");
        }
        if (!foundMessageDigest) {
            throw new SignatureException("Authenticate attributes does not contain  PKCS #9 message-digest attribute");
        }
        AlgorithmProfile signedAlg = oper.getSupportAlgorithm().getSignatureAlgorithm().findByOID(this.signatureAlgorithm.getOID().getNumbers());
        AlgorithmProfile dsgAlg = oper.getSupportAlgorithm().getMessageDigestAlgorithm().findByOID(this.digestAlgorithm.getOID().getNumbers());
        byte[] toBeDigested = ASN1Util.encode((ASN1Value)this.signedAttrs);
        MessageDigest md = oper.getCryptoOperator().getMessageDigest(dsgAlg);
        byte[] digest = md.digest(toBeDigested);
        if (signedAlg.isInPath("RSA")) {
            SEQUENCE digestInfo = new SEQUENCE();
            digestInfo.addElement((ASN1Value)this.digestAlgorithm);
            digestInfo.addElement((ASN1Value)new OCTET_STRING(digest));
            toBeVerified = ASN1Util.encode((ASN1Value)digestInfo);
        } else {
            toBeVerified = digest;
        }
        Signature sig = oper.getVerifier(signedCer, signedAlg);
        sig.update(toBeVerified);
        if (!sig.verify(this.signautreData.toByteArray())) {
            throw new SignatureException("encryptedDigest was not the correct signature of the contents octets of the DER-encoded authenticated attributes");
        }
    }

    public static boolean byteArraysAreSame(byte[] left, byte[] right) {
        Assert._assert((left != null && right != null ? 1 : 0) != 0);
        if (left.length != right.length) {
            return false;
        }
        int i = 0;
        while (i < left.length) {
            if (left[i] != right[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        SEQUENCE sequence = new SEQUENCE();
        sequence.addElement((ASN1Value)this.version);
        sequence.addElement((ASN1Value)this.sid);
        sequence.addElement((ASN1Value)this.digestAlgorithm);
        if (this.signedAttrs != null) {
            sequence.addElement(new Tag(0L), (ASN1Value)this.signedAttrs);
        }
        sequence.addElement((ASN1Value)this.signatureAlgorithm);
        sequence.addElement((ASN1Value)this.signautreData);
        if (this.unsignedAttrs != null) {
            sequence.addElement(new Tag(1L), (ASN1Value)this.unsignedAttrs);
        }
        sequence.encode(tag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)CMSVersion.getTemplate());
            this.seqt.addElement((ASN1Template)CMSCertIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), (ASN1Template)new SET.OF_Template((ASN1Template)Attribute.getTemplate()));
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), (ASN1Template)new SET.OF_Template((ASN1Template)Attribute.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert((seq.size() == 7 ? 1 : 0) != 0);
            return new CMSSignerInfo((CMSVersion)seq.elementAt(0), (CMSCertIdentifier)seq.elementAt(1), (AlgorithmIdentifier)seq.elementAt(2), (SET)seq.elementAt(3), (AlgorithmIdentifier)seq.elementAt(4), ((OCTET_STRING)seq.elementAt(5)).toByteArray(), (SET)seq.elementAt(6));
        }
    }
}

