/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.cert.CertificateEncodingException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgoUtils;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.OIDs;

public class CMSUtils
extends AlgoUtils {
    public CMSUtils(AlgorithmSupportTable algoTable) {
        super(algoTable);
    }

    public static OBJECT_IDENTIFIER getObjID(String oid) {
        return new OBJECT_IDENTIFIER(oid);
    }

    public static String getOID(OBJECT_IDENTIFIER objID) {
        return OIDs.fromLongs(objID.getNumbers());
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg, AlgorithmParameters params) throws ASN1Exception, IOException {
        return CMSUtils.getAlgoId(alg, params.getEncoded());
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg, byte[] params) throws IOException, ASN1Exception {
        ANY param = null;
        if (params != null) {
            try {
                param = new ANY(params);
            }
            catch (InvalidBERException e) {
                throw new ASN1Exception((Exception)((Object)e));
            }
        }
        return new AlgorithmIdentifier(new OBJECT_IDENTIFIER(alg.getOID()), (ASN1Value)param);
    }

    public static boolean isSameAlgorithm(AlgorithmIdentifier algo1, AlgorithmIdentifier algo2) {
        return algo1.getOID().equals((Object)algo2.getOID());
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg) {
        return new AlgorithmIdentifier(new OBJECT_IDENTIFIER(alg.getOID()), null);
    }

    public static byte[] getAlgorithmParamerters(AlgorithmIdentifier algId) {
        if (algId.getParameters() == null) {
            return null;
        }
        ANY param = (ANY)algId.getParameters();
        return param.getEncoded();
    }

    public static String getOID(AlgorithmIdentifier algID) {
        return OIDs.fromLongs(algID.getOID().getNumbers());
    }

    public AlgorithmProfile getSignatureAlgorithm(AlgorithmIdentifier algID) throws AlgorithmSupportException {
        String oid = CMSUtils.getOID(algID);
        return this.getSignatureAlgorithmByOID(oid);
    }

    public AlgorithmProfile getDigestAlgorithm(AlgorithmIdentifier algID) throws AlgorithmSupportException {
        String oid = CMSUtils.getOID(algID);
        return this.getDigestAlgorithmByOID(oid);
    }

    public AlgorithmProfile getDataEncryptionAlgorithm(AlgorithmIdentifier algID) throws AlgorithmSupportException {
        String oid = CMSUtils.getOID(algID);
        return this.getDataEncryptionAlgorithmByOID(oid);
    }

    public AlgorithmProfile getKeyWrappingAlgorithm(AlgorithmIdentifier algID) throws AlgorithmSupportException {
        String oid = CMSUtils.getOID(algID);
        return this.getKeyWrappingAlgorithmByOID(oid);
    }

    public static ASN1Value getCertificate(byte[] cer) throws ASN1Exception {
        try {
            return ASN1Util.decode((ASN1Template)Certificate.getTemplate(), (byte[])cer);
        }
        catch (Exception e) {
            throw new ASN1Exception("ASN.1 Operation fail, " + e.getMessage());
        }
    }

    public static ASN1Value getCertificate(CertProfile cer) throws ASN1Exception, CertificateEncodingException {
        return CMSUtils.getCertificate(cer.getX509Cert().getEncoded());
    }
}

