/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.CMS;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class CMSVersion
implements ASN1Value {
    public static final CMSVersion V0 = new CMSVersion(0);
    public static final CMSVersion V1 = new CMSVersion(1);
    public static final CMSVersion V2 = new CMSVersion(2);
    public static final CMSVersion V3 = new CMSVersion(3);
    public static final CMSVersion V4 = new CMSVersion(4);
    private INTEGER version = null;
    private static final Tag TAG = INTEGER.TAG;
    private static Template templateInstance = new Template();

    CMSVersion(INTEGER version) {
        this.version = version;
    }

    public CMSVersion(int ver) {
        this(new INTEGER((long)ver));
    }

    public int getVersion() {
        return this.version.intValue();
    }

    public static CMSVersion fromInt(int ver) {
        return new CMSVersion(new INTEGER((long)ver));
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        this.version.encode(tag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            INTEGER ver = (INTEGER)INTEGER.getTemplate().decode(implicitTag, istream);
            return new CMSVersion(ver);
        }
    }
}

