/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki;

import th.co.oga.security.pki.CertFileEncodingFormatNotSupportException;

public class CertFileEncodingType {
    private String format = "";
    public static CertFileEncodingType PEM = new CertFileEncodingType("Pem");
    public static CertFileEncodingType DER = new CertFileEncodingType("Der");

    protected CertFileEncodingType(String pform) {
        this.format = pform;
    }

    public static CertFileEncodingType getInstance(String pform) throws CertFileEncodingFormatNotSupportException {
        if (pform.equalsIgnoreCase("pem")) {
            return PEM;
        }
        if (pform.equalsIgnoreCase("der")) {
            return DER;
        }
        throw new CertFileEncodingFormatNotSupportException(pform);
    }

    public boolean is(CertFileEncodingType type) {
        return this.getName().equalsIgnoreCase(type.getName());
    }

    public String getName() {
        return this.format;
    }
}

