/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.pkcs10.CertificationRequestInfo;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Certification.CSRGeneration;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Certification.CertificationRequestException;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.HouseKeeping.AgentProfileNotInitializedException;
import th.co.oga.security.pki.HouseKeeping.CryptoTokenException;
import th.co.oga.security.pki.NameValueInvalidException;
import th.co.oga.security.pki.Operation.SecureStoreOperation;
import th.co.oga.security.pki.X500.DName;

public abstract class CSRGenerator
implements CSRGeneration {
    protected SecureStoreOperation storeMgr = null;
    protected DName subject = null;
    public AlgorithmSupportTable algoTable;
    public AlgorithmSet keyAlgoSet;
    public AlgorithmProfile keyAlgo;
    public AlgorithmSet signatureAlgoSet;
    public AlgorithmProfile signatureAlgo = null;
    protected CertificationRequestInfo certRequestInfo;
    protected AgentProfile profile = null;
    protected KeyPair keyPair = null;
    protected String sn;
    protected int keySize;
    public SET ext = new SET();
    public INTEGER certVersion = new INTEGER((long)CertificateInfo.Version.v3.getNumber());
    protected boolean isInternalKey = true;
    protected int state = 0;
    public final int INIT_STATE = 0;
    public final int BEGIN_STATE = 1;

    protected CSRGenerator(SecureStoreOperation ssm) throws CryptoTokenException {
        this.storeMgr = ssm;
        this.algoTable = ssm.getSupportAlgorithm();
        this.keyAlgoSet = this.algoTable.getKeyPairAlgorithm();
        this.signatureAlgoSet = this.algoTable.getSignatureAlgorithm();
        this.init();
    }

    protected void init() {
        this.certRequestInfo = null;
        this.state = 0;
        this.signatureAlgo = null;
        this.keyPair = null;
        this.keySize = 1024;
        this.ext = new SET();
        this.sn = null;
    }

    protected boolean isBegin() {
        return this.state == 1;
    }

    public void beginWork() throws CertificationRequestException {
        this.state = 1;
    }

    public void rollbackWork() {
    }

    public void commitWork() throws CertificationRequestException {
        this.state = 0;
    }

    public void setSecureAgent(AgentProfile agentProfile) throws CryptoTokenException, AlgorithmSupportException {
        this.profile = agentProfile;
        this.keyAlgo = this.keyAlgoSet.findByOID(this.profile.getKeyPairAlgo());
        this.keySize = this.profile.getKeyPairSize();
    }

    public void setKeySize(int keyLength) throws CertificationRequestException {
        this.keySize = keyLength;
    }

    public void setKeyPairAlgo(AlgorithmProfile alg) {
        this.keyAlgo = alg;
    }

    public void setSignatureAlgo(AlgorithmProfile alg) {
        this.signatureAlgo = alg;
    }

    public void initKeyPairAglorithm(String algoOID) throws AlgorithmSupportException {
        this.setKeyPairAlgo(this.keyAlgoSet.findByOID(algoOID));
    }

    public void initKeyPair(KeyPair keys) {
        this.keyPair = keys;
    }

    public void initSubjectName(DName subj) {
        this.subject = subj;
    }

    public void buildCertificationRequestInfo() throws CertificationRequestException, AgentProfileNotInitializedException {
        if (this.signatureAlgo == null) {
            int pnt = 0;
            int i = 0;
            while (i < this.signatureAlgoSet.size()) {
                AlgorithmProfile ap = (AlgorithmProfile)this.signatureAlgoSet.get(i);
                if (ap.getName().toUpperCase().indexOf(this.keyAlgo.getName().toUpperCase()) > -1) {
                    pnt = i;
                    break;
                }
                ++i;
            }
            this.signatureAlgo = (AlgorithmProfile)this.signatureAlgoSet.get(pnt);
        }
        if (this.profile == null) {
            throw new AgentProfileNotInitializedException();
        }
        DName name = null;
        name = this.subject == null ? this.profile.getDName() : this.subject;
        try {
            if (name.getEmailExtension() != null) {
                this.ext.addElement((ASN1Value)name.getEmailExtension());
            }
            if (name.getStreetAddressExtension() != null) {
                this.ext.addElement((ASN1Value)name.getStreetAddressExtension());
            }
        }
        catch (NameValueInvalidException e) {
            throw new CertificationRequestException("GeneralCertRequestor ", "Name subject fail " + e.toString());
        }
        if (this.keyPair == null) {
            this.isInternalKey = true;
            try {
                KeyPairGenerator kpg = this.storeMgr.getCryptoOperator().getKeyPairGenerator(this.keyAlgo);
                kpg.initialize(this.keySize);
                this.keyPair = kpg.generateKeyPair();
            }
            catch (NoSuchAlgorithmException e) {
                throw new CertificationRequestException(" GeneralCertRequestor ", "KeyPairGenerator fail while generate key pair, " + e.toString());
            }
        } else {
            this.isInternalKey = false;
        }
        try {
            SignatureAlgorithm signAlgo = SignatureAlgorithm.fromOID((OBJECT_IDENTIFIER)new OBJECT_IDENTIFIER(this.signatureAlgo.getOID()));
            this.certRequestInfo = new CertificationRequestInfo(this.certVersion, (Name)name, new SubjectPublicKeyInfo(this.keyPair.getPublic()), this.ext);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificationRequestException(" GeneralCertRequestor ", "Signature Algorithm not support " + e.toString());
        }
        catch (IOException e) {
            throw new CertificationRequestException(" GeneralCertRequestor ", "PublicKeyInfo fail " + e.toString());
        }
        catch (InvalidBERException e) {
            throw new CertificationRequestException(" GeneralCertRequestor ", "PublicKeyInfo fail " + e.toString());
        }
    }

    public abstract CSRProfile genCertRequest() throws CertificationRequestException, AgentProfileNotInitializedException;

    public abstract CSRProfile genCertRequest(String var1) throws CertificationRequestException, AgentProfileNotInitializedException, AlgorithmSupportException;

    public CSRProfile genCertRequest(DName subject) throws CertificationRequestException, AgentProfileNotInitializedException {
        this.initSubjectName(subject);
        return this.genCertRequest();
    }
}

