/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.pkcs10.CertificationRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CSRProfileVerifyException;
import th.co.oga.security.pki.Certification.CertificationReference;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.pki.X500.DName;
import th.co.oga.security.utils.Base64InputStream;
import th.co.oga.security.utils.Base64OutputStream;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class CSRProfile
implements XMLRecord {
    public static String PEM_END_OF_REQUEST = CertificationReference.CSR_END_OF_REQUEST;
    public static String PEM_BEGIN_OF_REQUEST = CertificationReference.CSR_BEGIN_OF_REQUEST;
    public static SimpleDateFormat dateFormater = new SimpleDateFormat("MM/dd/yyyy");
    private String sn = null;
    private String friendlyName = null;
    private byte[] csr = null;
    private String registerDate = "";
    private boolean registered = false;
    private String subject;
    private int export_count = 0;
    private String exportDate = "";
    private String certImportDate;
    private CertificationRequest certRequest;
    public static String PEM = "PEM";
    public static String DER = "DER";

    protected CSRProfile(String sn, byte[] csr, String frName, String regDate, boolean reg) {
        this.sn = sn;
        this.csr = csr;
        this.friendlyName = frName;
        this.registerDate = regDate;
        this.registered = reg;
    }

    private void interplete() {
        try {
            this.certRequest = (CertificationRequest)ASN1Util.decode((ASN1Template)CertificationRequest.getTemplate(), (byte[])this.csr);
            DName name = new DName(this.certRequest.getInfo().getSubject());
            this.subject = name.getSubject();
        }
        catch (InvalidBERException e) {
            this.certRequest = null;
        }
    }

    public CSRProfile(Node node) throws XMLRecordDataException {
        this.setXMLRecord(node);
    }

    public static CSRProfile getNewProfile(String sn, byte[] csr, String frName) {
        return new CSRProfile(sn, csr, frName, Utils.trnDate(), false);
    }

    public static CSRProfile getProfile(String sn, byte[] csrDer, String frName, String regDate) {
        return new CSRProfile(sn, csrDer, frName, regDate, true);
    }

    protected void setCSRFromBase64(String dataStream) throws IOException {
        this.csr = Utils.getBytesFromBase64(dataStream);
    }

    public void exportCSR(String fileName, String format) throws FileNotFoundException, IOException {
        if (format.equalsIgnoreCase("pem")) {
            this.exportCSRToPEMFile(fileName);
        } else if (format.equalsIgnoreCase("der")) {
            this.exportCSRToDERFile(fileName);
        }
        this.setExportCountNext();
    }

    protected void exportCSRToPEMFile(String fileName) throws FileNotFoundException, IOException {
        File pemFile = new File(fileName);
        PrintStream out = new PrintStream(new FileOutputStream(pemFile));
        out.println(PEM_BEGIN_OF_REQUEST);
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        Base64OutputStream b64Out = new Base64OutputStream(new PrintStream(buff), 16);
        b64Out.write(this.csr);
        b64Out.close();
        out.print(buff.toString());
        out.println(PEM_END_OF_REQUEST);
        out.close();
    }

    public void base64Encode(OutputStream out) throws IOException {
        PrintStream writer = new PrintStream(out);
        writer.println(PEM_BEGIN_OF_REQUEST);
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        Base64OutputStream b64Out = new Base64OutputStream(new PrintStream(buff), 16);
        b64Out.write(this.csr);
        b64Out.close();
        writer.print(buff.toString());
        writer.println(PEM_END_OF_REQUEST);
    }

    public void encode(OutputStream out) throws IOException {
        out.write(this.csr);
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.csr);
    }

    protected void exportCSRToDERFile(String fileName) throws FileNotFoundException, IOException {
        File derFile = new File(fileName);
        FileOutputStream out = new FileOutputStream(derFile);
        out.write(this.csr);
        out.close();
    }

    public String getSN() {
        return this.sn;
    }

    public PublicKey getPublicKey() {
        return this.certRequest.getInfo().getSubjectPublicKeyInfo();
    }

    public String getExportDate() {
        return this.exportDate;
    }

    public int getExportCount() {
        return this.export_count;
    }

    public void setExportCountNext() {
        ++this.export_count;
        this.exportDate = dateFormater.format(Calendar.getInstance().getTime());
    }

    public void setCertImport() {
        this.certImportDate = dateFormater.format(Calendar.getInstance().getTime());
    }

    public String getCertImportDate() {
        return this.certImportDate;
    }

    public String getSubjectName() {
        return this.subject;
    }

    public String getIssueDate() {
        return this.registerDate;
    }

    public void updCertImport() {
        this.updCertImport(Calendar.getInstance().getTime());
    }

    public void updCertImport(Date date) {
        boolean req = false;
        if (this.certImportDate == null) {
            req = true;
        } else if (this.certImportDate.length() < 10) {
            req = true;
        }
        if (req) {
            this.certImportDate = dateFormater.format(date);
        }
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean is(String sn) {
        return this.sn.compareTo(sn) == 0;
    }

    public boolean is(PublicKey key) {
        try {
            this.certRequest.verify(key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void verify() throws CSRProfileVerifyException {
        if (this.sn == null) {
            throw new CSRProfileVerifyException("SerialNumber");
        }
        if (this.friendlyName == null) {
            throw new CSRProfileVerifyException("FriendlyName");
        }
        if (this.csr == null) {
            throw new CSRProfileVerifyException("CertificationRequest");
        }
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() <= 0) {
            throw new XMLRecordDataException("CSRProfile", " Empty node was supplied " + node.toString());
        }
        try {
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nv = Utils.nodeValue(nodeList.item(i));
                    String nn = Utils.nodeName(nodeList.item(i));
                    if (nn.equalsIgnoreCase(CryptOGAFormat.CSR_REC_SN)) {
                        this.sn = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CSR_REC_FRNAME)) {
                        this.friendlyName = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CSR_REC_DATE)) {
                        this.registerDate = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CSR_REC_EXPORT_CNT)) {
                        String cnt = nv;
                        Integer integer = new Integer(cnt);
                        this.export_count = integer;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CSR_REC_EXPORT_DATE)) {
                        this.exportDate = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CSR_REC_CERT_IMPORT_DATE)) {
                        this.certImportDate = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CSR_REC_DATA)) {
                        this.setCSRFromBase64(nv);
                    }
                }
                ++i;
            }
            this.interplete();
            this.registered = true;
        }
        catch (Exception e) {
            throw new XMLRecordDataException("CSRProfile", e.toString());
        }
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element parent = doc.createElement(this.getElementName());
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CSR_REC_SN, this.sn));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CSR_REC_FRNAME, this.friendlyName));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CSR_REC_EXPORT_CNT, "" + this.export_count));
        if (this.exportDate != null) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CSR_REC_EXPORT_DATE, this.exportDate));
        }
        if (this.certImportDate != null) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CSR_REC_CERT_IMPORT_DATE, this.certImportDate));
        }
        try {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CSR_REC_DATA, Utils.getBase64FromDER(this.csr)));
        }
        catch (IOException e) {
            throw new XMLNodeConversionException("CertificationRequest", this.getElementName(), e.toString());
        }
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CSR_REC_DATE, this.registerDate));
        return parent;
    }

    public String getParentElementName() {
        return CryptOGAFormat.CSR_PARENT;
    }

    public String getElementName() {
        return CryptOGAFormat.CSR_REC;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        boolean rtn = false;
        CSRProfile csrProfile = new CSRProfile(node);
        rtn = this.is(csrProfile.getSN());
        return rtn;
    }

    public static CSRProfile base64Decode(InputStream in) throws IOException, ASN1Exception {
        int en;
        int b;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((b = in.read()) > -1) {
            buffer.write(b);
        }
        String raw = new String(buffer.toByteArray());
        int bn = raw.indexOf(PEM_BEGIN_OF_REQUEST);
        if (bn > -1) {
            raw = raw.substring(PEM_BEGIN_OF_REQUEST.length() + 2);
        }
        if ((en = raw.indexOf(PEM_END_OF_REQUEST)) > -1) {
            raw = raw.substring(0, en);
        }
        Base64InputStream b64Reader = new Base64InputStream(new ByteArrayInputStream(raw.getBytes()));
        return CSRProfile.decode(b64Reader);
    }

    public static CSRProfile decode(InputStream in) throws IOException, ASN1Exception {
        try {
            CertificationRequest req = (CertificationRequest)CertificationRequest.getTemplate().decode(in);
            String sn = "" + new String(req.getInfo().getSubjectPublicKeyInfo().getEncoded()).hashCode();
            DName name = new DName(req.getInfo().getSubject());
            return CSRProfile.getNewProfile(sn, ASN1Util.encode((ASN1Value)req), name.getFriendlyName());
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception((Exception)((Object)e));
        }
    }
}

