/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs10.CertificationRequestInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class CSRSignification
implements ASN1Value {
    private SEQUENCE sequence;
    private byte[] infoEncoding;
    private byte[] signature;
    private AlgorithmIdentifier algorithmIdentifier;
    private CertificationRequestInfo certInfo;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public CSRSignification(CertificationRequestInfo certInfo) {
        this.certInfo = certInfo;
    }

    public CSRSignification(CertificationRequestInfo info, AlgorithmIdentifier algorithmID, byte[] signature) {
        this.certInfo = info;
        this.algorithmIdentifier = algorithmID;
        this.signature = signature;
        this.pack();
    }

    public void sign(Signature signer, PrivateKey key, String algorithmOID) throws InvalidKeyException, SignatureException {
        signer.initSign(key);
        this.infoEncoding = ASN1Util.encode((ASN1Value)this.certInfo);
        signer.update(this.infoEncoding);
        this.signature = signer.sign();
        this.algorithmIdentifier = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(algorithmOID));
        this.pack();
    }

    private void pack() {
        this.sequence = new SEQUENCE();
        this.sequence.addElement((ASN1Value)this.certInfo);
        this.sequence.addElement((ASN1Value)this.algorithmIdentifier);
        this.sequence.addElement((ASN1Value)new BIT_STRING(this.signature, 0));
    }

    public void verify(Signature signer, PublicKey key) throws InvalidKeyException, SignatureException {
        signer.initVerify(key);
        signer.update(this.infoEncoding);
        if (!signer.verify(this.signature)) {
            throw new SignatureException("Signature is invalid");
        }
    }

    public CertificationRequestInfo getInfo() {
        return this.certInfo;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)CertificationRequestInfo.getTemplate());
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            CertificationRequestInfo info = (CertificationRequestInfo)seq.elementAt(0);
            BIT_STRING bs = (BIT_STRING)seq.elementAt(2);
            if (bs.getPadCount() != 0) {
                throw new InvalidBERException("signature does not fall into an integral number of bytes");
            }
            byte[] signature = bs.getBits();
            return new CSRSignification(info, (AlgorithmIdentifier)seq.elementAt(1), signature);
        }
    }
}

