/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.pkcs11.PK11Store;
import th.co.oga.security.pki.Certification.CertChainException;
import th.co.oga.security.pki.Certification.CertPackage;
import th.co.oga.security.pki.Certification.CertPackageEncodingFormat;
import th.co.oga.security.pki.Certification.CertPackageEncodingFormatNotSupportException;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertPackageType;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Utils;

public class CertChain
implements CertPackage {
    public static final String ENCODING_NAME_PKCS7 = "PKCS7";
    public static final String ENCODING_NAME_PKIPATH = "PkiPath";
    private CertPackageType type = CertPackageType.P7;
    private CertPath certChain = null;
    private CertificateFactory certFactory = CertificateFactory.getInstance("X.509");

    public CertChain() throws CertificateException {
    }

    public CertChain(File inputFile, CertPackageEncodingFormat format) throws IOException, CertificateException, CertPackageException {
        this();
        FileInputStream in = new FileInputStream(inputFile);
        this.fromInputStream(in, format);
        in.close();
    }

    public void importFromFile(File importFile, List opt) throws FileNotFoundException, CertPackageEncodingFormatNotSupportException, IOException, CertPackageException {
        CertPackageEncodingFormat format = CertPackageEncodingFormat.getInstance(Utils.getExtension(importFile));
        FileInputStream in = new FileInputStream(importFile);
        this.fromInputStream(in, format);
        in.close();
    }

    public void importFromStream(byte[] stream, CertPackageEncodingFormat format) throws CertPackageException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(stream);
        this.fromInputStream(in, format);
        in.close();
    }

    public CertPath getChain() {
        return this.certChain;
    }

    private void fromInputStream(InputStream in, CertPackageEncodingFormat format) throws CertPackageException {
        Iterator<String> iterator = this.certFactory.getCertPathEncodings();
        try {
            BufferedInputStream bf = new BufferedInputStream(in);
            this.certChain = this.certFactory.generateCertPath(bf, format.getName());
            bf.close();
        }
        catch (Exception e) {
            throw new CertChainException(e.toString());
        }
    }

    public void addCert(X509Certificate cer) throws CertificateException {
        List<? extends Certificate> list;
        if (this.certChain == null) {
            ArrayList<? extends Certificate> aList = new ArrayList<Certificate>();
            list = aList;
        } else {
            list = this.certChain.getCertificates();
        }
        list.add(cer);
        this.certChain = this.certFactory.generateCertPath(list);
    }

    public void addCert(X509Certificate[] cers) throws CertificateException {
        List<? extends Certificate> list;
        if (this.certChain == null) {
            ArrayList<? extends Certificate> aList = new ArrayList<Certificate>();
            list = aList;
        } else {
            list = this.certChain.getCertificates();
        }
        int i = 0;
        while (i < cers.length) {
            list.add(cers[i]);
            ++i;
        }
        this.certChain = this.certFactory.generateCertPath(list);
    }

    public String toString() {
        try {
            return this.certChain.toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public byte[] getBytes() throws CertPackageException {
        try {
            return this.certChain.getEncoded(ENCODING_NAME_PKCS7);
        }
        catch (CertificateEncodingException e) {
            throw new CertChainException(e.toString());
        }
    }

    public byte[] getBytes(String encodingName) throws CertPackageException {
        try {
            return this.certChain.getEncoded(encodingName);
        }
        catch (CertificateEncodingException e) {
            throw new CertChainException(e.toString());
        }
    }

    public X509Certificate[] getX509Certs() {
        List<? extends Certificate> certList = this.certChain.getCertificates();
        X509Certificate[] certs = new X509Certificate[certList.size()];
        int i = 0;
        while (i < certList.size()) {
            certs[i] = (X509Certificate)certList.get(i);
            ++i;
        }
        return certs;
    }

    public CertProfile[] getCerts() {
        List<? extends Certificate> certList = this.certChain.getCertificates();
        CertProfile[] certs = new CertProfile[certList.size()];
        int i = 0;
        while (i < certList.size()) {
            certs[i] = new CertProfile((X509Certificate)certList.get(i));
            ++i;
        }
        return certs;
    }

    public String getFriendlyName() throws CertChainException {
        String rtn = null;
        try {
            List<? extends Certificate> certs = this.certChain.getCertificates();
            int i = 0;
            while (i < certs.size()) {
                X509Certificate cert = (X509Certificate)certs.get(i);
                if (cert != null && !cert.getIssuerDN().getName().equalsIgnoreCase(cert.getSubjectDN().getName())) {
                    rtn = Utils.getFriendlyName(cert);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new CertChainException(e.toString());
        }
        return rtn;
    }

    public Iterator getContent() {
        return this.certChain.getCertificates().iterator();
    }

    public CertPackageType getType() {
        return this.type;
    }

    public int getCertNumber() {
        return this.certChain.getCertificates().size();
    }

    public void addEntryContent(CryptoManager mgr, PK11Store ksStore) throws CertPackageException {
        throw new CertChainException("Not support this functionality ");
    }
}

