/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.Extension.CertExtensionBasicConstraints;
import th.co.oga.security.pki.Certification.Extension.CertExtensionCRLDP;
import th.co.oga.security.pki.Certification.Extension.CertExtensionCertPolicies;
import th.co.oga.security.pki.Certification.Extension.CertExtensionKeyPurepose;
import th.co.oga.security.pki.Certification.Extension.SubjectKeyIdentifier;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.ObjectNotFoundException;

public class CertExtension
implements ASN1Value {
    private OBJECT_IDENTIFIER extnId;
    private boolean critical;
    private OCTET_STRING extnValue;
    private CertificateExtensionProfile ce;
    private CertificateExtensions ces = new CertificateExtensions();
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    protected CertExtension(String oid, boolean critical, byte[] value) throws ASN1Exception {
        if (value == null) {
            throw new IllegalArgumentException("The Associate byte array of extension is null");
        }
        try {
            this.extnId = new OBJECT_IDENTIFIER(oid);
            this.critical = critical;
            this.extnValue = (OCTET_STRING)ASN1Util.decode((ASN1Template)OCTET_STRING.getTemplate(), (byte[])value);
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception(e.getMessage());
        }
        try {
            this.ce = this.ces.findOID(oid);
        }
        catch (ObjectNotFoundException e) {
            this.ce = new CertificateExtensionProfile("Unknow Extension{" + oid + "}", oid);
        }
    }

    protected CertExtension(OBJECT_IDENTIFIER extnId, boolean critical, OCTET_STRING extnValue) {
        this.extnId = extnId;
        this.critical = critical;
        this.extnValue = extnValue;
        try {
            this.ce = this.ces.findOID(this.getOID());
        }
        catch (ObjectNotFoundException e) {
            this.ce = new CertificateExtensionProfile("Unknow Extension{" + this.getOID() + "}", this.getOID());
        }
    }

    private CertExtension() {
    }

    protected OBJECT_IDENTIFIER getExtnId() {
        return this.extnId;
    }

    protected boolean getCritical() {
        return this.critical;
    }

    protected OCTET_STRING getExtnValue() {
        return this.extnValue;
    }

    public byte[] getValue() {
        return this.extnValue.toByteArray();
    }

    public String getData() throws ASN1Exception {
        return String.valueOf(this.ce.getName()) + " = " + new String(this.extnValue.toByteArray());
    }

    public String getCEName() {
        return this.ce.getName();
    }

    public String getOID() {
        return OIDs.fromLongs(this.extnId.getNumbers());
    }

    public static CertExtension getInstance(String oid, boolean critical, byte[] bytes) throws ASN1Exception {
        if (CertExtensionBasicConstraints.isMe(oid)) {
            return CertExtensionBasicConstraints.getInstance(bytes);
        }
        if (CertExtensionCRLDP.isMe(oid)) {
            return new CertExtensionCRLDP(bytes);
        }
        if (CertExtensionCertPolicies.isMe(oid)) {
            return new CertExtensionCertPolicies(bytes);
        }
        if (CertExtensionKeyPurepose.isMe(oid)) {
            return new CertExtensionKeyPurepose(bytes);
        }
        if (SubjectKeyIdentifier.isMe(oid)) {
            return new SubjectKeyIdentifier(bytes);
        }
        return new CertExtension(oid, critical, bytes);
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.extnId);
        if (this.critical) {
            seq.addElement((ASN1Value)new BOOLEAN(true));
        }
        seq.addElement((ASN1Value)this.extnValue);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement((ASN1Template)BOOLEAN.getTemplate(), (ASN1Value)new BOOLEAN(false));
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new CertExtension((OBJECT_IDENTIFIER)seq.elementAt(0), ((BOOLEAN)seq.elementAt(1)).toBoolean(), (OCTET_STRING)seq.elementAt(2));
        }
    }

    public static class CertificateExtensionProfile {
        private String oid;
        private String name;

        CertificateExtensionProfile(String name, String oid) {
            this.oid = oid;
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        public static CertificateExtensionProfile getInstance(String name, String oid) {
            return new CertificateExtensionProfile(name, oid);
        }
    }

    public class CertificateExtensions
    extends ArrayList {
        private ArrayList idx = new ArrayList();

        public CertificateExtensions() {
            this.addCE("Subject Directory Attributes", "2.5.29.9");
            this.addCE("Subject Key Identifier", "2.5.29.14");
            this.addCE("Key Usages", "2.5.29.15");
            this.addCE("Private Key Usage Period", "2.5.29.16");
            this.addCE("Subject Alternative Name", "2.5.29.17");
            this.addCE("Issuer Alternative Name", "2.5.29.18");
            this.addCE("Basic Constraints", "2.5.29.19");
            this.addCE("CRL Number", "2.5.29.20");
            this.addCE("CRL Reason", "2.5.29.21");
            this.addCE("Hold Instruction Code", "2.5.29.23");
            this.addCE("Invalidity Date", "2.5.29.24");
            this.addCE("CRL Distribution Point ID", "2.5.29.25");
            this.addCE("Delta CRL Indicator", "2.5.29.27");
            this.addCE("Issuing Distribution Point", "2.5.29.28");
            this.addCE("Certificate Issuer", "2.5.29.29");
            this.addCE("Name Constraints", "2.5.29.30");
            this.addCE("CRL Distribution Points", "2.5.29.31");
            this.addCE("Certificate Policies", "2.5.29.32");
            this.addCE("Policy Mappings", "2.5.29.33");
            this.addCE("Authority Key Identifier", "2.5.29.35");
            this.addCE("Policy Constraints", "2.5.29.36");
            this.addCE("Ext Key Usage Syntax", "2.5.29.37");
        }

        void addCE(String name, String oid) {
            this.idx.add(oid);
            this.add(new CertificateExtensionProfile(name, oid));
        }

        CertificateExtensionProfile findOID(String oid) throws ObjectNotFoundException {
            if (this.idx.indexOf(oid) > -1) {
                return (CertificateExtensionProfile)this.get(this.idx.indexOf(oid));
            }
            throw new ObjectNotFoundException("CertificateExtension oid[" + oid + "]");
        }
    }
}

