/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.util.Base64InputStream;
import th.co.oga.security.pki.CertFileEncodingType;
import th.co.oga.security.pki.Certification.CertificationReference;
import th.co.oga.security.pki.NameValueInvalidException;
import th.co.oga.security.pki.X500.DName;
import th.co.oga.security.pki.X500.DNameReference;

public class CertFile {
    private Certificate cert;
    private String PEM_BEGIN_BOUNDERY = CertificationReference.CERT_BEGIN;
    private String PEM_END_BOUNDERY = CertificationReference.CERT_END;

    public CertFile(File inputFile, CertFileEncodingType format) throws IOException, InvalidBERException {
        if (format.is(CertFileEncodingType.DER)) {
            this.fromDER(inputFile);
        }
        if (format.is(CertFileEncodingType.PEM)) {
            this.fromPEM(inputFile);
        }
    }

    public CertFile(X509Certificate xCert) throws InvalidBERException, IOException, CertificateEncodingException {
        ByteArrayInputStream in = new ByteArrayInputStream(xCert.getEncoded());
        this.cert = (Certificate)Certificate.getTemplate().decode((InputStream)in);
        in.close();
    }

    public void fromPEM(File importFile) throws FileNotFoundException, IOException, InvalidBERException {
        int c;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedReader br = new BufferedReader(new FileReader(importFile));
        String str = "";
        String line = "";
        while ((line = br.readLine()) != null) {
            if (line.indexOf(this.PEM_BEGIN_BOUNDERY) > -1 || line.indexOf(this.PEM_END_BOUNDERY) > -1) continue;
            str = String.valueOf(str) + line + "\r\n";
        }
        br.close();
        Base64InputStream in = new Base64InputStream((InputStream)new ByteArrayInputStream(str.getBytes()));
        while ((c = in.read()) > -1) {
            out.write(c);
        }
        in.close();
        this.cert = (Certificate)Certificate.getTemplate().decode((InputStream)new ByteArrayInputStream(out.toByteArray()));
    }

    public void fromDER(File importFile) throws FileNotFoundException, IOException, InvalidBERException {
        BufferedInputStream bf = new BufferedInputStream(new FileInputStream(importFile));
        this.cert = (Certificate)Certificate.getTemplate().decode((InputStream)bf);
        bf.close();
    }

    public String toString() {
        try {
            return this.cert.getInfo().getIssuer().getRFC1485();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.cert.encode((OutputStream)out);
        byte[] bs = out.toByteArray();
        return bs;
    }

    public String getFriendlyName() throws InvalidBERException, NameValueInvalidException {
        String issuer = new String(new DName(this.cert.getInfo().getIssuer()).getValue(DNameReference.COMMON_OID));
        String owner = new String(new DName(this.cert.getInfo().getSubject()).getValue(DNameReference.COMMON_OID));
        return String.valueOf(owner) + " - " + issuer;
    }
}

