/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.Certification.CertProfileNotFoundInListException;
import th.co.oga.security.pki.Certification.InternalCertProfile;

public class CertList
extends HashMap {
    public static KeyWord REF_KEY_NAME = new KeyWord("CertMappingRefNo");
    public static KeyWord IDX_ISSUER_AND_SN = new KeyWord("IssuerAndSerialNumber");
    public static KeyWord IDX_CN = new KeyWord("CommandName");
    public static KeyWord IDX_EMAIL = new KeyWord("emailAddress");
    public static KeyWord IDX_SUBJECT_NAME = new KeyWord("SubjectName");
    public static String SEPPARATOR = "#E21EUW#";
    private List idx = new ArrayList();
    private List certs = new ArrayList();

    public CertList(int initialCapacity) {
        super(initialCapacity);
    }

    public CertList() {
    }

    public void setCertMapping(String refNo, InternalCertProfile cert) throws CertProfileException {
        this.setCertEntry(cert, null, refNo);
    }

    public void setCertMapping(KeyWord refName, String refNo, InternalCertProfile cert) throws CertProfileException {
        this.setCertEntry(cert, refName, refNo);
    }

    public void setCert(InternalCertProfile cert) throws CertProfileException {
        this.setCert(cert, null);
    }

    public void setCert(InternalCertProfile cert, String refValue) throws CertProfileException {
        try {
            String issuerSubjectName = cert.getX509Cert().getIssuerX500Principal().getName();
            String sn = cert.getSerialNumber().toString();
            this.setCertEntry(cert, IDX_ISSUER_AND_SN, String.valueOf(issuerSubjectName) + sn);
            String cn = cert.getSubjectDN().getCommonName();
            this.setCertEntry(cert, IDX_CN, cn);
            String email = cert.getSubjectDN().getEMailAddress();
            if (email != null) {
                this.setCertEntry(cert, IDX_EMAIL, email);
            }
        }
        catch (ASN1Exception e) {
            throw new CertProfileException(e.getMessage());
        }
        String subj = cert.getX509Cert().getSubjectX500Principal().getName();
        this.setCertEntry(cert, IDX_SUBJECT_NAME, subj);
        if (refValue != null) {
            this.setCertEntry(cert, null, refValue);
        }
    }

    public InternalCertProfile getCert(CertProfile cp) {
        String sn = String.valueOf(cp.getX509Cert().getIssuerX500Principal().getName()) + cp.getSerialNumber().toString();
        int pnt = this.idx.indexOf(sn);
        if (pnt > -1) {
            return (InternalCertProfile)this.certs.get(pnt);
        }
        return null;
    }

    public List getList() {
        return this.certs;
    }

    public void removeAll() {
        this.idx.clear();
        this.certs.clear();
        this.clear();
    }

    public Iterator getIterator() {
        return this.certs.iterator();
    }

    private void setCertEntry(CertProfile cert, KeyWord refName, String refValue) {
        this.put(this.getRefNo(refName, refValue), cert);
        String sn = String.valueOf(cert.getX509Cert().getIssuerX500Principal().getName()) + cert.getSerialNumber().toString();
        if (this.idx.indexOf(sn) < 0) {
            this.idx.add(sn);
            this.certs.add(cert);
        }
    }

    private String getRefNo(KeyWord refName, String refValue) {
        if (refName == null) {
            return String.valueOf(REF_KEY_NAME.getName()) + SEPPARATOR + refValue;
        }
        return String.valueOf(refName.getName()) + SEPPARATOR + refValue;
    }

    public CertProfile getCertByEMail(String email) throws CertProfileNotFoundInListException {
        return this.getCertEntry(IDX_EMAIL, email);
    }

    public CertProfile getCertBySubjectName(String value) throws CertProfileNotFoundInListException {
        return this.getCertEntry(IDX_SUBJECT_NAME, value);
    }

    public CertProfile getCertByCN(String value) throws CertProfileNotFoundInListException {
        return this.getCertEntry(IDX_CN, value);
    }

    public CertProfile getCertByIssuerAndSerialNumber(String value) throws CertProfileNotFoundInListException {
        return this.getCertEntry(IDX_ISSUER_AND_SN, value);
    }

    public CertProfile getCertByRefNo(String refNo) throws CertProfileNotFoundInListException {
        return this.getCertEntry(null, refNo);
    }

    public CertProfile getCertByRefNo(KeyWord refName, String refNo) throws CertProfileNotFoundInListException {
        return this.getCertEntry(refName, refNo);
    }

    private CertProfile getCertEntry(KeyWord key, String value) throws CertProfileNotFoundInListException {
        CertProfile cert = (CertProfile)this.get(this.getRefNo(key, value));
        if (cert == null) {
            throw new CertProfileNotFoundInListException(this.getRefNo(key, value));
        }
        return cert;
    }

    public int getLength() {
        return this.idx.size();
    }

    public Object put(Object key, Object value) {
        if (value instanceof CertProfile) {
            return super.put(key, value);
        }
        throw new IllegalArgumentException("This operation can store only Certificate profile.");
    }

    public static class KeyWord {
        String name = "";

        public KeyWord(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

