/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.io.File;
import th.co.oga.security.pki.Certification.CertPackageEncodingFormatNotSupportException;
import th.co.oga.security.pki.Utils;

public class CertPackageEncodingFormat {
    private String format = "";
    public static CertPackageEncodingFormat PEM = new CertPackageEncodingFormat("BASE64");
    public static CertPackageEncodingFormat BER = new CertPackageEncodingFormat("BER");
    public static CertPackageEncodingFormat P7 = new CertPackageEncodingFormat("PKCS7");
    public static CertPackageEncodingFormat P7B = new CertPackageEncodingFormat("PkiPath");

    protected CertPackageEncodingFormat(String pform) {
        this.format = pform;
    }

    public static CertPackageEncodingFormat getInstance(File file) throws CertPackageEncodingFormatNotSupportException {
        String ext;
        if (file.isFile() && (ext = Utils.getExtension(file)) != null) {
            return CertPackageEncodingFormat.getInstance(ext);
        }
        throw new CertPackageEncodingFormatNotSupportException(file.getName());
    }

    public static CertPackageEncodingFormat getInstance(String pform) throws CertPackageEncodingFormatNotSupportException {
        if ("PEM".indexOf(pform.toUpperCase()) > -1) {
            return PEM;
        }
        if ("BER,CER,DER,P12,PFX,CRT".indexOf(pform.toUpperCase()) > -1) {
            return BER;
        }
        if ("P7,P7C,P7B".indexOf(pform.toUpperCase()) > -1) {
            return P7;
        }
        if ("P7E".indexOf(pform.toUpperCase()) > -1) {
            return P7B;
        }
        throw new CertPackageEncodingFormatNotSupportException(pform);
    }

    public boolean is(CertPackageEncodingFormat type) {
        return this.getName().equalsIgnoreCase(type.getName());
    }

    public String getName() {
        return this.format;
    }

    public String[] getAllFormat() {
        return new String[]{BER.getName(), PEM.getName()};
    }
}

