/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.io.FileFilter;
import th.co.oga.security.pki.Certification.CertFileFilter;
import th.co.oga.security.pki.Certification.CertPackageTypeNotSupportException;

public class CertPackageType {
    private String name = "";
    public static CertPackageType P7 = new CertPackageType("CertificateChain");
    public static CertPackageType P12 = new CertPackageType("SaveBag");
    public static CertPackageType CERTIFICATE = new CertPackageType("Certificate");

    protected CertPackageType(String cname) {
        this.name = cname;
    }

    public static CertPackageType getInstance(String pname) throws CertPackageTypeNotSupportException {
        if ("P7,P7B,P7C".indexOf(pname.toUpperCase()) > -1) {
            return P7;
        }
        if ("P12,PFX".indexOf(pname.toUpperCase()) > -1) {
            return P12;
        }
        if ("CER,DER,BER,PEM,CRT".indexOf(pname.toUpperCase()) > -1) {
            return CERTIFICATE;
        }
        throw new CertPackageTypeNotSupportException(pname);
    }

    public boolean is(CertPackageType type) {
        return this.getName().equalsIgnoreCase(type.getName());
    }

    public String getName() {
        return this.name;
    }

    public static String[] getAllTypeName() {
        return new String[]{CERTIFICATE.getName(), P7.getName(), P12.getName()};
    }

    public static CertPackageType[] getAllTypes() {
        return new CertPackageType[]{CERTIFICATE, P7, P12};
    }

    public static FileFilter getFileFilter() {
        return (FileFilter)((Object)new CertFileFilter());
    }
}

