/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.URL;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertExtension;
import th.co.oga.security.pki.Certification.CertPackage;
import th.co.oga.security.pki.Certification.CertPackageEncodingFormat;
import th.co.oga.security.pki.Certification.CertPackageEncodingFormatNotSupportException;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertPackageType;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.Certification.Extension.CertExtensionBasicConstraints;
import th.co.oga.security.pki.Certification.Extension.CertExtensionCRLDP;
import th.co.oga.security.pki.Certification.Extension.CertExtensionCertPolicies;
import th.co.oga.security.pki.Certification.Extension.SubjectKeyIdentifier;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.Transport.TransportPackageEncodingFailException;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.pki.X500.DName;
import th.co.oga.security.pki.x.KeyUsages;

public class CertProfile
implements CertPackage {
    public static final String CE_CRL_DISTRIBUTION_POINT = OIDs.ceCRLDistributionPoints;
    public static final String CE_CERTIFICATE_POLICIES = OIDs.ceCertificatePolicies;
    public static final String CE_BESIC_CONSTRAINS = OIDs.ceBasicConstraints;
    public static final String CE_KEY_PUREPOSE = OIDs.ceExtKeyUsageSyntax;
    public static final String CE_SUBJECT_KEY_IDENTIFIER = OIDs.ceSubjectKeyIdentifier;
    private CertPackageType type = CertPackageType.CERTIFICATE;
    private X509Certificate cert = null;
    private CertificateFactory certFactory;

    public CertProfile() throws CertificateException {
        this.certFactory = CertificateFactory.getInstance("X509");
    }

    public CertProfile(X509Certificate xCert) {
        this.cert = xCert;
    }

    public CertProfile(Certificate cer) {
        this.cert = (X509Certificate)cer;
    }

    public String getAuthorityName() throws ASN1Exception {
        if (this.isCA()) {
            return this.cert.getSubjectX500Principal().getName();
        }
        return this.cert.getIssuerX500Principal().getName();
    }

    public CertProfile(File inputFile, CertPackageEncodingFormat format) throws IOException, CertificateException, CertProfileException {
        this();
        FileInputStream in = new FileInputStream(inputFile);
        this.fromInputStream(in);
        in.close();
    }

    public void encode(OutputStream out) throws IOException {
        try {
            out.write(this.cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new TransportPackageEncodingFailException(e);
        }
    }

    public DName getIssuerDN() throws ASN1Exception {
        return DName.getInstance(this.cert.getIssuerX500Principal());
    }

    public String[] getSubjectNames() {
        String subjStr = this.cert.getSubjectX500Principal().toString();
        return subjStr.split(", ");
    }

    public String[] getIssuerNames() {
        String subjStr = this.cert.getIssuerX500Principal().toString();
        return subjStr.split(", ");
    }

    public DName getSubjectDN() throws ASN1Exception {
        return DName.getInstance(this.cert.getSubjectX500Principal());
    }

    public BigInteger getSerialNumber() {
        return this.cert.getSerialNumber();
    }

    public String getUsages() {
        return this.getKeyUsages().getUsagesString();
    }

    public Date getIssueDate() {
        return this.cert.getNotBefore();
    }

    public Date getExpireDate() {
        return this.cert.getNotAfter();
    }

    public KeyUsages getKeyUsages() {
        return new KeyUsages(this.cert.getKeyUsage());
    }

    public URL getCRLDistributionPointURL() throws ASN1Exception {
        byte[] extValue = this.cert.getExtensionValue(CE_CRL_DISTRIBUTION_POINT);
        if (extValue == null) {
            return null;
        }
        CertExtensionCRLDP ext = (CertExtensionCRLDP)CertExtension.getInstance(CE_CRL_DISTRIBUTION_POINT, false, extValue);
        return ext.getURL();
    }

    public boolean isCA() throws ASN1Exception {
        byte[] extValue = this.cert.getExtensionValue(CE_BESIC_CONSTRAINS);
        if (extValue == null) {
            return this.cert.getVersion() == 1 && this.cert.getSubjectDN().equals(this.cert.getIssuerDN());
        }
        CertExtensionBasicConstraints ext = (CertExtensionBasicConstraints)CertExtension.getInstance(CE_BESIC_CONSTRAINS, false, extValue);
        return ext.getIsCA();
    }

    public URL getCPSURL() throws ASN1Exception {
        byte[] extValue = this.cert.getExtensionValue(CE_CERTIFICATE_POLICIES);
        if (extValue == null) {
            return null;
        }
        CertExtensionCertPolicies ext = (CertExtensionCertPolicies)CertExtension.getInstance(CE_CERTIFICATE_POLICIES, true, extValue);
        return ext.getURL();
    }

    public String getPolicyID() throws ASN1Exception {
        byte[] extValue = this.cert.getExtensionValue(CE_CERTIFICATE_POLICIES);
        if (extValue == null) {
            return null;
        }
        CertExtensionCertPolicies ext = (CertExtensionCertPolicies)CertExtension.getInstance(CE_CERTIFICATE_POLICIES, true, extValue);
        return ext.getPolicyID();
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() throws ASN1Exception {
        byte[] extValue = this.cert.getExtensionValue(CE_SUBJECT_KEY_IDENTIFIER);
        if (extValue == null) {
            return null;
        }
        SubjectKeyIdentifier ext = (SubjectKeyIdentifier)CertExtension.getInstance(CE_SUBJECT_KEY_IDENTIFIER, true, extValue);
        return ext;
    }

    public String brows() throws IOException, ASN1Exception {
        StringWriter rtn = new StringWriter();
        rtn.write("Critical Extensions raw data\r\n");
        for (String oid : this.cert.getCriticalExtensionOIDs()) {
            CertExtension ext = new CertExtension(oid, true, this.cert.getExtensionValue(oid));
            if (ext == null) continue;
            rtn.write("\t" + ext.getCEName() + "[" + ext.getOID() + "]" + "\r\n");
        }
        rtn.write("Non Critical Extensions \r\n");
        for (String oid : this.cert.getNonCriticalExtensionOIDs()) {
            CertExtension ext = new CertExtension(oid, false, this.cert.getExtensionValue(oid));
            if (ext == null) continue;
            rtn.write("\t" + ext.getCEName() + "[" + ext.getOID() + "]" + "\r\n");
        }
        rtn.write("Certificate Extension Informations \r\n");
        rtn.write("\tCA Status:" + (this.isCA() ? "CA Certificate " : "Not CA Cert ") + "\r\n");
        URL url = this.getCRLDistributionPointURL();
        rtn.write("\tCRL DistributionPoint URL: " + (url == null ? " Not Associated ... " : url.toString()) + "\r\n");
        URL cpsUrl = this.getCPSURL();
        rtn.write("\tCPS URL: " + (cpsUrl == null ? " Not Associated ... " : cpsUrl.toString()) + "\r\n");
        return rtn.toString();
    }

    public byte[] getBytes() throws CertPackageException {
        try {
            return this.cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new CertProfileException(e.toString());
        }
    }

    public X509Certificate[] getX509Certs() {
        X509Certificate[] certs = new X509Certificate[]{this.cert};
        return certs;
    }

    public PublicKey getPublicKey() {
        if (this.cert == null) {
            return null;
        }
        return this.cert.getPublicKey();
    }

    public Iterator getContent() {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(this.cert);
        return certs.iterator();
    }

    public String getFriendlyName() throws CertPackageException {
        return Utils.getFriendlyName(this.cert);
    }

    public CertPackageType getType() {
        return this.type;
    }

    public String toString() {
        try {
            return this.cert.toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public static CertProfile getInstance(byte[] bytes) throws CertProfileException, IOException, CertificateException {
        CertProfile cp = new CertProfile();
        cp.importFromStream(bytes, CertPackageEncodingFormat.BER);
        return cp;
    }

    public static CertProfile decode(InputStream in) throws CertificateException, IOException {
        CertProfile cp = new CertProfile();
        cp.fromInputStream(in);
        return cp;
    }

    public void importFromStream(byte[] stream, CertPackageEncodingFormat format) throws CertProfileException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(stream);
        try {
            this.fromInputStream(in);
        }
        catch (CertificateException e) {
            throw new CertProfileException(e.getMessage());
        }
        in.close();
    }

    public void importFromFile(File importFile, List opt) throws FileNotFoundException, CertPackageEncodingFormatNotSupportException, IOException, CertPackageException {
        CertPackageEncodingFormat format = CertPackageEncodingFormat.getInstance(Utils.getExtension(importFile));
        FileInputStream in = new FileInputStream(importFile);
        try {
            this.fromInputStream(in);
        }
        catch (CertificateException e) {
            throw new CertPackageException("CertProfile ", e.getMessage());
        }
        in.close();
    }

    public X509Certificate getX509Cert() {
        return this.cert;
    }

    public boolean isSubject(X500Principal subj) {
        return this.cert.getSubjectX500Principal().equals(subj);
    }

    private void fromInputStream(InputStream in) throws IOException, CertificateException {
        BufferedInputStream bf = new BufferedInputStream(in);
        this.cert = (X509Certificate)this.certFactory.generateCertificate(bf);
        bf.close();
    }
}

