/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.ASN1Exception;

public class BasicConstraints
implements ASN1Value {
    protected boolean isCA;
    protected int pathLenConstraint;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected BasicConstraints(boolean CA, int pathLenConstraint) {
        this.isCA = CA;
        this.pathLenConstraint = pathLenConstraint;
    }

    public static BasicConstraints getInstance(byte[] bytes) throws ASN1Exception {
        try {
            OCTET_STRING value = (OCTET_STRING)OCTET_STRING.getTemplate().decode((InputStream)new ByteArrayInputStream(bytes));
            return (BasicConstraints)ASN1Util.decode((ASN1Template)BasicConstraints.getTemplate(), (byte[])value.toByteArray());
        }
        catch (Exception e) {
            throw new ASN1Exception(e.toString());
        }
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encode(out);
        OCTET_STRING value = new OCTET_STRING(out.toByteArray());
        return ASN1Util.encode((ASN1Value)value);
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)new BOOLEAN(this.isCA));
        if (this.pathLenConstraint > 0) {
            seq.addElement((ASN1Value)new INTEGER((long)this.pathLenConstraint));
        }
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)BOOLEAN.getTemplate(), (ASN1Value)new BOOLEAN(false));
            this.seqt.addOptionalElement(INTEGER.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            int len = 0;
            if (seq.elementAt(1) != null) {
                len = ((INTEGER)seq.elementAt(1)).intValue();
            }
            return new BasicConstraints(((BOOLEAN)seq.elementAt(0)).toBoolean(), len);
        }
    }
}

