/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Certification.Extension.AdministrationDomainName;
import th.co.oga.security.pki.Certification.Extension.CountryName;
import th.co.oga.security.pki.Certification.Extension.ExtendedNetworkAddress;
import th.co.oga.security.pki.Certification.Extension.NumericString;
import th.co.oga.security.pki.Certification.Extension.OrganizationalUnitNames;
import th.co.oga.security.pki.Certification.Extension.PersonalName;
import th.co.oga.security.pki.x.DomainName;

public class BuiltInStandardAttributes
implements ASN1Value {
    private CountryName cn;
    private AdministrationDomainName adn;
    private ExtendedNetworkAddress netAddr;
    private PrintableString terminalID;
    private DomainName pdn;
    private PrintableString orgName;
    private NumericString nui;
    private PersonalName pn;
    private OrganizationalUnitNames ouns;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    BuiltInStandardAttributes(SEQUENCE seq) {
        this.cn = (CountryName)seq.elementAt(0);
        this.adn = (AdministrationDomainName)seq.elementAt(1);
        this.netAddr = (ExtendedNetworkAddress)seq.elementAt(2);
        this.terminalID = (PrintableString)seq.elementAt(3);
        this.pdn = (DomainName)seq.elementAt(4);
        this.orgName = (PrintableString)seq.elementAt(5);
        this.nui = (NumericString)seq.elementAt(6);
        this.pn = (PersonalName)seq.elementAt(7);
        this.ouns = (OrganizationalUnitNames)seq.elementAt(8);
    }

    public String getData() throws InvalidBERException {
        return String.valueOf(this.cn == null ? "" : "CountryName=" + this.cn.getData()) + (this.adn == null ? "" : "AdministrationDomainName=" + this.adn.getData()) + (this.netAddr == null ? "" : "NetworkAddress=" + this.netAddr.getData()) + (this.terminalID == null ? "" : "TerminalIdentifier=" + this.terminalID.toString()) + (this.pdn == null ? "" : "PrivateDomainName=" + this.pdn.getData()) + (this.orgName == null ? "" : "OrganizationName=" + this.orgName.toString()) + (this.nui == null ? "" : "NumericUserIdentifier=" + this.nui.getData()) + (this.pn == null ? "" : "PersonalName=" + this.pn.getData()) + (this.ouns == null ? "" : "OrganizationalUnitNames=" + this.ouns.getData());
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.cn);
        seq.addElement((ASN1Value)this.adn);
        seq.addElement((ASN1Value)this.netAddr);
        seq.addElement((ASN1Value)this.terminalID);
        seq.addElement((ASN1Value)this.pdn);
        seq.addElement((ASN1Value)this.orgName);
        seq.addElement((ASN1Value)this.nui);
        seq.addElement((ASN1Value)this.pn);
        seq.addElement((ASN1Value)this.ouns);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addOptionalElement((ASN1Template)CountryName.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)AdministrationDomainName.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)ExtendedNetworkAddress.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)PrintableString.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)DomainName.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new NumericString.Template());
            this.seqt.addOptionalElement((ASN1Template)PersonalName.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new OrganizationalUnitNames.Template());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new BuiltInStandardAttributes(seq);
        }
    }
}

