/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertExtension;
import th.co.oga.security.pki.Certification.Extension.BasicConstraints;
import th.co.oga.security.pki.OIDs;

public class CertExtensionBasicConstraints
extends CertExtension {
    private static String OID = OIDs.ceBasicConstraints;
    private static boolean critical = true;
    private BasicConstraints ba;

    public CertExtensionBasicConstraints(BasicConstraints basicConstraints) throws ASN1Exception, IOException {
        super(OID, critical, basicConstraints.getBytes());
        this.ba = basicConstraints;
    }

    public CertExtensionBasicConstraints(boolean ca, int len) throws ASN1Exception, IOException {
        this(new BasicConstraints(ca, len));
    }

    public boolean getIsCA() {
        return this.ba.isCA;
    }

    public int getPathLength() {
        return this.ba.pathLenConstraint;
    }

    public static boolean isMe(String oid) {
        return OID.equals(oid);
    }

    public static CertExtensionBasicConstraints getInstance(byte[] bytes) throws ASN1Exception {
        try {
            return new CertExtensionBasicConstraints(BasicConstraints.getInstance(bytes));
        }
        catch (Exception e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    public String getData() {
        return "Subject Type=" + (this.ba.isCA ? "CA" : "NONE") + ", Path Length Constraint=" + this.ba.pathLenConstraint;
    }
}

